/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.azureUtils;

import com.tridium.azureUtils.AzureIotSasTokenUtils;
import com.tridium.azureUtils.AzureSasException;
import com.tridium.azureUtils.Storable;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="tokenStored", type="boolean", defaultValue="false", flags=65), @NiagaraProperty(name="lastGeneratedTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65), @NiagaraProperty(name="nextExpiryTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=65)})
public class BAzureIotSasToken
extends BComponent
implements Storable {
    @Generated
    public static final Property tokenStored = BAzureIotSasToken.newProperty((int)65, (boolean)false, null);
    @Generated
    public static final Property lastGeneratedTime = BAzureIotSasToken.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Property nextExpiryTime = BAzureIotSasToken.newProperty((int)65, (BValue)BAbsTime.DEFAULT, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAzureIotSasToken.class);
    private String tokenValue;
    public static final String KEYRING_ENTRY_TYPE = "AzureSasToken";
    private static final BIcon icon = BIcon.std((String)"keys.png");

    @Generated
    public boolean getTokenStored() {
        return this.getBoolean(tokenStored);
    }

    @Generated
    public void setTokenStored(boolean v) {
        this.setBoolean(tokenStored, v, null);
    }

    @Generated
    public BAbsTime getLastGeneratedTime() {
        return (BAbsTime)this.get(lastGeneratedTime);
    }

    @Generated
    public void setLastGeneratedTime(BAbsTime v) {
        this.set(lastGeneratedTime, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextExpiryTime() {
        return (BAbsTime)this.get(nextExpiryTime);
    }

    @Generated
    public void setNextExpiryTime(BAbsTime v) {
        this.set(nextExpiryTime, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BAzureIotSasToken make(String token, BAbsTime generatedTime, BAbsTime expiryTime) throws AzureSasException {
        BAzureIotSasToken tokenObj = new BAzureIotSasToken();
        tokenObj.setLastGeneratedTime(generatedTime);
        tokenObj.setNextExpiryTime(expiryTime);
        tokenObj.tokenValue = token;
        return tokenObj;
    }

    @Override
    public String getStoreValue() {
        return this.tokenValue;
    }

    @Override
    public String getStoreEntryType() {
        return KEYRING_ENTRY_TYPE;
    }

    @Override
    public void load(String storedValue) {
        this.tokenValue = storedValue;
    }

    @Override
    public void store(String storeKey) throws AzureSasException {
        Storable.super.store(storeKey);
        this.setTokenStored(true);
    }

    public String getTokenValue(String storeKey) throws Exception {
        AzureIotSasTokenUtils.loadFromKeyRing(storeKey, this);
        return this.tokenValue;
    }

    public BIcon getIcon() {
        return icon;
    }
}

