/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.weather;

import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.weather.BSunPosition;
import javax.baja.weather.BWeatherState;
import javax.baja.weather.BWindDirection;
import javax.baja.weather.advisory.BAdvisoryContainer;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75), @NiagaraProperty(name="lastUpdate", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="observed", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=3), @NiagaraProperty(name="sunrise", type="BTime", defaultValue="BTime.DEFAULT", flags=3), @NiagaraProperty(name="sunset", type="BTime", defaultValue="BTime.DEFAULT", flags=3), @NiagaraProperty(name="sunDown", type="BStatusBoolean", defaultValue="new BStatusBoolean(false, BStatus.nullStatus)", flags=3), @NiagaraProperty(name="temp", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="weatherSummary", type="BStatusString", defaultValue="new BStatusString(\"\", BStatus.nullStatus)", flags=3), @NiagaraProperty(name="state", type="BStatusEnum", defaultValue="new BStatusEnum(BWeatherState.clear)", flags=3), @NiagaraProperty(name="humidity", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"percent relative humidity\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="windDirection", type="BStatusEnum", defaultValue="new BStatusEnum(BWindDirection.north, BStatus.nullStatus)", flags=3), @NiagaraProperty(name="windSpeed", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"miles per hour\"))")}), @NiagaraProperty(name="windGust", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"miles per hour\"))")}), @NiagaraProperty(name="windChill", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="pressure", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"inches of mercury\"))")}), @NiagaraProperty(name="dewPoint", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="heatIndex", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"fahrenheit\"), BFacets.PRECISION, BInteger.make(1))")}), @NiagaraProperty(name="visibility", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"mile\"))")}), @NiagaraProperty(name="ozone", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"parts per million\"), BFacets.PRECISION, BInteger.make(3))")}), @NiagaraProperty(name="particulateMatter", type="BStatusNumeric", defaultValue="new BStatusNumeric(0, BStatus.nullStatus)", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"micrograms per cubic meter\"), BFacets.PRECISION, BDouble.make(1))")}), @NiagaraProperty(name="advisories", type="BAdvisoryContainer", defaultValue="new BAdvisoryContainer()")})
public class BCurrentConditions
extends BComponent
implements BIComparable {
    @Generated
    public static final Property status = BCurrentConditions.newProperty((int)75, (BValue)BStatus.ok, null);
    @Generated
    public static final Property lastUpdate = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property observed = BCurrentConditions.newProperty((int)3, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property sunrise = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    @Generated
    public static final Property sunset = BCurrentConditions.newProperty((int)3, (BValue)BTime.DEFAULT, null);
    @Generated
    public static final Property sunDown = BCurrentConditions.newProperty((int)3, (BValue)new BStatusBoolean(false, BStatus.nullStatus), null);
    @Generated
    public static final Property temp = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property weatherSummary = BCurrentConditions.newProperty((int)3, (BValue)new BStatusString("", BStatus.nullStatus), null);
    @Generated
    public static final Property state = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWeatherState.clear), null);
    @Generated
    public static final Property humidity = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"percent relative humidity"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property windDirection = BCurrentConditions.newProperty((int)3, (BValue)new BStatusEnum((BEnum)BWindDirection.north, BStatus.nullStatus), null);
    @Generated
    public static final Property windSpeed = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    @Generated
    public static final Property windGust = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"miles per hour")));
    @Generated
    public static final Property windChill = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property pressure = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"inches of mercury")));
    @Generated
    public static final Property dewPoint = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property heatIndex = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"fahrenheit"), (String)"precision", (BIDataValue)BInteger.make((int)1)));
    @Generated
    public static final Property visibility = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"mile")));
    @Generated
    public static final Property ozone = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"parts per million"), (String)"precision", (BIDataValue)BInteger.make((int)3)));
    @Generated
    public static final Property particulateMatter = BCurrentConditions.newProperty((int)3, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"micrograms per cubic meter"), (String)"precision", (BIDataValue)BDouble.make((double)1.0)));
    @Generated
    public static final Property advisories = BCurrentConditions.newProperty((int)0, (BValue)new BAdvisoryContainer(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BCurrentConditions.class);
    private static final BIcon icon = BIcon.make((String)"module://weather/icons/weather.png");

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastUpdate() {
        return (BAbsTime)this.get(lastUpdate);
    }

    @Generated
    public void setLastUpdate(BAbsTime v) {
        this.set(lastUpdate, (BValue)v, null);
    }

    @Generated
    public BAbsTime getObserved() {
        return (BAbsTime)this.get(observed);
    }

    @Generated
    public void setObserved(BAbsTime v) {
        this.set(observed, (BValue)v, null);
    }

    @Generated
    public BTime getSunrise() {
        return (BTime)this.get(sunrise);
    }

    @Generated
    public void setSunrise(BTime v) {
        this.set(sunrise, (BValue)v, null);
    }

    @Generated
    public BTime getSunset() {
        return (BTime)this.get(sunset);
    }

    @Generated
    public void setSunset(BTime v) {
        this.set(sunset, (BValue)v, null);
    }

    @Generated
    public BStatusBoolean getSunDown() {
        return (BStatusBoolean)this.get(sunDown);
    }

    @Generated
    public void setSunDown(BStatusBoolean v) {
        this.set(sunDown, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getTemp() {
        return (BStatusNumeric)this.get(temp);
    }

    @Generated
    public void setTemp(BStatusNumeric v) {
        this.set(temp, (BValue)v, null);
    }

    @Generated
    public BStatusString getWeatherSummary() {
        return (BStatusString)this.get(weatherSummary);
    }

    @Generated
    public void setWeatherSummary(BStatusString v) {
        this.set(weatherSummary, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getState() {
        return (BStatusEnum)this.get(state);
    }

    @Generated
    public void setState(BStatusEnum v) {
        this.set(state, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getHumidity() {
        return (BStatusNumeric)this.get(humidity);
    }

    @Generated
    public void setHumidity(BStatusNumeric v) {
        this.set(humidity, (BValue)v, null);
    }

    @Generated
    public BStatusEnum getWindDirection() {
        return (BStatusEnum)this.get(windDirection);
    }

    @Generated
    public void setWindDirection(BStatusEnum v) {
        this.set(windDirection, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getWindSpeed() {
        return (BStatusNumeric)this.get(windSpeed);
    }

    @Generated
    public void setWindSpeed(BStatusNumeric v) {
        this.set(windSpeed, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getWindGust() {
        return (BStatusNumeric)this.get(windGust);
    }

    @Generated
    public void setWindGust(BStatusNumeric v) {
        this.set(windGust, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getWindChill() {
        return (BStatusNumeric)this.get(windChill);
    }

    @Generated
    public void setWindChill(BStatusNumeric v) {
        this.set(windChill, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getPressure() {
        return (BStatusNumeric)this.get(pressure);
    }

    @Generated
    public void setPressure(BStatusNumeric v) {
        this.set(pressure, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getDewPoint() {
        return (BStatusNumeric)this.get(dewPoint);
    }

    @Generated
    public void setDewPoint(BStatusNumeric v) {
        this.set(dewPoint, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getHeatIndex() {
        return (BStatusNumeric)this.get(heatIndex);
    }

    @Generated
    public void setHeatIndex(BStatusNumeric v) {
        this.set(heatIndex, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getVisibility() {
        return (BStatusNumeric)this.get(visibility);
    }

    @Generated
    public void setVisibility(BStatusNumeric v) {
        this.set(visibility, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getOzone() {
        return (BStatusNumeric)this.get(ozone);
    }

    @Generated
    public void setOzone(BStatusNumeric v) {
        this.set(ozone, (BValue)v, null);
    }

    @Generated
    public BStatusNumeric getParticulateMatter() {
        return (BStatusNumeric)this.get(particulateMatter);
    }

    @Generated
    public void setParticulateMatter(BStatusNumeric v) {
        this.set(particulateMatter, (BValue)v, null);
    }

    @Generated
    public BAdvisoryContainer getAdvisories() {
        return (BAdvisoryContainer)this.get(advisories);
    }

    @Generated
    public void setAdvisories(BAdvisoryContainer v) {
        this.set(advisories, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final void setSun(double lon, double lat) {
        BSunPosition sun = BSunPosition.make(lat, lon);
        this.setSunrise(BTime.make((BAbsTime)sun.getSunrise()));
        this.setSunset(BTime.make((BAbsTime)sun.getSunset()));
        this.setSunDown(new BStatusBoolean(sun.getCurrentElevation() < 0.0, BStatus.ok));
    }

    public void changed(Property property, Context context) {
        if (property.equals(status)) {
            BStatusValue[] values;
            for (BStatusValue value : values = (BStatusValue[])this.getChildren(BStatusValue.class)) {
                value.setStatus(BStatus.make((int)(value.getStatus().getBits() & 0x48 | this.getStatus().getBits() & 0x16)));
            }
        }
        super.changed(property, context);
    }

    public String toString(Context context) {
        BFacets mergedFacets = this.getSlotFacets((Slot)temp);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)temp));
        }
        String stemp = this.getTemp().getValueValue().toString((Context)mergedFacets);
        mergedFacets = this.getSlotFacets((Slot)state);
        if (context != null) {
            mergedFacets = BFacets.make((BFacets)context.getFacets(), (BFacets)this.getSlotFacets((Slot)state));
        }
        String sstate = this.getState().getValueValue().toString((Context)mergedFacets);
        if (this.getTemp().getStatus().isNull()) {
            stemp = "-";
        }
        if (this.getState().getStatus().isNull()) {
            sstate = "-";
        }
        return stemp + ", " + sstate + ' ' + this.getStatus().toString(context);
    }

    public int compareTo(Object obj) {
        if (!(obj instanceof BCurrentConditions)) {
            return 0;
        }
        BCurrentConditions conditions = (BCurrentConditions)((Object)obj);
        return Double.compare(this.getTemp().getValue(), conditions.getTemp().getValue());
    }

    public BIcon getIcon() {
        return icon;
    }
}

