/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather.nws;

import com.tridium.weather.nws.BNwsWeatherProvider;
import com.tridium.weather.nws.FeedReader;
import com.tridium.weather.nws.NwsStationList;
import java.io.IOException;
import java.util.ArrayList;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BajaException;
import javax.baja.sys.Context;
import javax.baja.weather.BForecast;
import javax.baja.weather.BWeatherState;
import javax.baja.xml.XElem;
import javax.baja.xml.XText;

public class NwsForecastReader {
    BNwsWeatherProvider provider;
    private static final int MAX_REDIRECTS = 5;

    public NwsForecastReader(BNwsWeatherProvider provider) {
        this.provider = provider;
    }

    public XElem getFeed(NwsStationList.Station station, int numDays) throws Exception {
        return this.getFeed(station, numDays, this.provider.getForecastServer(), this.provider.getForecastPath());
    }

    XElem getFeed(NwsStationList.Station station, int numDays, String host, String uri) throws Exception {
        XElem root;
        String startDate = BAbsTime.now().toString((Context)BFacets.make((String)"timeFormat", (String)"YYYY-MM-DD"));
        StringBuilder requestUri = new StringBuilder(uri);
        requestUri.append('?');
        requestUri.append("&lat=").append(station.latitude);
        requestUri.append("&lon=").append(station.longitude);
        requestUri.append("&format=24+hourly");
        requestUri.append("&startDate=").append(startDate);
        requestUri.append("&numDays=").append(numDays);
        try {
            root = FeedReader.getXmlFeed(host, requestUri.toString(), 5, false);
        }
        catch (IOException exception) {
            throw new BajaException("Unable to get NWS Forecast feed", (Throwable)exception);
        }
        if (root.name().equals("error")) {
            XElem pre = root.elem("pre");
            if (pre != null) {
                XText text;
                XElem problem = pre.elem("problem");
                if (problem != null && (text = problem.text()) != null) {
                    throw new NwsException(text.toString());
                }
                text = pre.text();
                if (text != null) {
                    throw new NwsException(text.toString());
                }
            }
            throw new NwsException();
        }
        return root.elem("data");
    }

    public BForecast[] getForecast(NwsStationList.Station station, int numDays) throws Exception {
        BForecast[] forecasts;
        XElem root = this.getFeed(station, numDays);
        for (BForecast forecast : forecasts = this.parseDwml(root)) {
            forecast.setSun(forecast.getDate(), station.latitude, station.longitude);
        }
        return forecasts;
    }

    private BForecast[] parseDwml(XElem root) {
        XElem[] data;
        BStatusNumeric[] max = new BStatusNumeric[]{};
        BStatusNumeric[] min = new BStatusNumeric[]{};
        BStatusNumeric[] cop = new BStatusNumeric[]{};
        BStatusString[] sum = new BStatusString[]{};
        XElem[] params = null;
        for (XElem aData : data = root.elems()) {
            if (!aData.name().equals("parameters")) continue;
            params = aData.elems();
        }
        if (params != null) {
            for (XElem p : params) {
                if (p.name().equals("temperature")) {
                    String type = p.get("type", "");
                    if (type.equals("maximum")) {
                        max = NwsForecastReader.parseTemp(p);
                        continue;
                    }
                    if (!type.equals("minimum")) continue;
                    min = NwsForecastReader.parseTemp(p);
                    continue;
                }
                if (p.name().equals("probability-of-precipitation")) {
                    cop = NwsForecastReader.parseCop(p);
                    continue;
                }
                if (!p.name().equals("weather")) continue;
                sum = NwsForecastReader.parseSummary(p);
            }
        }
        BAbsTime day = BAbsTime.now();
        BForecast[] f = new BForecast[Math.min(max.length, min.length)];
        for (int i = 0; i < f.length; ++i) {
            BForecast z = f[i] = new BForecast();
            z.setLastUpdate(BAbsTime.now());
            z.setDate(day);
            z.setHigh(max[i]);
            z.setLow(min[i]);
            z.setPrecipChance(cop[i]);
            if (sum.length > 0) {
                BWeatherState state = BWeatherState.make(sum[i].getValue());
                z.setWeatherSummary(sum[i]);
                z.setState(new BStatusEnum((BEnum)state));
            } else {
                z.setWeatherSummary(new BStatusString("Unknown"));
                z.setState(new BStatusEnum((BEnum)BWeatherState.unknown));
            }
            day = day.nextDay();
        }
        return f;
    }

    private static BStatusNumeric[] parseTemp(XElem elem) {
        XElem[] kids;
        ArrayList<String> list = new ArrayList<String>();
        for (XElem kid : kids = elem.elems()) {
            if (!kid.name().equals("value")) continue;
            list.add(kid.string());
        }
        BStatusNumeric[] f = new BStatusNumeric[list.size()];
        for (int i = 0; i < f.length; ++i) {
            try {
                f[i] = new BStatusNumeric((double)Float.parseFloat((String)list.get(i)));
                continue;
            }
            catch (Exception e) {
                f[i] = new BStatusNumeric(0.0, BStatus.nullStatus);
            }
        }
        return f;
    }

    private static BStatusNumeric[] parseCop(XElem elem) {
        XElem[] kids;
        ArrayList<String> list = new ArrayList<String>();
        for (XElem kid : kids = elem.elems()) {
            if (!kid.name().equals("value")) continue;
            list.add(kid.string());
        }
        BStatusNumeric[] f = new BStatusNumeric[list.size()];
        int i = 0;
        for (int j = 0; j < f.length; ++j) {
            try {
                int day = Integer.parseInt((String)list.get(j++));
                int night = Integer.parseInt((String)list.get(j));
                f[i] = new BStatusNumeric((double)((int)(((double)day + (double)night) / 2.0)));
            }
            catch (Exception e) {
                f[i] = new BStatusNumeric(0.0, BStatus.nullStatus);
            }
            ++i;
        }
        return f;
    }

    private static BStatusString[] parseSummary(XElem elem) {
        XElem[] kids;
        ArrayList<BStatusString> list = new ArrayList<BStatusString>();
        for (XElem kid : kids = elem.elems()) {
            if (!kid.name().equals("weather-conditions")) continue;
            String z = kid.get("weather-summary", null);
            if (z != null) {
                list.add(new BStatusString(z));
                continue;
            }
            list.add(new BStatusString("", BStatus.nullStatus));
        }
        return list.toArray(new BStatusString[0]);
    }

    public static class NwsException
    extends Exception {
        public NwsException(String s) {
            super(s);
        }

        public NwsException() {
        }
    }
}

