/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.weather;

import java.security.InvalidParameterException;

public class AirQualityIndexUtil {
    private static final double[][] O3 = new double[][]{{0.0, 0.054, 0.0, 50.0}, {0.055, 0.07, 51.0, 100.0}, {0.071, 0.085, 101.0, 150.0}, {0.086, 0.105, 151.0, 200.0}, {0.106, 0.2, 201.0, 300.0}, {0.405, 0.504, 301.0, 400.0}, {0.505, 0.604, 401.0, 500.0}};
    private static final double[][] PM25 = new double[][]{{0.0, 12.0, 0.0, 50.0}, {12.1, 35.4, 51.0, 100.0}, {35.5, 55.4, 101.0, 150.0}, {55.5, 150.4, 151.0, 200.0}, {150.5, 250.4, 201.0, 300.0}, {250.5, 350.4, 301.0, 400.0}, {350.5, 500.4, 401.0, 500.0}};

    public static double aqiToOzoneConcentration(int aqi) {
        return AirQualityIndexUtil.aqiToConcentration(O3, aqi);
    }

    public static int ozoneConcentrationToAqi(double concentration) {
        return AirQualityIndexUtil.concentrationToAqi(O3, concentration);
    }

    public static double aqiToParticulateConcentration(int aqi) {
        return AirQualityIndexUtil.aqiToConcentration(PM25, aqi);
    }

    public static int particulateConcentrationToAqi(double concentration) {
        return AirQualityIndexUtil.concentrationToAqi(PM25, concentration);
    }

    private static double aqiToConcentration(double[][] conv, int aqi) {
        for (double[] aConv : conv) {
            double aqiLow = aConv[2];
            double aqiHigh = aConv[3];
            if (!((double)aqi >= aqiLow) || !((double)aqi <= aqiHigh)) continue;
            double concentrationLow = aConv[0];
            double concentrationHigh = aConv[1];
            return concentrationLow + ((double)aqi - aqiLow) * ((concentrationHigh - concentrationLow) / (aqiHigh - aqiLow));
        }
        throw new InvalidParameterException("Invalid AQI value: " + aqi);
    }

    private static int concentrationToAqi(double[][] conv, double concentration) {
        for (double[] aConv : conv) {
            double concentrationLow = aConv[0];
            double concentrationHigh = aConv[1];
            if (!(concentration >= concentrationLow) || !(concentration <= concentrationHigh)) continue;
            double aqiLow = aConv[2];
            double aqiHigh = aConv[3];
            return (int)Math.ceil((aqiHigh - aqiLow) * ((concentration - concentrationLow) / (concentrationHigh - concentrationLow)) + aqiLow);
        }
        throw new InvalidParameterException("Invalid concentration value: " + concentration);
    }
}

