/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.user;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.category.Category;
import com.tridium.workbench.user.BPermissionGrid;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.role.BRole;
import javax.baja.security.BPermissionsMap;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.table.BTable;
import javax.baja.user.BUser;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbPlugin;

@NiagaraType
@NiagaraAction(name="updateUserPermissions", flags=4)
public final class BPermissionsBrowserUserRolesEditor
extends BWbPlugin {
    @Generated
    public static final Action updateUserPermissions = BPermissionsBrowserUserRolesEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPermissionsBrowserUserRolesEditor.class);
    private static final LexiconModule LEXICON_MODULE = LexiconModule.make((Type)TYPE);
    private final BUser user;
    private final Category[] categories;
    private final BPermissionsMap viewUserPermissions;
    private final BRole[] roles;
    private final BPermissionsMap[] rolePermissions;
    private final Context context;
    private BLabel userPermissionsLabel;
    private final Map<BRole, BPermissionGrid> roleGridMap = new LinkedHashMap<BRole, BPermissionGrid>();

    @Generated
    public void updateUserPermissions() {
        this.invoke(updateUserPermissions, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPermissionsBrowserUserRolesEditor() {
        throw new IllegalStateException("fw use only");
    }

    private BPermissionsBrowserUserRolesEditor(BUser user, Category[] categories, BPermissionsMap viewUserPermissions, BRole[] roles, BPermissionsMap[] rolePermissions, Context context) {
        this.user = user;
        this.categories = categories;
        this.viewUserPermissions = viewUserPermissions;
        this.roles = roles;
        this.rolePermissions = rolePermissions;
        this.context = context;
    }

    private void initContent() {
        BLabel userPermissionsTitle = new BLabel(LEXICON_MODULE.getText("permissions.effectivePermissions", this.context), Theme.widget().getBoldText());
        userPermissionsTitle.setHalign(BHalign.left);
        this.userPermissionsLabel = new BLabel();
        this.userPermissionsLabel.setHalign(BHalign.left);
        BInsets padding = BInsets.make((double)3.0, (double)0.0, (double)Theme.scrollBar().getFixedWidth(), (double)0.0);
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.userPermissionsLabel, padding));
        scrollPane.setVpolicy(BScrollBarPolicy.never);
        scrollPane.setViewportBackground(Theme.widget().getControlBackground());
        scrollPane.setBorderPolicy(BScrollBarPolicy.never);
        BEdgePane userPermissionsEdgePane = new BEdgePane();
        userPermissionsEdgePane.setTop((BWidget)userPermissionsTitle);
        userPermissionsEdgePane.setCenter((BWidget)scrollPane);
        BBorderPane borderPane = new BBorderPane((BWidget)userPermissionsEdgePane);
        BTabbedPane tabbedPane = new BTabbedPane();
        tabbedPane.setPaintFullBorder(false);
        this.addRolePanes(tabbedPane);
        this.doUpdateUserPermissions();
        BEdgePane mainEdgePane = new BEdgePane();
        mainEdgePane.setTop((BWidget)borderPane);
        mainEdgePane.setCenter((BWidget)tabbedPane);
        this.setContent((BWidget)mainEdgePane);
    }

    private void updateUserPermissionsLabel(BPermissionsMap userPermissions) {
        this.userPermissionsLabel.setText(userPermissions.equals((Object)BPermissionsMap.DEFAULT) ? LEXICON_MODULE.getText("roleManager.noPermissions", this.context) : userPermissions.toString());
    }

    private void addRolePanes(BTabbedPane tabbedPane) {
        Set userRoleNames = this.user.getRoleIds();
        for (int i = 0; i < this.roles.length; ++i) {
            if (!userRoleNames.contains(SlotPath.unescape((String)this.roles[i].getName()))) continue;
            BPermissionGrid grid = new BPermissionGrid(this.categories, this.rolePermissions[i], this.viewUserPermissions);
            this.roleGridMap.put(this.roles[i], grid);
            BLabelPane labelPane = new BLabelPane(new BLabel(this.roles[i].getDisplayName(this.context)), (BWidget)grid);
            if (this.roles[i].getEnabled()) {
                this.linkTo((BComponent)grid.table, (Slot)BTable.tableModified, (Slot)updateUserPermissions);
            } else {
                labelPane.setEnabled(false);
            }
            tabbedPane.addPane(labelPane);
        }
    }

    public void doUpdateUserPermissions() {
        BPermissionsMap userPermissions = BPermissionsMap.DEFAULT;
        for (Map.Entry<BRole, BPermissionGrid> entry : this.roleGridMap.entrySet()) {
            BRole role = entry.getKey();
            if (!role.getEnabled()) continue;
            BPermissionsMap rolePermissions = entry.getValue().save();
            if (rolePermissions.isSuperUser()) {
                userPermissions = BPermissionsMap.SUPER_USER;
                break;
            }
            userPermissions = userPermissions.or(rolePermissions);
        }
        this.updateUserPermissionsLabel(userPermissions);
    }

    public Map<BRole, BPermissionsMap> getRolePermissionsMaps() {
        HashMap<BRole, BPermissionsMap> result = new HashMap<BRole, BPermissionsMap>();
        for (Map.Entry<BRole, BPermissionGrid> entry : this.roleGridMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().save());
        }
        return result;
    }

    public static class Builder {
        private BUser user;
        private Category[] categories;
        private BPermissionsMap viewUserPermissions;
        private BRole[] roles;
        private BPermissionsMap[] rolePermissions;

        public Builder forUser(BUser user) {
            this.user = user;
            return this;
        }

        public Builder withCategories(Category[] categories) {
            this.categories = categories;
            return this;
        }

        public Builder withViewUserPermissions(BPermissionsMap viewUserPermissions) {
            this.viewUserPermissions = viewUserPermissions;
            return this;
        }

        public Builder forRoles(BRole[] roles) {
            this.roles = roles;
            return this;
        }

        public Builder forRolePermissions(BPermissionsMap[] rolePermissions) {
            this.rolePermissions = rolePermissions;
            return this;
        }

        public BPermissionsBrowserUserRolesEditor makeEditor(Context context) {
            Objects.requireNonNull(this.user, "user");
            Objects.requireNonNull(this.categories, "categories");
            Objects.requireNonNull(this.viewUserPermissions, "viewUserPermissions");
            Objects.requireNonNull(this.roles, "roles");
            Objects.requireNonNull(this.rolePermissions, "rolePermissions");
            BPermissionsBrowserUserRolesEditor editor = new BPermissionsBrowserUserRolesEditor(this.user, this.categories, this.viewUserPermissions, this.roles, this.rolePermissions, context);
            editor.initContent();
            return editor;
        }
    }
}

