/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BITemplate;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.Array;

public class NewStationUtil {
    private static final Logger log = Logger.getLogger("wbutil");
    private static final BIFile[] BI_FILES = new BIFile[0];

    private NewStationUtil() {
    }

    public static BIFile[] getDefaultNewStationTemplates() {
        try {
            BDirectory directory = (BDirectory)BOrd.make((String)"file:!defaults/workbench/newStations").get();
            return directory.listFiles();
        }
        catch (UnresolvedException e) {
            return BI_FILES;
        }
    }

    public static BIFile[] getUserNewStationTemplates(BDirectory userNewStationDirectory) {
        ArrayList<BIFile> templateFiles = new ArrayList<BIFile>();
        NewStationUtil.getUserStationTemplates(templateFiles, userNewStationDirectory);
        return templateFiles.toArray(BI_FILES);
    }

    private static void getUserStationTemplates(List<BIFile> templateFilesList, BDirectory userNewStationDirectory) {
        if (userNewStationDirectory == null) {
            return;
        }
        try {
            BIFile[] children = userNewStationDirectory.listFiles();
            if (children == null || children.length <= 0) {
                return;
            }
            for (BIFile child : children) {
                if (child instanceof BDirectory) {
                    NewStationUtil.getUserStationTemplates(templateFilesList, (BDirectory)child);
                    continue;
                }
                templateFilesList.add(child);
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Exception occurred while listing user station templates: " + e);
        }
    }

    public static BDirectory getUserNewStationDirectory() {
        try {
            return BFileSystem.INSTANCE.makeDir(new FilePath("~stationTemplates"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static BIFile[] getNewStationTemplates() {
        BIFile[] biFiles;
        Array templates = new Array(BIFile.class);
        templates.addAll((Object[])NewStationUtil.getDefaultNewStationTemplates());
        for (BIFile newFile : biFiles = NewStationUtil.getUserNewStationTemplates(NewStationUtil.getUserNewStationDirectory())) {
            templates.add((Object)newFile);
        }
        Collections.sort(templates.list());
        return (BIFile[])templates.filter(obj -> obj instanceof BIFile && obj instanceof BITemplate && !(obj instanceof BDirectory) && ((BIFile)obj).getExtension().equals("ntpl")).trim();
    }
}

