/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.tools;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.util.LabelUtil;
import com.tridium.util.ObjectUtil;
import com.tridium.workbench.fieldeditors.BAbsTimeFE;
import com.tridium.workbench.fieldeditors.BIntegerFE;
import java.security.AccessController;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesException;
import java.time.zone.ZoneRulesProvider;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NavigableMap;
import java.util.TimeZone;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbView;

@NiagaraType(agent={@AgentOn(types={"wbutil:TimeZoneViewerTool"})})
@NiagaraActions(value={@NiagaraAction(name="databaseTimeZoneModified", flags=4), @NiagaraAction(name="dstCalculatorValuesModified", flags=4), @NiagaraAction(name="calculatorSourceTimeZoneModified", flags=4), @NiagaraAction(name="calculatorTargetTimeZoneModified", flags=4), @NiagaraAction(name="calculatorSourceTimeModified", flags=4)})
public class BTimeZoneViewer
extends BWbView {
    @Generated
    public static final Action databaseTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    @Generated
    public static final Action dstCalculatorValuesModified = BTimeZoneViewer.newAction((int)4, null);
    @Generated
    public static final Action calculatorSourceTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    @Generated
    public static final Action calculatorTargetTimeZoneModified = BTimeZoneViewer.newAction((int)4, null);
    @Generated
    public static final Action calculatorSourceTimeModified = BTimeZoneViewer.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeZoneViewer.class);
    public static BFont BOLD_TEXT_FONT = Theme.widget().getBoldText();
    private static final Lexicon lex = Lexicon.make((String)"wbutil");
    private BTabbedPane tabbedPane = null;
    private BBorderPane borderedMetaPane = null;
    private BEdgePane metaEdgePane = null;
    private BGridPane metaTopPane = null;
    private BLabel metaVersionLabel = null;
    private BTextEditor americasZonesProvided = null;
    private BTextEditor indianZonesProvided = null;
    private BTextEditor canadaZonesProvided = null;
    private BTextEditor asiaZonesProvided = null;
    private BTextEditor africaZonesProvided = null;
    private BTextEditor atlanticZonesProvided = null;
    private BTextEditor europeZonesProvided = null;
    private BTextEditor antarcticaZonesProvided = null;
    private BTextEditor australiaZonesProvided = null;
    private BTextEditor otherZonesProvided = null;
    private BTextEditor pacificZonesProvided = null;
    private BTextEditor usZonesProvided = null;
    private BTextEditor etcZonesProvided = null;
    private BBorderPane borderedDstPane = null;
    private BGridPane dstPane = null;
    private BListDropDown dstTimeZoneDropDown = null;
    private BIntegerFE targetYear = null;
    private BLabel dstStartTime = null;
    private BLabel dstEndTime = null;
    private BLabel inDaylightNow = null;
    private BBorderPane borderedCalculatorPane = null;
    private BGridPane calculatorPane = null;
    private BAbsTimeFE sourceTimeFE = null;
    private BAbsTimeFE targetTimeFE = null;
    private BListDropDown sourceTimeZoneDropDown = null;
    private BListDropDown targetTimeZoneDropDown = null;
    private BBorderPane borderedDatabasePane = null;
    private BGridPane databasePane = null;
    private BListDropDown databaseTimeZoneDropDown = null;
    private BAbsTimeFE currentTimeInTimeZoneFE = null;
    private BGridPane activeEraPane = null;
    private BLabel utcOffsetLabel = null;
    private BLabel standardNameLabel = null;
    private BLabel observesDaylightSavingLabel = null;
    private BLabel dstStartRuleLabel = null;
    private BLabel dstEndsRuleLabel = null;
    private BLabel dstAdjustmentLabel = null;
    private BLabel daylightNameLabel = null;
    private static final BTimeZone[] zonesAsZones = TimeZoneDatabase.get().getTimeZones();
    private static final BFacets yearFacets = BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1900), BInteger.make((int)9999), BInteger.make((int)5)});
    private static final String LINE_SEPARATOR = AccessController.doPrivileged(() -> System.getProperty("line.separator", "\n"));

    @Generated
    public void databaseTimeZoneModified() {
        this.invoke(databaseTimeZoneModified, null, null);
    }

    @Generated
    public void dstCalculatorValuesModified() {
        this.invoke(dstCalculatorValuesModified, null, null);
    }

    @Generated
    public void calculatorSourceTimeZoneModified() {
        this.invoke(calculatorSourceTimeZoneModified, null, null);
    }

    @Generated
    public void calculatorTargetTimeZoneModified() {
        this.invoke(calculatorTargetTimeZoneModified, null, null);
    }

    @Generated
    public void calculatorSourceTimeModified() {
        this.invoke(calculatorSourceTimeModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void deactivated() {
        super.deactivated();
        this.tabbedPane = null;
        this.borderedMetaPane = null;
        this.metaEdgePane = null;
        this.metaTopPane = null;
        this.metaVersionLabel = null;
        this.americasZonesProvided = null;
        this.indianZonesProvided = null;
        this.canadaZonesProvided = null;
        this.asiaZonesProvided = null;
        this.africaZonesProvided = null;
        this.atlanticZonesProvided = null;
        this.europeZonesProvided = null;
        this.antarcticaZonesProvided = null;
        this.australiaZonesProvided = null;
        this.otherZonesProvided = null;
        this.pacificZonesProvided = null;
        this.usZonesProvided = null;
        this.etcZonesProvided = null;
        this.borderedCalculatorPane = null;
        this.calculatorPane = null;
        this.sourceTimeFE = null;
        this.targetTimeFE = null;
        this.sourceTimeZoneDropDown = null;
        this.targetTimeZoneDropDown = null;
        this.borderedDatabasePane = null;
        this.databasePane = null;
        this.databaseTimeZoneDropDown = null;
        this.currentTimeInTimeZoneFE = null;
        this.activeEraPane = null;
        this.utcOffsetLabel = null;
        this.standardNameLabel = null;
        this.observesDaylightSavingLabel = null;
        this.dstStartRuleLabel = null;
        this.dstEndsRuleLabel = null;
        this.dstAdjustmentLabel = null;
        this.daylightNameLabel = null;
        this.dstPane = null;
        this.dstTimeZoneDropDown = null;
        this.targetYear = null;
        this.dstStartTime = null;
        this.dstEndTime = null;
        this.inDaylightNow = null;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        if (zonesAsZones.length <= 0) {
            BGridPane errorPane = new BGridPane(2);
            errorPane.setHalign(BHalign.left);
            errorPane.setValign(BValign.top);
            errorPane.setColumnGap(10.0);
            errorPane.setRowGap(6.0);
            errorPane.setColorRows(false);
            errorPane.add("error", (BValue)new BLabel("Time Zone Database Unavailable."));
            this.setContent((BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)errorPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT));
            return;
        }
        this.tabbedPane = new BTabbedPane();
        this.metaTopPane = new BGridPane(2);
        this.metaTopPane.setHalign(BHalign.left);
        this.metaTopPane.setValign(BValign.top);
        this.metaTopPane.setColumnAlign(BHalign.left);
        this.metaTopPane.setColumnGap(10.0);
        this.metaTopPane.setRowGap(6.0);
        this.metaTopPane.setColorRows(false);
        NavigableMap<String, ZoneRules> versions = null;
        String firstVersion = null;
        try {
            versions = ZoneRulesProvider.getVersions(TimeZone.getDefault().getID());
            firstVersion = (String)versions.firstKey();
        }
        catch (ZoneRulesException zre) {
            firstVersion = "Unknown";
        }
        this.metaVersionLabel = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.metaTopPane, BTimeZoneViewer.text("meta.version"), (BWidget)this.metaVersionLabel, true);
        this.metaVersionLabel.setText(firstVersion);
        this.metaEdgePane = new BEdgePane();
        this.metaEdgePane.setTop((BWidget)this.metaTopPane);
        Object[] zonesAsString = TimeZoneDatabase.getAllSupportedZoneIds();
        Arrays.sort(zonesAsString);
        StringBuilder africaZonesProvidedBuffer = new StringBuilder();
        StringBuilder americasZonesProvidedBuffer = new StringBuilder();
        StringBuilder antarcticaZonesProvidedBuffer = new StringBuilder();
        StringBuilder asiaZonesProvidedBuffer = new StringBuilder();
        StringBuilder atlanticZonesProvidedBuffer = new StringBuilder();
        StringBuilder australiaZonesProvidedBuffer = new StringBuilder();
        StringBuilder europeZonesProvidedBuffer = new StringBuilder();
        StringBuilder otherZonesProvidedBuffer = new StringBuilder();
        StringBuilder pacificZonesProvidedBuffer = new StringBuilder();
        StringBuilder usZonesProvidedBuffer = new StringBuilder();
        StringBuilder indianZonesProvidedBuffer = new StringBuilder();
        StringBuilder canadaZonesProvidedBuffer = new StringBuilder();
        StringBuilder etcZonesProvidedBuffer = new StringBuilder();
        for (int i = 0; i < zonesAsString.length; ++i) {
            if (((String)zonesAsString[i]).startsWith("Africa/")) {
                africaZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Atlantic/")) {
                atlanticZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("America/")) {
                americasZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Antarctica/")) {
                antarcticaZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Asia/")) {
                asiaZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Australia/")) {
                australiaZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Canada/")) {
                canadaZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Etc/")) {
                etcZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Europe/")) {
                europeZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Indian/")) {
                indianZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("Pacific/")) {
                pacificZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            if (((String)zonesAsString[i]).startsWith("US/")) {
                usZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
                continue;
            }
            otherZonesProvidedBuffer.append((String)zonesAsString[i] + LINE_SEPARATOR);
        }
        this.africaZonesProvided = new BTextEditor(africaZonesProvidedBuffer.toString(), false);
        this.americasZonesProvided = new BTextEditor(americasZonesProvidedBuffer.toString(), false);
        this.antarcticaZonesProvided = new BTextEditor(antarcticaZonesProvidedBuffer.toString(), false);
        this.asiaZonesProvided = new BTextEditor(asiaZonesProvidedBuffer.toString(), false);
        this.atlanticZonesProvided = new BTextEditor(atlanticZonesProvidedBuffer.toString(), false);
        this.australiaZonesProvided = new BTextEditor(australiaZonesProvidedBuffer.toString(), false);
        this.europeZonesProvided = new BTextEditor(europeZonesProvidedBuffer.toString(), false);
        this.otherZonesProvided = new BTextEditor(otherZonesProvidedBuffer.toString(), false);
        this.pacificZonesProvided = new BTextEditor(pacificZonesProvidedBuffer.toString(), false);
        this.usZonesProvided = new BTextEditor(usZonesProvidedBuffer.toString(), false);
        this.indianZonesProvided = new BTextEditor(indianZonesProvidedBuffer.toString(), false);
        this.canadaZonesProvided = new BTextEditor(canadaZonesProvidedBuffer.toString(), false);
        this.etcZonesProvided = new BTextEditor(etcZonesProvidedBuffer.toString(), false);
        BTabbedPane zonesProvidedTabPane = new BTabbedPane();
        BScrollPane scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.africaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Africa", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.americasZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Americas", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.antarcticaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Antarctica", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.asiaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Asia", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.atlanticZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Atlantic", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.australiaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Australia", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.canadaZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Canada", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.europeZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Europe", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.etcZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Etc", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.indianZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Indian", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.otherZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Other", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.pacificZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("Pacific", false), (BWidget)scrollPane);
        scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.usZonesProvided, 5.0, 5.0, 5.0, 5.0));
        scrollPane.setViewportBackground(Theme.scrollPane().getControlBackground());
        zonesProvidedTabPane.addPane(BTimeZoneViewer.makeLabel("US", false), (BWidget)scrollPane);
        BBorderPane labelSpacer = new BBorderPane((BWidget)BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("meta.zonesProvided"), true), BInsets.make((double)9.0, (double)0.0, (double)0.0, (double)0.0));
        this.metaEdgePane.setCenter((BWidget)new BEdgePane((BWidget)labelSpacer, null, null, null, (BWidget)new BBorderPane((BWidget)zonesProvidedTabPane, 5.0, 5.0, 5.0, 5.0)));
        this.borderedMetaPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.metaEdgePane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.databasePane = new BGridPane(2);
        this.databasePane.setHalign(BHalign.left);
        this.databasePane.setValign(BValign.top);
        this.databasePane.setColumnAlign(BHalign.left);
        this.databasePane.setColumnGap(10.0);
        this.databasePane.setRowGap(6.0);
        this.databasePane.setColorRows(false);
        this.databaseTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.databasePane, BTimeZoneViewer.text("database.sourceTimeZone"), (BWidget)this.databaseTimeZoneDropDown, true);
        this.currentTimeInTimeZoneFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.databasePane, BTimeZoneViewer.text("database.currentTime"), (BWidget)this.currentTimeInTimeZoneFE, true);
        this.databaseTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.databaseTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.databaseTimeZoneDropDown.getList().setMultipleSelection(false);
        BTimeZone current = (BTimeZone)this.databaseTimeZoneDropDown.getSelectedItem();
        if (current == null) {
            current = BTimeZone.UTC;
        }
        this.currentTimeInTimeZoneFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)current));
        this.currentTimeInTimeZoneFE.setReadonly(true);
        this.linkTo(null, (BComponent)this.databaseTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)databaseTimeZoneModified);
        this.activeEraPane = new BGridPane(2);
        this.activeEraPane.setHalign(BHalign.left);
        this.activeEraPane.setValign(BValign.top);
        this.activeEraPane.setColumnAlign(BHalign.left);
        this.activeEraPane.setColumnGap(10.0);
        this.activeEraPane.setRowGap(6.0);
        this.activeEraPane.setColorRows(false);
        BEdgePane edgedDatabasePane = new BEdgePane();
        edgedDatabasePane.setTop((BWidget)this.databasePane);
        BBorderPane borderedActiveEra = new BBorderPane((BWidget)this.activeEraPane, BBorder.solid);
        borderedActiveEra.setLabel((BWidget)LabelUtil.makeLabel((String)BTimeZoneViewer.text("database.activeEraLabel"), (boolean)true));
        edgedDatabasePane.setCenter((BWidget)new BBorderPane((BWidget)borderedActiveEra, BBorder.none, BInsets.make((double)5.0, (double)0.0, (double)0.0, (double)0.0)));
        this.borderedDatabasePane = new BBorderPane((BWidget)new BBorderPane((BWidget)edgedDatabasePane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.doDatabaseTimeZoneModified();
        this.dstPane = new BGridPane(2);
        this.dstPane.setHalign(BHalign.left);
        this.dstPane.setValign(BValign.top);
        this.dstPane.setColumnAlign(BHalign.left);
        this.dstPane.setColumnGap(10.0);
        this.dstPane.setRowGap(6.0);
        this.dstPane.setColorRows(false);
        this.dstTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.timezone"), (BWidget)this.dstTimeZoneDropDown, true);
        this.targetYear = new BIntegerFE();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.year"), (BWidget)this.targetYear, true);
        this.dstStartTime = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.startDate"), (BWidget)this.dstStartTime, true);
        this.dstEndTime = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.endDate"), (BWidget)this.dstEndTime, true);
        this.inDaylightNow = new BLabel();
        BTimeZoneViewer.addLabelWidgetPair(this.dstPane, BTimeZoneViewer.text("dst.inDaylightNow"), (BWidget)this.inDaylightNow, true);
        this.dstTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.dstTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.dstTimeZoneDropDown.getList().setMultipleSelection(false);
        this.targetYear.loadValue((BObject)BInteger.make((int)BAbsTime.now().getYear()), (Context)yearFacets);
        this.doDstCalculatorValuesModified();
        this.linkTo(null, (BComponent)this.dstTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)dstCalculatorValuesModified);
        this.linkTo(null, (BComponent)this.targetYear, (Slot)BIntegerFE.actionPerformed, (Slot)dstCalculatorValuesModified);
        this.borderedDstPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.dstPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.calculatorPane = new BGridPane(2);
        this.calculatorPane.setHalign(BHalign.left);
        this.calculatorPane.setValign(BValign.top);
        this.calculatorPane.setColumnAlign(BHalign.left);
        this.calculatorPane.setColumnGap(10.0);
        this.calculatorPane.setRowGap(6.0);
        this.calculatorPane.setColorRows(false);
        this.sourceTimeFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.sourceTime"), (BWidget)this.sourceTimeFE, true);
        this.sourceTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.sourceTimeZone"), (BWidget)this.sourceTimeZoneDropDown, true);
        this.targetTimeZoneDropDown = new BListDropDown();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.targetTimeZone"), (BWidget)this.targetTimeZoneDropDown, true);
        this.targetTimeFE = new BAbsTimeFE();
        BTimeZoneViewer.addLabelWidgetPair(this.calculatorPane, BTimeZoneViewer.text("calculator.targetTime"), (BWidget)this.targetTimeFE, true);
        this.sourceTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.sourceTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.sourceTimeZoneDropDown.getList().setMultipleSelection(false);
        BTimeZone source = (BTimeZone)this.sourceTimeZoneDropDown.getSelectedItem();
        source = source == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)source.getId());
        this.sourceTimeFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)source), (Context)BFacets.make((String)"showTimeZone", (boolean)false));
        this.targetTimeZoneDropDown.getList().setModel((ListModel)new ZoneListModel(zonesAsZones));
        this.targetTimeZoneDropDown.setSelectedItem((Object)BTimeZone.getLocal());
        this.targetTimeZoneDropDown.getList().setMultipleSelection(false);
        this.targetTimeFE.setReadonly(true);
        try {
            BTimeZone target = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            target = target == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)target.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)((BAbsTime)this.sourceTimeFE.saveValue()).getMillis(), (BTimeZone)target));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.linkTo(null, (BComponent)this.sourceTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)calculatorSourceTimeZoneModified);
        this.linkTo(null, (BComponent)this.sourceTimeFE, (Slot)BAbsTimeFE.pluginModified, (Slot)calculatorSourceTimeModified);
        this.linkTo(null, (BComponent)this.targetTimeZoneDropDown, (Slot)BListDropDown.valueModified, (Slot)calculatorTargetTimeZoneModified);
        this.borderedCalculatorPane = new BBorderPane((BWidget)new BBorderPane((BWidget)this.calculatorPane, BBorder.solid), BBorder.inset, BInsets.DEFAULT);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("meta.title"), BImage.make((BIcon)BIcon.std((String)"specification.png")), false), (BWidget)this.borderedMetaPane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("database.title"), BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"database.png"), (BIcon)BIcon.std((String)"badges/clock.png"))), false), (BWidget)this.borderedDatabasePane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("dst.title"), BImage.make((BIcon)BIcon.std((String)"calendar.png")), false), (BWidget)this.borderedDstPane);
        this.tabbedPane.addPane(BTimeZoneViewer.makeLabel(BTimeZoneViewer.text("calculator.title"), BImage.make((BIcon)BIcon.make((BIcon)BIcon.std((String)"planet.png"), (BIcon)BIcon.std((String)"badges/clock.png"))), false), (BWidget)this.borderedCalculatorPane);
        this.setContent((BWidget)this.tabbedPane);
    }

    public void doCalculatorSourceTimeZoneModified() {
        try {
            if (this.sourceTimeFE != null && this.sourceTimeZoneDropDown != null && this.sourceTimeZoneDropDown.getSelectedItem() != null) {
                BAbsTime current = (BAbsTime)this.sourceTimeFE.saveValue();
                BTimeZone source = (BTimeZone)this.sourceTimeZoneDropDown.getSelectedItem();
                source = source == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)source.getId());
                this.sourceTimeFE.loadValue((BObject)BAbsTime.make((long)current.getMillis(), (BTimeZone)source));
                this.relayout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doCalculatorSourceTimeModified() {
        try {
            BAbsTime current = (BAbsTime)this.sourceTimeFE.saveValue();
            BTimeZone target = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            target = target == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)target.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)current.getMillis(), (BTimeZone)target));
            this.relayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doCalculatorTargetTimeZoneModified() {
        try {
            BAbsTime current = (BAbsTime)this.sourceTimeFE.saveValue();
            BTimeZone target = (BTimeZone)this.targetTimeZoneDropDown.getSelectedItem();
            target = target == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)target.getId());
            this.targetTimeFE.loadValue((BObject)BAbsTime.make((long)current.getMillis(), (BTimeZone)target));
            this.relayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doDstCalculatorValuesModified() {
        int selectedYear = BAbsTime.now().getYear();
        try {
            selectedYear = ((BInteger)this.targetYear.saveValue()).getInt();
        }
        catch (Exception e) {
            this.dstStartTime.setText("N/A");
            this.dstEndTime.setText("N/A");
            this.inDaylightNow.setText("N/A");
            return;
        }
        BTimeZone selectedZone = (BTimeZone)this.dstTimeZoneDropDown.getSelectedItem();
        selectedZone = selectedZone == null ? BTimeZone.UTC : BTimeZone.getTimeZone((String)selectedZone.getId());
        if (selectedYear == BAbsTime.now().getYear()) {
            DstRule startRule = selectedZone.getDaylightStartRule();
            DstRule endRule = selectedZone.getDaylightEndRule();
            if (startRule != null && endRule != null) {
                String startDateString = null;
                String endDateString = null;
                String startTimeString = null;
                String endTimeString = null;
                Calendar startCalendar = BTimeZoneViewer.calculateDateTime(selectedYear, startRule);
                Calendar endCalendar = BTimeZoneViewer.calculateDateTime(selectedYear, endRule);
                startDateString = BWeekday.make((int)(startCalendar.get(7) - 1)) + " " + BMonth.make((int)startCalendar.get(2)) + " " + startCalendar.get(5);
                endDateString = BWeekday.make((int)(endCalendar.get(7) - 1)) + " " + BMonth.make((int)endCalendar.get(2)) + " " + endCalendar.get(5);
                startTimeString = startRule.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(startRule.getTimeMode());
                endTimeString = endRule.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(endRule.getTimeMode());
                this.dstStartTime.setText(startDateString + " at " + startTimeString);
                this.dstEndTime.setText(endDateString + " at " + endTimeString);
                this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)selectedZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
            } else {
                this.dstStartTime.setText("N/A");
                this.dstEndTime.setText("N/A");
                this.inDaylightNow.setText("N/A");
            }
        } else {
            ZoneRules zoneRules = null;
            try {
                zoneRules = ZoneRulesProvider.getRules(selectedZone.getId(), false);
            }
            catch (ZoneRulesException zre) {
                DstRule startRule = selectedZone.getDaylightStartRule();
                DstRule endRule = selectedZone.getDaylightEndRule();
                if (startRule != null && endRule != null) {
                    String startDateString = null;
                    String endDateString = null;
                    String startTimeString = null;
                    String endTimeString = null;
                    Calendar startCalendar = BTimeZoneViewer.calculateDateTime(selectedYear, startRule);
                    Calendar endCalendar = BTimeZoneViewer.calculateDateTime(selectedYear, endRule);
                    startDateString = BWeekday.make((int)(startCalendar.get(7) - 1)) + " " + BMonth.make((int)startCalendar.get(2)) + " " + startCalendar.get(5);
                    endDateString = BWeekday.make((int)(endCalendar.get(7) - 1)) + " " + BMonth.make((int)endCalendar.get(2)) + " " + endCalendar.get(5);
                    startTimeString = startRule.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(startRule.getTimeMode());
                    endTimeString = endRule.getTime().toString() + " " + BTimeZoneViewer.timeModeToString(endRule.getTimeMode());
                    this.dstStartTime.setText(startDateString + " at " + startTimeString);
                    this.dstEndTime.setText(endDateString + " at " + endTimeString);
                    this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)selectedZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
                } else {
                    this.dstStartTime.setText("N/A");
                    this.dstEndTime.setText("N/A");
                    this.inDaylightNow.setText("N/A");
                }
                return;
            }
            if (zoneRules.getTransitionRules().size() == 0 && zoneRules.getTransitions().size() == 0) {
                this.dstStartTime.setText("N/A");
                this.dstEndTime.setText("N/A");
                this.inDaylightNow.setText("N/A");
            } else {
                LocalDateTime targetYear = LocalDateTime.of(selectedYear, 7, 1, 0, 0);
                ZonedDateTime zonedTargetYear = targetYear.atZone(ZoneId.of(selectedZone.getId()));
                Instant targetInstant = zonedTargetYear.toInstant();
                ZoneOffsetTransition startTransition = null;
                ZoneOffsetTransition endTransition = null;
                ZoneOffsetTransition previousBuffer = zoneRules.previousTransition(targetInstant);
                ZoneOffsetTransition nextBuffer = zoneRules.nextTransition(targetInstant);
                if (previousBuffer != null && previousBuffer.getDateTimeBefore().getYear() == selectedYear && nextBuffer != null && nextBuffer.getDateTimeBefore().getYear() == selectedYear) {
                    if (previousBuffer.isGap() && nextBuffer.isOverlap()) {
                        startTransition = previousBuffer;
                        endTransition = nextBuffer;
                    } else if (previousBuffer.isOverlap() && nextBuffer.isGap()) {
                        startTransition = nextBuffer;
                        endTransition = previousBuffer;
                    }
                    this.dstStartTime.setText(BTimeZoneViewer.createLocalDateTimeString(startTransition));
                    this.dstEndTime.setText(BTimeZoneViewer.createLocalDateTimeString(endTransition));
                    this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)selectedZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
                } else {
                    LocalDateTime targetNextYear;
                    ZonedDateTime zonedNextTargetYear;
                    Instant targetNextInstant;
                    ZoneOffsetTransition nextYearsTransition;
                    this.dstStartTime.setText("N/A");
                    this.dstEndTime.setText("N/A");
                    this.inDaylightNow.setText("N/A");
                    if (previousBuffer != null && previousBuffer.getDateTimeBefore().getYear() == selectedYear && previousBuffer.isOverlap()) {
                        LocalDateTime targetPreviousYear = LocalDateTime.of(selectedYear - 1, 7, 1, 0, 0);
                        ZonedDateTime zonedPreviousTargetYear = targetPreviousYear.atZone(ZoneId.of(selectedZone.getId()));
                        Instant targetPreviousInstant = zonedPreviousTargetYear.toInstant();
                        ZoneOffsetTransition previousYearsTransition = zoneRules.nextTransition(targetPreviousInstant);
                        if (previousYearsTransition != null && previousYearsTransition.getDateTimeBefore().getYear() == selectedYear - 1 && previousYearsTransition.isGap()) {
                            endTransition = previousBuffer;
                            this.dstEndTime.setText(BTimeZoneViewer.createLocalDateTimeString(endTransition));
                            this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)selectedZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
                        }
                    } else if (nextBuffer != null && nextBuffer.getDateTimeBefore().getYear() == selectedYear && nextBuffer.isGap() && (nextYearsTransition = zoneRules.nextTransition(targetNextInstant = (zonedNextTargetYear = (targetNextYear = LocalDateTime.of(selectedYear + 1, 7, 1, 0, 0)).atZone(ZoneId.of(selectedZone.getId()))).toInstant())) != null && nextYearsTransition.getDateTimeBefore().getYear() == selectedYear + 1 && nextYearsTransition.isOverlap()) {
                        startTransition = nextBuffer;
                        this.dstStartTime.setText(BTimeZoneViewer.createLocalDateTimeString(startTransition));
                        this.inDaylightNow.setText(BAbsTime.make((BAbsTime)BAbsTime.now(), (BTimeZone)selectedZone).inDaylightTime() ? BTimeZoneViewer.text("dst.inDaylightNow.true") : BTimeZoneViewer.text("dst.inDaylightNow.false"));
                    }
                }
            }
        }
    }

    private static String createLocalDateTimeString(ZoneOffsetTransition transition) {
        if (transition == null) {
            return "N/A";
        }
        LocalDateTime occurs = transition.getDateTimeBefore();
        String dateString = BWeekday.make((int)(occurs.getDayOfWeek().getValue() % 7)) + " " + BMonth.make((int)(occurs.getMonthValue() - 1)) + " " + occurs.getDayOfMonth();
        String timeString = occurs.getHour() % 12 + ":" + TextUtil.padZeros((String)String.valueOf(occurs.getMinute()), (int)2);
        if (occurs.getSecond() != 0) {
            timeString = timeString + ":" + TextUtil.padZeros((String)String.valueOf(occurs.getSecond()), (int)2);
        }
        timeString = timeString + (occurs.getHour() >= 12 ? " PM" : " AM");
        timeString = timeString + " Wall Time";
        return dateString + " at " + timeString;
    }

    private static String createAnnualString(DstRule rule) {
        if (rule == null) {
            return "N/A";
        }
        StringBuilder dateBuffer = new StringBuilder();
        if (rule.getDayMode() == 0) {
            dateBuffer.append("Occurs on ");
            dateBuffer.append(rule.getMonth().toString());
            dateBuffer.append(" ");
            dateBuffer.append(rule.getDay());
        } else if (rule.getDayMode() == 1 || rule.getDayMode() == 2) {
            dateBuffer.append("Occurs on the first ");
            dateBuffer.append(rule.getWeekday().toString());
            dateBuffer.append(" ").append(rule.getDayMode() == 1 ? "on or after " : "on or before ");
            dateBuffer.append(rule.getMonth().toString());
            dateBuffer.append(" ");
            dateBuffer.append(rule.getDay());
        } else if (rule.getDayMode() == -1) {
            dateBuffer.append("Occurs on the ");
            switch (rule.getWeek()) {
                case 0: {
                    dateBuffer.append("first ");
                    break;
                }
                case 1: {
                    dateBuffer.append("second ");
                    break;
                }
                case 2: {
                    dateBuffer.append("third ");
                    break;
                }
                case 3: {
                    dateBuffer.append("fourth ");
                    break;
                }
                case 4: 
                case 5: {
                    dateBuffer.append("last ");
                }
            }
            dateBuffer.append(rule.getWeekday().toString());
            dateBuffer.append(" in ");
            dateBuffer.append(rule.getMonth());
        } else {
            dateBuffer.append("Undetermined");
        }
        StringBuilder timeBuffer = new StringBuilder();
        timeBuffer.append(rule.getTime().toString());
        timeBuffer.append(" ");
        switch (rule.getTimeMode()) {
            case 0: {
                timeBuffer.append("Wall Time");
                break;
            }
            case 2: {
                timeBuffer.append("Coordinated Universal Time");
                break;
            }
            case 1: {
                timeBuffer.append("Standard Time");
            }
        }
        return dateBuffer.toString() + " at " + timeBuffer.toString();
    }

    private static Calendar calculateDateTime(int year, DstRule rule) {
        GregorianCalendar newCal = new GregorianCalendar(BTimeZone.getJavaUTCInstance());
        newCal.clear();
        newCal.set(1, year);
        newCal.set(2, rule.getMonth().getOrdinal());
        if (rule.getDayMode() == -1) {
            if (rule.getWeek() == 5 || rule.getWeek() == 4) {
                newCal.set(5, BAbsTime.getDaysInMonth((int)year, (BMonth)rule.getMonth()));
                newCal.setLenient(false);
                while (newCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)newCal).add(5, -1);
                }
            } else {
                int d;
                if (rule.getWeek() == 0) {
                    d = 1;
                } else if (rule.getWeek() == 1) {
                    d = 8;
                } else if (rule.getWeek() == 2) {
                    d = 15;
                } else if (rule.getWeek() == 3) {
                    d = 22;
                } else {
                    throw new IllegalArgumentException("Invalid week: " + rule.getWeek());
                }
                newCal.set(5, d);
                newCal.setLenient(false);
                while (newCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                    ((Calendar)newCal).add(5, 1);
                }
            }
        } else if (rule.getDayMode() == 0) {
            newCal.set(5, rule.getDay());
        } else if (rule.getDayMode() == 1 || rule.getDayMode() == 2) {
            newCal.set(5, rule.getDay());
            newCal.setLenient(false);
            while (newCal.get(7) != rule.getWeekday().getOrdinal() + 1) {
                if (rule.getDayMode() == 1) {
                    ((Calendar)newCal).add(5, 1);
                    continue;
                }
                ((Calendar)newCal).add(5, -1);
            }
        } else {
            throw new IllegalStateException("Cannot compute dst rule time.");
        }
        newCal.set(11, rule.getTime().getHour());
        newCal.set(12, rule.getTime().getMinute());
        newCal.set(13, rule.getTime().getSecond());
        newCal.set(14, rule.getTime().getSecond());
        return newCal;
    }

    public void doDatabaseTimeZoneModified() {
        try {
            BTimeZone current = (BTimeZone)this.databaseTimeZoneDropDown.getSelectedItem();
            if (current == null) {
                current = BTimeZone.UTC;
            }
            this.currentTimeInTimeZoneFE.loadValue((BObject)BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)current));
            this.activeEraPane.removeAll();
            long thisUtc = current.getUtcOffset();
            long utcOffsetHours = thisUtc / 3600000L;
            long utcOffsetMinutes = Math.abs(thisUtc % 3600000L / 60000L);
            StringBuilder result = new StringBuilder();
            if (thisUtc >= 0L) {
                result.append("+");
            }
            result.append(String.valueOf(utcOffsetHours));
            if (utcOffsetMinutes != 0L) {
                result.append(":");
                if (utcOffsetMinutes < 10L) {
                    result.append("0");
                }
                result.append(String.valueOf(utcOffsetMinutes));
            }
            result.append(" Hours");
            this.utcOffsetLabel = new BLabel();
            BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.standardUTCOffset"), (BWidget)this.utcOffsetLabel, true);
            this.standardNameLabel = new BLabel();
            BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.standardName"), (BWidget)this.standardNameLabel, true);
            this.observesDaylightSavingLabel = new BLabel();
            BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.observesDaylight"), (BWidget)this.observesDaylightSavingLabel, true);
            this.utcOffsetLabel.setText(result.toString());
            this.standardNameLabel.setText(current.getDisplayName(false, null));
            if (current.getDaylightStartRule() != null) {
                this.observesDaylightSavingLabel.setText(BTimeZoneViewer.text("database.yes"));
                this.dstStartRuleLabel = new BLabel();
                BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.daylightStartDate"), (BWidget)this.dstStartRuleLabel, true);
                this.dstEndsRuleLabel = new BLabel();
                BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.daylightEndDate"), (BWidget)this.dstEndsRuleLabel, true);
                this.dstAdjustmentLabel = new BLabel();
                BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.daylightAdjusment"), (BWidget)this.dstAdjustmentLabel, true);
                this.daylightNameLabel = new BLabel();
                BTimeZoneViewer.addLabelWidgetPair(this.activeEraPane, BTimeZoneViewer.text("database.daylightName"), (BWidget)this.daylightNameLabel, true);
                DstRule startRule = current.getDaylightStartRule();
                DstRule endRule = current.getDaylightEndRule();
                this.dstStartRuleLabel.setText(BTimeZoneViewer.createAnnualString(startRule));
                this.dstEndsRuleLabel.setText(BTimeZoneViewer.createAnnualString(endRule));
                long thisAdj = current.getDaylightAdjustment();
                long adjHours = thisAdj / 3600000L;
                long adjMinutes = Math.abs(thisAdj % 3600000L / 60000L);
                StringBuilder adjResult = new StringBuilder();
                if (thisAdj >= 0L) {
                    adjResult.append("+");
                }
                adjResult.append(String.valueOf(adjHours));
                if (adjMinutes != 0L) {
                    adjResult.append(":");
                    if (adjMinutes < 10L) {
                        adjResult.append("0");
                    }
                    adjResult.append(String.valueOf(adjMinutes));
                }
                adjResult.append(" Hours");
                this.dstAdjustmentLabel.setText(adjResult.toString());
                this.daylightNameLabel.setText(current.getDisplayName(true, null));
            } else {
                this.observesDaylightSavingLabel.setText(BTimeZoneViewer.text("database.no"));
            }
            this.relayout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String timeModeToString(int timeMode) {
        if (timeMode == 2) {
            return "Universal Coordinated Time";
        }
        if (timeMode == 1) {
            return "Standard Time";
        }
        if (timeMode == 0) {
            return "Wall Time";
        }
        return "Unknown Time Mode";
    }

    private static void addLabelWidgetPair(BGridPane grid, String text, BWidget widget2, boolean bold) {
        String fieldName = text.trim();
        if (fieldName.length() > 10) {
            fieldName = fieldName.substring(0, 10);
        }
        fieldName = ObjectUtil.generateUniqueSlotName((String)SlotPath.escape((String)fieldName), (ObjectUtil.NameContainer)new NameContainer((BComplex)grid));
        grid.add(fieldName, (BValue)BTimeZoneViewer.makeLabel(text, bold));
        grid.add(null, (BValue)widget2);
    }

    public static BLabel makeLabel(String text, boolean bold) {
        return BTimeZoneViewer.makeLabel(text, null, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, BImage image, boolean bold) {
        return BTimeZoneViewer.makeLabel(text, image, bold, BHalign.left);
    }

    public static BLabel makeLabel(String text, BImage image, boolean bold, BHalign align) {
        BLabel result = new BLabel(text == null ? "" : text, align);
        if (image != null) {
            result.setImage(image);
        }
        if (bold) {
            result.setFont(BOLD_TEXT_FONT);
        }
        return result;
    }

    static String text(String key) {
        return lex.getText("timeZoneViewer." + key);
    }

    private static class NameContainer
    implements ObjectUtil.NameContainer {
        BComplex complex;

        public NameContainer(BComplex pComplex) {
            this.complex = pComplex;
        }

        public boolean contains(String name) {
            return this.complex.getSlot(name) != null;
        }
    }

    private static class ZoneListModel
    extends ListModel {
        BTimeZone[] items;

        public ZoneListModel(BTimeZone[] zones) {
            Array timeZoneArray = new Array(BTimeZone.class);
            timeZoneArray.addAll((Object[])zones);
            timeZoneArray = timeZoneArray.sort(BTimeZone.OFFSET_COMPARATOR);
            this.items = (BTimeZone[])timeZoneArray.trim();
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int row) {
            return this.items[row];
        }

        public Object getItem(int row) {
            return this.getTimeZone(row);
        }
    }
}

