/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.category;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTableTheme;
import com.tridium.util.HistoryCategoryUtil;
import com.tridium.workbench.category.BCategorySheet;
import com.tridium.workbench.category.Category;
import com.tridium.workbench.category.CategoryViewSupport;
import com.tridium.workbench.nav.NavMonitor;
import com.tridium.workbench.util.WbUtil;
import java.util.HashMap;
import java.util.Map;
import javax.baja.category.BCategoryMask;
import javax.baja.category.BCategoryService;
import javax.baja.category.BICategorizable;
import javax.baja.category.BOrdToCategoryMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BSpace;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BCheckList;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.util.BTitlePane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.util.Version;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"baja:CategoryService"}, requiredPermissions="R")})
public class BCategoryBrowser
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BCategoryBrowser.class);
    boolean[] visible;
    int visibleSize;
    int[] viewIdx;
    static final Lexicon lex = Lexicon.make(BCategoryBrowser.class);
    static Class<?> rootHistoryFolderClass = null;
    static Class<?> historyMirrorClass = null;
    private static final Version VER_49 = new Version("4.9");
    private static final Version VER_4_14 = new Version("4.14");
    BTreeTable table;
    Model model;
    Array<Node> roots = new Array(Node.class);
    private CategoryViewSupport viewSupport;
    private BCategoryService service;
    Category[] categories;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCategoryBrowser() {
        this.table = new BTreeTable();
        this.table.setStyleClasses("category-browser");
        this.table.setMultipleSelection(false);
        this.model = new Model();
        this.table.setModel((TableModel)this.model);
        this.table.setCellRenderer((TableCellRenderer)new Renderer());
        this.table.setController((TableController)new Controller());
        this.setContent((BWidget)new BTitlePane(lex.getText("category.browser.title"), (BWidget)this.table));
        this.viewSupport = new CategoryViewSupport((BWbEditor)this);
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this.model);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this.model);
    }

    public BMenu[] getViewMenus() {
        BMenu menu = UiLexicon.bajaui().buildMenu("CategoryBrowser");
        menu.add(null, (Command)new ShowConfigured());
        return new BMenu[]{menu};
    }

    public BToolBar getViewToolBar() {
        BToolBar toolBar = new BToolBar();
        toolBar.add(null, (Command)new ShowConfigured());
        return toolBar;
    }

    public void doLoadValue(BObject obj, Context cx) throws Exception {
        this.service = obj instanceof BCategoryService ? (BCategoryService)obj : (BCategoryService)WbUtil.findService((BWidget)this, (Type)BCategoryService.TYPE);
        BISession session = BOrd.toSession((BObject)this.service);
        BINavNode[] spaces = session.getNavChildren();
        int len = 0;
        for (int i = 0; i < spaces.length; ++i) {
            if (!(spaces[i] instanceof BSpace) || !(spaces[i] instanceof BINavNode) || !(spaces[i] instanceof BICategorizable)) continue;
            if (spaces[i] instanceof BComponentSpace) {
                BComponent root = ((BComponentSpace)spaces[i]).getRootComponent();
                Node node = new Node(this.model, (BINavNode)root);
                this.roots.add((Object)node);
                Category.Result res = Category.load(this.getWbShell(), node.mask.size() + 1);
                len = res.categories.length - 1;
                this.categories = new Category[len];
                System.arraycopy(res.categories, 1, this.categories, 0, len);
                this.viewSupport.updateNamedCategories(this.categories);
                continue;
            }
            this.addRoot(((BSpace)spaces[i]).getOrdInSession());
        }
        this.loadVisible(len);
        if (!this.model.needsInitialization()) {
            this.model.updateTreeTable(true);
        }
    }

    private void addRoot(BOrd ord) {
        try {
            BObject obj = ord.get(this.getCurrentValue());
            if (!(obj instanceof BINavNode)) {
                return;
            }
            this.addRoot((BINavNode)obj);
        }
        catch (Exception e) {
            System.out.println("Cannot add root: " + ord);
            e.printStackTrace();
        }
    }

    private void addRoot(BINavNode nav) {
        try {
            if (nav instanceof BICategorizable) {
                this.roots.add((Object)new Node(this.model, nav));
            }
        }
        catch (Exception e) {
            System.out.println("Cannot add root: " + nav.getNavOrd());
            System.out.println("  " + e);
        }
    }

    public BObject doSaveValue(BObject obj, Context cx) throws Exception {
        int i;
        BOrdToCategoryMap ordMap = this.service.getOrdMap();
        int len = ordMap.size();
        HashMap<BOrd, BCategoryMask> map = new HashMap<BOrd, BCategoryMask>();
        for (i = 0; i < len; ++i) {
            map.put(ordMap.getOrd(i), ordMap.getCategoryMask(i));
        }
        for (i = 0; i < this.roots.size(); ++i) {
            Node root = (Node)((Object)this.roots.get(i));
            if (root.nav instanceof BComponent && !root.virtual) {
                BComponentSpace space = ((BComponent)root.nav).getComponentSpace();
                Transaction tx = space.newTransaction();
                this.saveComponentNodes(root, (Context)tx, map);
                tx.commit();
                continue;
            }
            this.saveOrdMappedNodes(root, map);
        }
        Array ords = new Array(BOrd.class);
        Array masks = new Array(BCategoryMask.class);
        for (BOrd ord : map.keySet()) {
            BCategoryMask mask = (BCategoryMask)map.get(ord);
            if (mask == null || mask.isNull()) continue;
            ords.add((Object)ord);
            masks.add((Object)mask);
        }
        this.service.set(BCategoryService.ordMap, (BValue)BOrdToCategoryMap.make((BOrd[])((BOrd[])ords.trim()), (BCategoryMask[])((BCategoryMask[])masks.trim())), cx);
        BCategorySheet.update(this.service, cx);
        return this.service;
    }

    private void saveComponentNodes(Node node, Context cx, Map<BOrd, BCategoryMask> map) {
        if (node.dirty) {
            if (node.inherited()) {
                ((BComponent)node.nav).setCategoryMask(BCategoryMask.NULL, cx);
            } else {
                ((BComponent)node.nav).setCategoryMask(node.mask, cx);
            }
        }
        if (node.kids == null) {
            return;
        }
        for (int i = 0; i < node.kids.length; ++i) {
            if (node.kids[i].virtual) {
                this.saveOrdMappedNodes(node.kids[i], map);
                continue;
            }
            this.saveComponentNodes(node.kids[i], cx, map);
        }
    }

    private boolean remoteStationUsesHistoryShorthand() {
        if (this.service.getSession() instanceof BFoxSession) {
            Version version = ((BFoxSession)this.service.getSession()).getConnection().getRemoteVersion();
            return version.compareTo(VER_49) >= 0;
        }
        return false;
    }

    private boolean remoteStationConvertsOrdsOnServer() {
        if (this.service.getSession() instanceof BFoxSession) {
            Version version = ((BFoxSession)this.service.getSession()).getConnection().getRemoteVersion();
            return version.compareTo(VER_4_14) >= 0;
        }
        return false;
    }

    private void saveOrdMappedNodes(Node node, Map<BOrd, BCategoryMask> map) {
        if (node.dirty) {
            String lowerCaseOrdStr;
            BOrd ord = node.categorizableOrd;
            String ordStr = ord.relativizeToSession().toString();
            boolean caseSensitive = HistoryCategoryUtil.isCaseSensitiveInOrdToCategoryMap((String)ordStr);
            if (this.remoteStationUsesHistoryShorthand() && !caseSensitive) {
                boolean serverSideOrdConversion = this.remoteStationConvertsOrdsOnServer();
                ord = HistoryCategoryUtil.convertToShorthand((BOrd)ord, (String)((BFoxSession)this.service.getSession()).getStationName(), (!serverSideOrdConversion ? 1 : 0) != 0);
                if (serverSideOrdConversion) {
                    map.remove(BOrd.make((String)TextUtil.toLowerCase((String)ord.toString())));
                }
            }
            if (caseSensitive && !ordStr.equals(lowerCaseOrdStr = TextUtil.toLowerCase((String)ordStr))) {
                map.remove(BOrd.make((String)lowerCaseOrdStr));
            }
            if (node.inherited()) {
                map.remove(ord);
            } else {
                map.put(ord, node.mask);
            }
        }
        if (node.kids == null) {
            return;
        }
        for (int i = 0; i < node.kids.length; ++i) {
            this.saveOrdMappedNodes(node.kids[i], map);
        }
    }

    private void updateVisible() {
        this.visibleSize = 0;
        for (int i = 0; i < this.visible.length; ++i) {
            if (!this.visible[i]) continue;
            this.viewIdx[this.visibleSize++] = i;
        }
    }

    private void loadVisible(int len) {
        this.visible = new boolean[len];
        this.viewIdx = new int[len];
        this.visibleSize = len;
        for (int i = 0; i < len; ++i) {
            this.visible[i] = true;
            this.viewIdx[i] = i;
        }
    }

    class ConfigureColumns
    extends Command {
        ConfigureColumns(boolean show) {
            super((BWidget)BCategoryBrowser.this, lex.getText("category.show"));
        }

        public CommandArtifact doInvoke() {
            int i;
            BCheckList list = new BCheckList();
            for (i = 0; i < BCategoryBrowser.this.categories.length; ++i) {
                list.addItem((Object)BCategoryBrowser.this.categories[i].display);
            }
            list.getSelection().deselectAll();
            for (i = 0; i < BCategoryBrowser.this.categories.length; ++i) {
                if (!BCategoryBrowser.this.visible[i]) continue;
                list.getSelection().select(i);
            }
            BDialog.open((BWidget)BCategoryBrowser.this, (String)lex.getText("category.categories"), (Object)list, (int)1);
            for (i = 0; i < BCategoryBrowser.this.categories.length; ++i) {
                BCategoryBrowser.this.visible[i] = list.getSelection().isSelected(i);
            }
            BCategoryBrowser.this.updateVisible();
            BCategoryBrowser.this.table.relayout();
            return null;
        }
    }

    class ShowAllColumns
    extends Command {
        boolean show;

        ShowAllColumns(boolean show) {
            super((BWidget)BCategoryBrowser.this, show ? lex.getText("category.showAll") : lex.getText("category.hideAll"));
            this.show = show;
        }

        public CommandArtifact doInvoke() {
            for (int i = 0; i < BCategoryBrowser.this.visible.length; ++i) {
                BCategoryBrowser.this.visible[i] = this.show;
            }
            BCategoryBrowser.this.updateVisible();
            BCategoryBrowser.this.table.relayout();
            return null;
        }
    }

    class ClearConfiguredVisitor
    extends ConfiguredNodeVisitor {
        Node fromNode;

        ClearConfiguredVisitor(Node fromNode) {
            this.fromNode = fromNode;
        }

        @Override
        void visitNode(Node node) {
            if (node.isRoot) {
                return;
            }
            if (!this.isAncestor(this.fromNode, node)) {
                return;
            }
            if (node.inherited()) {
                return;
            }
            node.mask = null;
            node.dirty = true;
            BCategoryBrowser.this.setModified();
        }

        boolean isAncestor(Node a, Node b) {
            if (b == a) {
                return true;
            }
            if (b.isRoot) {
                return false;
            }
            return this.isAncestor(a, (Node)b.getParent());
        }
    }

    class ShowConfiguredVisitor
    extends ConfiguredNodeVisitor {
        ShowConfiguredVisitor() {
        }

        @Override
        void visitNode(Node node) {
            if (!node.isRoot) {
                this.expandNode((Node)node.getParent());
            }
        }

        void expandNode(Node node) {
            node.setExpanded(true);
            if (!node.isRoot) {
                this.expandNode((Node)node.getParent());
            }
        }
    }

    abstract class ConfiguredNodeVisitor {
        ConfiguredNodeVisitor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void visitAll() {
            BCategoryBrowser.this.enterBusy();
            try {
                BOrd query = BOrd.make((String)"station:|slot:/|bql:select navOrd from baja:Component where not categoryMask.isNull");
                BITable table = (BITable)query.resolve((BObject)BCategoryBrowser.this.service).get();
                Column col = table.getColumns().get(0);
                TableCursor c = table.cursor();
                Array arr = new Array(BOrd.class);
                while (c.next()) {
                    arr.add((Object)BOrd.make((String)c.cell(col).toString(null)).relativizeToSession());
                }
                BOrd[] ords = (BOrd[])arr.trim();
                new BatchResolve(ords).resolve((BObject)BCategoryBrowser.this.service);
                String stationName = ((BFoxSession)BCategoryBrowser.this.service.getSession()).getStationName();
                for (int i = 0; i < ords.length; ++i) {
                    String ord = ords[i].toString();
                    for (int j = 0; j < BCategoryBrowser.this.roots.size(); ++j) {
                        this.findNode(ord, (Node)((Object)BCategoryBrowser.this.roots.get(j)), false, false, stationName);
                    }
                }
                BOrdToCategoryMap ordMap = BCategoryBrowser.this.service.getOrdMap();
                int len = ordMap.size();
                for (int i = 0; i < len; ++i) {
                    String ord = ordMap.getOrd(i).relativizeToSession().toString();
                    boolean ignoreCase = ord.equals(TextUtil.toLowerCase((String)ord));
                    boolean convertHistory = ord.startsWith("history:^");
                    for (int j = 0; j < BCategoryBrowser.this.roots.size(); ++j) {
                        this.findNode(ord, (Node)((Object)BCategoryBrowser.this.roots.get(j)), ignoreCase, convertHistory, stationName);
                    }
                }
            }
            finally {
                BCategoryBrowser.this.exitBusy();
                BCategoryBrowser.this.repaint();
            }
        }

        void findNode(String ord, Node node, boolean ignoreCase, boolean convertHistory, String stationName) {
            String compareOrd = node.categorizableOrdRelStr;
            boolean ordIsLocalHistoryDevice = false;
            if (ignoreCase && convertHistory) {
                ordIsLocalHistoryDevice = compareOrd.equalsIgnoreCase("history:/" + stationName);
                compareOrd = HistoryCategoryUtil.convertToShorthand((BOrd)node.categorizableOrd, (String)stationName).toString();
            }
            if (ignoreCase && ord.equalsIgnoreCase(compareOrd) || ord.equals(compareOrd)) {
                this.visitNode(node);
            } else if (ignoreCase && ord.regionMatches(true, 0, compareOrd, 0, compareOrd.length()) || ord.startsWith(compareOrd) || ordIsLocalHistoryDevice && ord.startsWith("history:^") || "history:///".equals(compareOrd) && ord.startsWith("history:/") && !ord.startsWith("history://")) {
                for (int i = 0; i < node.getChildCount(); ++i) {
                    this.findNode(ord, (Node)node.getChild(i), ignoreCase, convertHistory, stationName);
                }
            }
        }

        abstract void visitNode(Node var1);
    }

    class ClearConfigured
    extends Command {
        Node fromNode;

        ClearConfigured(Node fromNode) {
            super((BWidget)BCategoryBrowser.this, lex, "category.clearConfigured");
            this.fromNode = fromNode;
        }

        public CommandArtifact doInvoke() throws Exception {
            new ClearConfiguredVisitor(this.fromNode).visitAll();
            return null;
        }
    }

    class ShowConfigured
    extends Command {
        ShowConfigured() {
            super((BWidget)BCategoryBrowser.this, lex, "category.showConfigured");
        }

        public CommandArtifact doInvoke() throws Exception {
            new ShowConfiguredVisitor().visitAll();
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        private boolean isColumnEditable(int col) {
            if (BCategoryBrowser.this.viewSupport.hasDebugClickEnabled()) {
                return true;
            }
            return BCategoryBrowser.this.viewSupport.hasAdminRead() && BCategoryBrowser.this.viewSupport.hasCategoryPermissions(BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[col - 2]]);
        }

        public void cellPressed(BMouseEvent event, int row, int col) {
            boolean editable;
            boolean bl = editable = col == 0 || col == 1 ? true : this.isColumnEditable(col);
            if (event.isButton1Down() && editable) {
                this.leftClick(event, row, col);
            } else if (event.isButton3Down() && editable) {
                this.rightClick(event, row, col);
            }
        }

        protected void cellEntered(BMouseEvent event, int row, int column) {
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(row);
            String text = ((BINavNode)node.getSubject()).getNavDisplayName(null).toString();
            text = text + "/" + BCategoryBrowser.this.model.getColumnName(column);
            BCategoryBrowser.this.getWbShell().showStatus(text);
        }

        private void leftClick(BMouseEvent event, int row, int col) {
            if (col == 0) {
                super.cellPressed(event, row, col);
            } else if (col == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(row);
                if (node.isRoot) {
                    return;
                }
                node.mask = node.inherited() ? node.applied() : null;
                node.dirty = true;
                BCategoryBrowser.this.setModified();
                BCategoryBrowser.this.repaint();
            } else {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(row);
                BCategoryMask m = node.mask;
                if (m == null) {
                    m = BCategoryMask.NULL;
                }
                Array a = new Array(Integer.class);
                for (int i = 0; i < BCategoryBrowser.this.categories.length; ++i) {
                    int n = BCategoryBrowser.this.categories[i].index;
                    if (BCategoryBrowser.this.viewIdx[col - 2] == i) {
                        if (m.get(n)) continue;
                        a.add((Object)n);
                        continue;
                    }
                    if (!m.get(n)) continue;
                    a.add((Object)n);
                }
                int[] ndx = new int[a.size()];
                for (int i = 0; i < a.size(); ++i) {
                    ndx[i] = (Integer)a.get(i);
                }
                BCategoryMask newMask = BCategoryMask.make((int[])ndx);
                if (!newMask.isNull()) {
                    node.mask = newMask;
                    node.dirty = true;
                    BCategoryBrowser.this.setModified();
                    BCategoryBrowser.this.repaint();
                }
            }
        }

        private void rightClick(BMouseEvent event, int row, int col) {
            BMenu menu = new BMenu();
            menu.add(null, (Command)new ClearConfigured((Node)BCategoryBrowser.this.model.rowToNode(row)));
            menu.open((BWidget)BCategoryBrowser.this, event.getX(), event.getY());
        }

        protected BMenu makeOptionsMenu() {
            BMenu menu = super.makeOptionsMenu();
            menu.add(null, (BValue)new BSeparator());
            menu.add(null, (Command)new ShowAllColumns(true));
            menu.add(null, (Command)new ShowAllColumns(false));
            menu.add(null, (Command)new ConfigureColumns(false));
            return menu;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        BBrush EXPANDER_BRUSH = BColor.black.toBrush();
        BBrush CONNECTING_BRUSH = BColor.make((int)192, (int)192, (int)192).toBrush();
        BImage DOT = BImage.make((String)"module://icons/x16/bullet.png");
        BImage INHERIT = BImage.make((String)"module://icons/x16/check.png");

        Renderer() {
        }

        public BBrush getBackground(TableCellRenderer.Cell cell) {
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
            if (!node.inherited()) {
                return Theme.table().getBandBrush((IStylable)this.getTable());
            }
            return super.getBackground(cell);
        }

        public BBrush getSelectionForeground(TableCellRenderer.Cell cell) {
            return this.getForeground(cell);
        }

        public BBrush getSelectionBackground(TableCellRenderer.Cell cell) {
            return this.getBackground(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            BTable table = this.getTable();
            TreeTableTheme theme = Theme.treeTable();
            this.paintCellBackground(g, cell);
            BBrush fg = g.getBrush();
            if (cell.column == 0) {
                String text;
                BImage icon;
                double y;
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                int depth = node.getDepth();
                double x = theme.getIndent(depth);
                if (BCategoryBrowser.this.model.isDepthExpandable(depth)) {
                    if (node.hasChildren()) {
                        int state = node.isExpanded() ? 2 : 1;
                        y = (cell.height - theme.getExpanderHeight()) / 2.0;
                        this.paintExpander(g, theme, x, y, state);
                    }
                    x += theme.getExpanderWidth() + 5.0;
                }
                if ((icon = BCategoryBrowser.this.model.getRowIcon(cell.row)) != null) {
                    y = (cell.height - 16.0) / 2.0;
                    if (node.inherited()) {
                        g.drawImage(icon.getDisabledImage(), x, y);
                    } else {
                        g.drawImage(icon, x, y);
                    }
                    x += 18.0;
                }
                if ((text = this.getCellText(cell)) != null && text.length() > 0) {
                    BFont font = theme.getCellFont((IStylable)table);
                    if (node.inherited()) {
                        g.setBrush(theme.getTextDisabled());
                    } else {
                        g.setBrush(fg);
                    }
                    g.setFont(font);
                    g.drawString(text, x, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
                }
            } else if (cell.column == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                if (node.inherited()) {
                    g.drawImage(this.INHERIT, 4.0, (cell.height - this.INHERIT.getHeight()) / 2.0);
                } else if (node.isRoot) {
                    BFont font = theme.getCellFont((IStylable)table);
                    g.setBrush(theme.getTextDisabled());
                    g.setFont(font);
                    g.drawString(lex.getText("category.notApplicable"), 4.0, (cell.height + font.getAscent() - font.getDescent()) / 2.0);
                }
            } else {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(cell.row);
                Category category = BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[cell.column - 2]];
                int n = category.index;
                if (!BCategoryBrowser.this.viewSupport.hasCategoryPermissions(category)) {
                    g.setBrush(Theme.table().getControlShadow());
                    g.fillRect(0.0, 0.0, cell.width, cell.height);
                }
                if (node.inherited()) {
                    if (node.applied().get(n)) {
                        g.drawImage(this.DOT.getDisabledImage(), 4.0, (cell.height - this.DOT.getDisabledImage().getHeight()) / 2.0);
                    }
                } else if (node.mask.get(n)) {
                    g.drawImage(this.DOT, 4.0, (cell.height - this.DOT.getHeight()) / 2.0);
                }
            }
            this.paintVerticalLine(g, cell);
        }

        private void paintExpander(Graphics g, TreeTableTheme theme, double x, double y, int state) {
            BBrush origBrush = g.getBrush();
            Theme.tree().paintExpander(g, null, x, y, state == 2);
            g.setBrush(origBrush);
        }
    }

    class Node
    extends TreeTableNode {
        BINavNode nav;
        BOrd categorizableOrd;
        String categorizableOrdRelStr;
        String navOrdRelStr;
        BObject object;
        boolean virtual;
        Node[] kids;
        BImage icon;
        BCategoryMask mask;
        boolean dirty;
        boolean isRoot;
        boolean performFullLoad;
        boolean buildChildren;

        Node(Model model, BINavNode nav) {
            super((TreeTableModel)model);
            this.dirty = false;
            this.performFullLoad = false;
            this.buildChildren = false;
            this.nav = nav;
            this.isRoot = true;
            this.init();
            if (this.mask == null) {
                this.mask = BCategoryMask.make((String)"1");
                this.dirty = true;
            }
        }

        Node(Node parent, BINavNode nav) {
            super((TreeTableNode)parent);
            this.dirty = false;
            this.performFullLoad = false;
            this.buildChildren = false;
            this.nav = nav;
            this.isRoot = false;
            this.init();
        }

        void init() {
            if (!(this.nav instanceof BICategorizable)) {
                throw new IllegalStateException(this.nav.getClass().getName() + " is not BICategorizable");
            }
            this.virtual = this.nav instanceof BVirtualComponent;
            BOrd navOrd = this.nav.getNavOrd();
            BOrd navOrdRel = navOrd.relativizeToSession();
            this.categorizableOrd = BCategoryService.getCategorizableOrd((BINavNode)this.nav, null).relativizeToSession();
            this.categorizableOrdRelStr = HistoryCategoryUtil.convertCaseForOrdToCategoryMap((String)this.categorizableOrd.toString());
            this.navOrdRelStr = HistoryCategoryUtil.convertCaseForOrdToCategoryMap((String)navOrdRel.toString());
            this.object = navOrd.get((BObject)BCategoryBrowser.this.service);
            this.icon = BImage.make((BIcon)this.nav.getNavIcon());
            this.mask = this.nav instanceof BComponent && !this.virtual ? ((BICategorizable)this.nav).getCategoryMask() : HistoryCategoryUtil.getOrdMapCategoryMask((BOrd)this.categorizableOrd, (BCategoryService)BCategoryBrowser.this.service);
        }

        public Object getSubject() {
            return this.nav;
        }

        public Object getValueAt(int col) {
            if (col == 0) {
                return this.nav.getNavDisplayName(null);
            }
            return "";
        }

        public BImage getIcon() {
            return this.icon;
        }

        public boolean hasChildren() {
            if (this.kids == null) {
                return this.nav.hasNavChildren();
            }
            return this.kids.length > 0;
        }

        public int getChildCount() {
            this.build();
            return this.kids.length;
        }

        public TreeTableNode getChild(int index) {
            this.build();
            return this.kids[index];
        }

        boolean inherited() {
            return this.mask == null || this.mask.isNull();
        }

        BCategoryMask applied() {
            if (this.inherited()) {
                Node parentNode = (Node)this.getParent();
                try {
                    if (rootHistoryFolderClass == null) {
                        rootHistoryFolderClass = Sys.loadClass((String)"history", (String)"com.tridium.history.BRootHistoryFolder");
                    }
                    if (rootHistoryFolderClass.isInstance(parentNode.nav)) {
                        parentNode = (Node)parentNode.getParent();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return parentNode.applied();
            }
            return this.mask;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void build() {
            block10: {
                if (this.buildChildren || this.kids == null) {
                    this.buildChildren = false;
                    BCategoryBrowser.this.enterBusy();
                    try {
                        if (this.object instanceof BStation && !this.isRoot) {
                            this.kids = new Node[0];
                            break block10;
                        }
                        BINavNode[] n = this.nav.getNavChildren();
                        Array a = new Array(Node.class);
                        for (int i = 0; i < n.length; ++i) {
                            if (!(n[i] instanceof BICategorizable)) continue;
                            try {
                                if (historyMirrorClass == null) {
                                    historyMirrorClass = Sys.loadClass((String)"history", (String)"com.tridium.history.BHistoryMirror");
                                }
                                if (historyMirrorClass.isInstance(n[i])) {
                                    continue;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            a.add((Object)new Node(this, n[i]));
                        }
                        this.kids = (Node[])a.trim();
                    }
                    finally {
                        BCategoryBrowser.this.exitBusy();
                    }
                }
            }
        }

        public void expanded() {
            if (this.performFullLoad) {
                this.performFullLoad = false;
                this.buildChildren = true;
            }
            NavMonitor.touch();
        }
    }

    class Model
    extends TreeTableModel
    implements NavListener {
        Model() {
        }

        public int getRootCount() {
            return BCategoryBrowser.this.roots.size();
        }

        public TreeTableNode getRoot(int index) {
            return (TreeTableNode)BCategoryBrowser.this.roots.get(index);
        }

        public int getColumnCount() {
            return BCategoryBrowser.this.visibleSize + 2;
        }

        public String getColumnName(int col) {
            if (col == 0) {
                return "";
            }
            if (col == 1) {
                return lex.getText("category.inherit.label");
            }
            return BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[col - 2]].display;
        }

        public BObject export(int row, int col) {
            if (col == 0) {
                return super.export(row, col);
            }
            if (col == 1) {
                Node node = (Node)BCategoryBrowser.this.model.rowToNode(row);
                if (node.inherited()) {
                    return BString.make((String)lex.getText("category.marker"));
                }
                if (node.isRoot) {
                    return BString.make((String)lex.getText("category.notApplicable"));
                }
                return BString.DEFAULT;
            }
            Node node = (Node)BCategoryBrowser.this.model.rowToNode(row);
            int n = BCategoryBrowser.this.categories[BCategoryBrowser.this.viewIdx[col - 2]].index;
            if (node.inherited()) {
                return node.applied().get(n) ? BString.make((String)lex.getText("category.marker")) : BString.DEFAULT;
            }
            return node.mask.get(n) ? BString.make((String)lex.getText("category.marker")) : BString.DEFAULT;
        }

        public void navEvent(NavEvent event) {
            Node parent;
            if (event.getId() == 2 && (parent = this.eventToNode(event)) != null && parent.nav instanceof BComponent) {
                BComponent comp = (BComponent)parent.nav;
                if (comp instanceof BVirtualGateway) {
                    try {
                        comp = ((BVirtualGateway)comp).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!((ComponentSlotMap)comp.fw(1)).isBrokerPropsLoaded()) {
                    parent.performFullLoad = true;
                }
            }
        }

        Node eventToNode(NavEvent event) {
            BOrd ord = event.getParentOrd();
            if (ord == null) {
                return null;
            }
            String ordStr = ord.relativizeToSession().toString();
            boolean caseSensitive = HistoryCategoryUtil.isCaseSensitiveInOrdToCategoryMap((String)ordStr);
            String lowercaseRelOrd = TextUtil.toLowerCase((String)ordStr);
            Node insensitiveMatch = null;
            Node node = null;
            for (int j = 0; j < BCategoryBrowser.this.roots.size(); ++j) {
                Node rootNode = (Node)((Object)BCategoryBrowser.this.roots.get(j));
                node = caseSensitive ? this.findNodeByNavOrd(ordStr, rootNode) : this.findNodeByNavOrd(lowercaseRelOrd, rootNode);
                if (node != null) break;
                if (!caseSensitive || insensitiveMatch != null) continue;
                insensitiveMatch = this.findNodeByNavOrd(lowercaseRelOrd, rootNode);
            }
            if (node != null) {
                return node;
            }
            return insensitiveMatch;
        }

        Node findNodeByNavOrd(String ord, Node node) {
            Node[] children;
            if (ord.equals(node.navOrdRelStr)) {
                return node;
            }
            if (ord.startsWith(node.navOrdRelStr) && (children = node.kids) != null) {
                for (Node child : children) {
                    Node result = this.findNodeByNavOrd(ord, child);
                    if (result == null) continue;
                    return result;
                }
            }
            return null;
        }
    }
}

