/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platPower;

import com.tridium.platPower.BBatteryState;
import java.security.AccessController;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BRelTime;

public class PowerdQnx {
    static boolean nativesLoaded = false;
    static int handle = -1;
    static Logger log = Logger.getLogger("power");

    public static boolean loadLibraries() {
        if (nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                log.fine("Loading power native library");
                System.loadLibrary("power");
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "Cannot load power native library", e);
            }
            return nativesLoaded;
        });
    }

    public static void open() {
        PowerdQnx.loadLibraries();
        if (handle != -1) {
            return;
        }
        handle = PowerdQnx.open0();
    }

    public static void close() {
        PowerdQnx.close0(handle);
        handle = -1;
    }

    public static boolean isPrimaryPresent() {
        return PowerdQnx.isPrimaryPresent0(handle);
    }

    public static boolean testBattery() {
        return PowerdQnx.testBattery0(handle);
    }

    public static boolean isBatteryGood() {
        return PowerdQnx.isBatteryGood0(handle);
    }

    public static long getBatteryTestTime() {
        return PowerdQnx.getBatteryTestTime0(handle);
    }

    public static int getBatteryCharge() {
        return PowerdQnx.getBatteryCharge0(handle);
    }

    public static boolean isBattery2Good() {
        return PowerdQnx.isBattery2Good0(handle);
    }

    public static long getBattery2TestTime() {
        return PowerdQnx.getBattery2TestTime0(handle);
    }

    public static BBatteryState getBatteryState() {
        switch (PowerdQnx.getBatteryState0(handle)) {
            case 4: {
                return BBatteryState.discharging;
            }
            case 5: {
                return BBatteryState.charging;
            }
            case 6: {
                return BBatteryState.idle;
            }
        }
        return BBatteryState.unknown;
    }

    public static BRelTime getBatteryChargeTime() {
        return BRelTime.makeSeconds((int)PowerdQnx.getBatteryChargeTime0(handle));
    }

    public static boolean isUpsPowerPresent() {
        return PowerdQnx.isUpsPowerPresent0(handle);
    }

    public static boolean isUpsBatteryGood() {
        return PowerdQnx.isUpsBatteryGood0(handle);
    }

    public static native int open0();

    public static native void close0(int var0);

    public static native boolean isPrimaryPresent0(int var0);

    public static native boolean testBattery0(int var0);

    public static native boolean isBatteryGood0(int var0);

    public static native long getBatteryTestTime0(int var0);

    public static native int getBatteryCharge0(int var0);

    public static native boolean isBattery2Good0(int var0);

    public static native long getBattery2TestTime0(int var0);

    public static native int getBatteryState0(int var0);

    public static native int getBatteryChargeTime0(int var0);

    public static native boolean isUpsPowerPresent0(int var0);

    public static native boolean isUpsBatteryGood0(int var0);
}

