/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.discover;

import com.tridium.ddf.discover.BDdfPointDiscoveryLeaf;
import com.tridium.ddf.identify.BDdfIdParams;
import com.tridium.util.EscUtil;
import com.tridiumx.smartKey.enums.BSmartKeyControlEnum;
import com.tridiumx.smartKey.identify.BSmartKeyInvertLineParams;
import com.tridiumx.smartKey.identify.BSmartKeyReadKeystrokeParams;
import com.tridiumx.smartKey.identify.BSmartKeyWriteControlParams;
import com.tridiumx.smartKey.identify.BSmartKeyWriteLineParams;
import com.tridiumx.smartKey.point.BSmartKeyBeeperPoint;
import com.tridiumx.smartKey.point.BSmartKeyTuningPolicyMap;
import javax.baja.control.BBooleanPoint;
import javax.baja.control.BBooleanWritable;
import javax.baja.control.BEnumPoint;
import javax.baja.control.BEnumWritable;
import javax.baja.control.BNumericPoint;
import javax.baja.control.BNumericWritable;
import javax.baja.control.BStringPoint;
import javax.baja.control.BStringWritable;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="description", type="String", defaultValue="", facets={@Facet(value="MGR_INCLUDE")})
public class BSmartKeyPointDiscoveryLeaf
extends BDdfPointDiscoveryLeaf {
    public static final Property description = BSmartKeyPointDiscoveryLeaf.newProperty((int)0, (String)"", (BFacets)MGR_INCLUDE);
    public static final Type TYPE = Sys.loadType(BSmartKeyPointDiscoveryLeaf.class);
    public static TypeInfo[] LINE_POINT_TYPES = new TypeInfo[]{BStringWritable.TYPE.getTypeInfo(), BNumericWritable.TYPE.getTypeInfo(), BEnumWritable.TYPE.getTypeInfo()};
    public static TypeInfo[] INVERT_POINT_TYPES = new TypeInfo[]{BBooleanWritable.TYPE.getTypeInfo()};
    public static TypeInfo[] KEY_MONITORING_POINT_TYPES = new TypeInfo[]{BStringPoint.TYPE.getTypeInfo(), BNumericPoint.TYPE.getTypeInfo(), BEnumPoint.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo()};
    public static TypeInfo[] KEY_MONITORING_POINT_TYPES_NUMBER_ENTRY_MODE = new TypeInfo[]{BNumericPoint.TYPE.getTypeInfo(), BStringPoint.TYPE.getTypeInfo(), BEnumPoint.TYPE.getTypeInfo(), BBooleanPoint.TYPE.getTypeInfo()};
    public static TypeInfo[] LIGHTING_CONTROL_POINT_TYPES = new TypeInfo[]{BBooleanWritable.TYPE.getTypeInfo(), BEnumWritable.TYPE.getTypeInfo(), BNumericWritable.TYPE.getTypeInfo(), BStringWritable.TYPE.getTypeInfo()};
    public static TypeInfo[] BUZZER_CONTROL_POINT_TYPES = new TypeInfo[]{BSmartKeyBeeperPoint.TYPE.getTypeInfo()};
    public static BEnumRange DEFAULT_KEY_MAPPING_NUMBER_MODE = BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13}, (String[])new String[]{EscUtil.slot.escape("0"), EscUtil.slot.escape("1"), EscUtil.slot.escape("2"), EscUtil.slot.escape("3"), EscUtil.slot.escape("4"), EscUtil.slot.escape("5"), EscUtil.slot.escape("6"), EscUtil.slot.escape("7"), EscUtil.slot.escape("8"), EscUtil.slot.escape("9"), EscUtil.slot.escape("*"), EscUtil.slot.escape("#"), EscUtil.slot.escape("."), EscUtil.slot.escape("-")});
    public static BEnumRange DEFAULT_KEY_MAPPING = BEnumRange.make((int[])new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, (String[])new String[]{EscUtil.slot.escape("0"), EscUtil.slot.escape("1"), EscUtil.slot.escape("2"), EscUtil.slot.escape("3"), EscUtil.slot.escape("4"), EscUtil.slot.escape("5"), EscUtil.slot.escape("6"), EscUtil.slot.escape("7"), EscUtil.slot.escape("8"), EscUtil.slot.escape("9"), EscUtil.slot.escape("*"), EscUtil.slot.escape("#"), EscUtil.slot.escape("<F1>"), EscUtil.slot.escape("<F2>"), EscUtil.slot.escape("<F3>"), EscUtil.slot.escape("<F4>")});

    public String getDescription() {
        return this.getString(description);
    }

    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSmartKeyPointDiscoveryLeaf() {
    }

    public BSmartKeyPointDiscoveryLeaf(String description, BDdfIdParams readParams, BDdfIdParams pointId, BDdfIdParams writeParams) {
        this.setDescription(description);
        this.setReadParameters((BDdfIdParams)readParams.newCopy());
        this.setPointId((BDdfIdParams)pointId.newCopy());
        this.setWriteParameters((BDdfIdParams)writeParams.newCopy());
    }

    public String getDiscoveryTuningPolicyName() {
        BDdfIdParams writeParams = this.getWriteParameters();
        if (writeParams instanceof BSmartKeyWriteLineParams || writeParams instanceof BSmartKeyInvertLineParams) {
            return BSmartKeyTuningPolicyMap.keypadLines.getName();
        }
        if (writeParams instanceof BSmartKeyWriteControlParams) {
            BSmartKeyWriteControlParams writeControlParams = (BSmartKeyWriteControlParams)writeParams;
            if (writeControlParams.getControl() == BSmartKeyControlEnum.buzzer) {
                return BSmartKeyTuningPolicyMap.beeperPoints.getName();
            }
            return BSmartKeyTuningPolicyMap.backlight.getName();
        }
        return BSmartKeyTuningPolicyMap.defaultPolicy.getName();
    }

    public String getDiscoveryName() {
        return this.getDescription();
    }

    public TypeInfo[] getValidDatabaseTypes() {
        BDdfIdParams writeParams = this.getWriteParameters();
        BDdfIdParams readParams = this.getReadParameters();
        if (writeParams instanceof BSmartKeyInvertLineParams) {
            return INVERT_POINT_TYPES;
        }
        if (writeParams instanceof BSmartKeyWriteLineParams) {
            return LINE_POINT_TYPES;
        }
        if (readParams instanceof BSmartKeyReadKeystrokeParams) {
            if (this.getDescription().equals("Number Entered")) {
                return KEY_MONITORING_POINT_TYPES_NUMBER_ENTRY_MODE;
            }
            return KEY_MONITORING_POINT_TYPES;
        }
        if (writeParams instanceof BSmartKeyWriteControlParams) {
            BSmartKeyWriteControlParams writeControlParams = (BSmartKeyWriteControlParams)writeParams;
            if (writeControlParams.getControl() == BSmartKeyControlEnum.lcdBacklight) {
                return LIGHTING_CONTROL_POINT_TYPES;
            }
            if (writeControlParams.getControl() == BSmartKeyControlEnum.keypadBacklight) {
                return LIGHTING_CONTROL_POINT_TYPES;
            }
            if (writeControlParams.getControl() == BSmartKeyControlEnum.buzzer) {
                return BUZZER_CONTROL_POINT_TYPES;
            }
            throw new IllegalStateException("Unrecognized SmartKey control selection: " + (Object)((Object)writeControlParams) + ". Unable to build point manager.");
        }
        throw new IllegalStateException("Unrecognized SmartKey discovery point: " + (Object)((Object)this) + ". Unable to build point manager.");
    }

    public BFacets getDiscoveryPointFacets() {
        BDdfIdParams writeParams = this.getWriteParameters();
        BDdfIdParams readParams = this.getReadParameters();
        if (writeParams instanceof BSmartKeyWriteLineParams || writeParams instanceof BSmartKeyInvertLineParams) {
            return BFacets.NULL;
        }
        if (readParams instanceof BSmartKeyReadKeystrokeParams) {
            if (this.getDescription().equals("Number Entered")) {
                return BFacets.make((String)"range", (BIDataValue)DEFAULT_KEY_MAPPING_NUMBER_MODE);
            }
            return BFacets.make((String)"range", (BIDataValue)DEFAULT_KEY_MAPPING);
        }
        if (writeParams instanceof BSmartKeyWriteControlParams) {
            return BFacets.NULL;
        }
        throw new IllegalStateException("Unrecognized SmartKey discovery point: " + (Object)((Object)this) + ". Unable to build point manager.");
    }
}

