/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.smartKey.comm;

import com.tridium.ddf.comm.IDdfDataFrame;
import com.tridium.ddfSerial.comm.BDdfSerialReceiver;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BSmartKeyReceiver
extends BDdfSerialReceiver {
    public static final Type TYPE = Sys.loadType(BSmartKeyReceiver.class);
    public static final int SKEY_SOH = 1;
    public static final int SKEY_EOT = 4;
    public static final int SKEY_NUM_OVERHEAD_BYTES = 7;
    public static final int SKEY_LENGTH_LOC = 4;
    public static final int SKEY_ID_LOC = 2;
    public static final int SKEY_FC_LOC = 3;

    public Type getType() {
        return TYPE;
    }

    public int isStartOfFrame(IDdfDataFrame frameSoFar) {
        if (frameSoFar.getFrameSize() > 0 && frameSoFar.getFrameBytes()[0] == 1) {
            return 0;
        }
        return 1;
    }

    public boolean isCompleteFrame(IDdfDataFrame frameSoFar) {
        int frameSize = frameSoFar.getFrameSize();
        byte[] frameBytes = frameSoFar.getFrameBytes();
        if (frameSize >= 7) {
            byte smartKeyDataLength = frameBytes[4];
            return frameSize >= smartKeyDataLength + 7;
        }
        return false;
    }

    public boolean checkFrame(IDdfDataFrame frameSoFar) {
        int frameSize = frameSoFar.getFrameSize();
        byte[] frameBytes = frameSoFar.getFrameBytes();
        if (frameBytes[frameSize - 1] == 4) {
            int secondToLastIndex = frameSoFar.getFrameSize() - 2;
            int transmittedChecksum = frameBytes[secondToLastIndex] & 0xFF;
            int computedChecksum = BSmartKeyReceiver.computeChecksum(frameBytes, frameSoFar.getFrameSize());
            return computedChecksum == transmittedChecksum;
        }
        return false;
    }

    public static int computeChecksum(byte[] frameBytes, int smartKeyFrameSize) {
        int secondToLastIndex = smartKeyFrameSize - 2;
        int computedChecksum = 0;
        for (int i = 0; i < secondToLastIndex; ++i) {
            computedChecksum += frameBytes[i];
        }
        return computedChecksum & 0xFF;
    }
}

