/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard.jobs;

import com.tridium.fcEasyOnboard.ActivityLogger;
import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.CloudAlarmsHelper;
import com.tridium.fcEasyOnboard.CloudAlertsHelper;
import com.tridium.fcEasyOnboard.CloudConnectorHelper;
import com.tridium.fcEasyOnboard.CloudEventsHelper;
import com.tridium.fcEasyOnboard.ICloudConfiguration;
import com.tridium.fcEasyOnboard.utils.OnboardUtils;
import com.tridium.sys.station.Station;
import java.util.Map;
import javax.baja.job.BSimpleJob;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BOnboardJob
extends BSimpleJob {
    public static final Type TYPE = Sys.loadType(BOnboardJob.class);
    private ICloudConfiguration config;

    public Type getType() {
        return TYPE;
    }

    public BOnboardJob() {
    }

    public BOnboardJob(ICloudConfiguration bEasyOnboard) {
        this.config = bEasyOnboard;
    }

    public void run(Context context) throws Exception {
        ActivityLogger logger = new ActivityLogger(this.log());
        this.log().start("Starting On board activities..");
        CloudConnectorHelper cloudConnectorHelper = new CloudConnectorHelper(this.config);
        ActivityStatus status = cloudConnectorHelper.addConnector();
        logger.logActivity("Add Cloud Connector", status);
        status = cloudConnectorHelper.addCloudNetwork();
        logger.logActivity("Add Cloud Network", status);
        status = cloudConnectorHelper.addCloudDevice();
        logger.logActivity("Add Cloud Device", status);
        status = cloudConnectorHelper.addCloudAuthenticationScheme();
        logger.logActivity("Add Cloud Authentication Scheme", status);
        status = cloudConnectorHelper.addCloudUser();
        logger.logActivity("Add Cloud User", status);
        CloudAlarmsHelper cloudAlarmsHelper = new CloudAlarmsHelper();
        status = cloudAlarmsHelper.addCloudAlarmRecipient(OnboardUtils.getCloudSentienceDevice());
        logger.logActivity("Add Cloud Alarm Recipient", status);
        CloudEventsHelper cloudEventsHelper = new CloudEventsHelper();
        status = cloudEventsHelper.addCloudEventRecipient(OnboardUtils.getCloudSentienceDevice());
        logger.logActivity("Add Cloud Event Recipient", status);
        CloudAlertsHelper cloudAlertsHelper = new CloudAlertsHelper();
        status = cloudAlertsHelper.addForgeTagDictionary();
        logger.logActivity("Add FC Tag Dictionary", status);
        status = cloudAlertsHelper.addModelSyncService();
        logger.logActivity("Add Model Sync Service", status);
        Map<String, String> appIds = this.config.getKnownAppIds();
        for (Map.Entry<String, String> appid : appIds.entrySet()) {
            status = cloudConnectorHelper.addUserMappings(appid);
            logger.logActivity("Add User Mapping", status);
        }
        this.log().message("Completed onboard activities");
        Station.saveSync();
    }
}

