/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard;

import com.tridium.fcEasyOnboard.ActivityStatus;
import com.tridium.fcEasyOnboard.utils.OnboardUtils;
import com.tridium.nc.devices.sentience.BCloudSentienceDevice;
import com.tridium.nc.events.BCloudEventRecipient;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.event.BEventRecipient;
import javax.baja.event.BEventService;
import javax.baja.event.BEventSource;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.LinkCheck;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class CloudEventsHelper {
    private static final Logger logger = Logger.getLogger("fcEasyOnboard");

    public ActivityStatus addCloudEventRecipient(BCloudSentienceDevice device) {
        if (device == null) {
            throw new RuntimeException("A Cloud Device needs to exist");
        }
        logger.fine("Checking for the existence of Cloud Event Recipient");
        BCloudEventRecipient recipient = OnboardUtils.getCloudEventRecipient();
        if (recipient != null) {
            logger.fine("Cloud Event Recipient already exists");
            return ActivityStatus.makeSkip("Cloud Event Recipient already exists - " + OnboardUtils.toOrd((BComponent)recipient));
        }
        logger.fine("Cloud Event Recipient is absent.  Attempting to create it.");
        BEventService eventService = null;
        try {
            eventService = (BEventService)Sys.getService((Type)BEventService.TYPE);
        }
        catch (ServiceNotFoundException snfe) {
            logger.fine("Event Service not present in the station. Skipping event recipient creation");
            return ActivityStatus.makeSkip("No Event Service in station");
        }
        BCloudEventRecipient cloudEventRecipient = new BCloudEventRecipient();
        eventService.add("cloudEventRecipient", (BValue)cloudEventRecipient);
        logger.fine("Cloud Event Recipient added to the Event Service");
        String strOrd = "station:|" + device.getSlotPath().toString();
        logger.fine("Found Cloud Device for the Cloud Event Recipient (" + strOrd + ')');
        cloudEventRecipient.setDevice(BOrd.make((String)strOrd));
        BEventSource[] eventSources = eventService.getEventSources();
        logger.fine("Attempting to add links with the Cloud Event Recipient.");
        Arrays.stream(eventSources).forEach(eventSource -> {
            LinkCheck linkCheck = cloudEventRecipient.checkLink((BComponent)eventSource, (Slot)BEventSource.event, (Slot)BEventRecipient.process, null);
            if (linkCheck.isValid()) {
                BLink link = cloudEventRecipient.makeLink((BComponent)eventSource, (Slot)BEventSource.event, (Slot)BEventRecipient.process, null);
                cloudEventRecipient.add("link?", (BValue)link);
                link.activate();
                logger.fine("New Link Created between " + eventSource.getName() + " and Cloud Event Recipient.");
            }
        });
        logger.fine("Number of Links Created:" + cloudEventRecipient.getLinks().length);
        return ActivityStatus.makeSuccess("Adds cloud event recipient - " + OnboardUtils.toOrd((BComponent)cloudEventRecipient));
    }

    public ActivityStatus removeCloudEventRecipient() {
        LinkedList<BCloudEventRecipient> list = OnboardUtils.getCloudEventRecipients();
        String ordList = list.stream().map(OnboardUtils::toOrd).collect(Collectors.joining("\n"));
        for (BCloudEventRecipient comp : list) {
            BComponent parent = (BComponent)comp.getParent();
            parent.remove(comp.getName());
        }
        return ActivityStatus.makeSuccess("Removed Cloud Event Recipients - " + ordList);
    }
}

