/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcEasyOnboard;

import com.tridium.fcEasyOnboard.ICloudConfiguration;
import com.tridium.fcEasyOnboard.env.BEnvironment;
import com.tridium.fcEasyOnboard.env.EnvironmentSettings;
import com.tridium.fcEasyOnboard.jobs.BCleanCloudConfigJob;
import com.tridium.fcEasyOnboard.jobs.BOnboardJob;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="deviceRegistrationURL", type="String", defaultValue="Constants.CB_PROD_DEVICE_REGISTRATION_URL", flags=1), @NiagaraProperty(name="systemType", type="String", defaultValue="Constants.SYSTEM_TYPE", flags=1), @NiagaraProperty(name="deviceAuthenticationURL", type="String", defaultValue="Constants.CB_PROD_AUTHENTICATION_URL", flags=1), @NiagaraProperty(name="migratingAKnownDevice", type="boolean", defaultValue="false"), @NiagaraProperty(name="registrationURL", type="String", defaultValue="Constants.CB_PROD_REGISTRATION_URL", flags=1), @NiagaraProperty(name="environment", type="BEnvironment", defaultValue="BEnvironment.cbProduction", flags=1)})
@NiagaraActions(value={@NiagaraAction(name="easyOnBoard", returnType="BOrd"), @NiagaraAction(name="clean", returnType="BOrd", flags=4)})
public class BEasyOnboard
extends BAbstractService
implements ICloudConfiguration {
    public static final Property deviceRegistrationURL = BEasyOnboard.newProperty((int)1, (String)"https://papi.honeywellcloud.com/ccprodapp/#/", null);
    public static final Property systemType = BEasyOnboard.newProperty((int)1, (String)"honeywell-niagara-device", null);
    public static final Property deviceAuthenticationURL = BEasyOnboard.newProperty((int)1, (String)"https://gaprodsystemauthentication.sentience.honeywell.com", null);
    public static final Property migratingAKnownDevice = BEasyOnboard.newProperty((int)0, (boolean)false, null);
    public static final Property registrationURL = BEasyOnboard.newProperty((int)1, (String)"https://gaprodregui.sentience.honeywell.com", null);
    public static final Property environment = BEasyOnboard.newProperty((int)1, (BValue)BEnvironment.cbProduction, null);
    public static final Action easyOnBoard = BEasyOnboard.newAction((int)0, null);
    public static final Action clean = BEasyOnboard.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BEasyOnboard.class);
    private static final List<BEnvironment> productionEnvironments = new ArrayList<BEnvironment>();

    @Override
    public String getDeviceRegistrationURL() {
        return this.getString(deviceRegistrationURL);
    }

    public void setDeviceRegistrationURL(String v) {
        this.setString(deviceRegistrationURL, v, null);
    }

    @Override
    public String getSystemType() {
        return this.getString(systemType);
    }

    public void setSystemType(String v) {
        this.setString(systemType, v, null);
    }

    @Override
    public String getDeviceAuthenticationURL() {
        return this.getString(deviceAuthenticationURL);
    }

    public void setDeviceAuthenticationURL(String v) {
        this.setString(deviceAuthenticationURL, v, null);
    }

    public boolean getMigratingAKnownDevice() {
        return this.getBoolean(migratingAKnownDevice);
    }

    public void setMigratingAKnownDevice(boolean v) {
        this.setBoolean(migratingAKnownDevice, v, null);
    }

    @Override
    public String getRegistrationURL() {
        return this.getString(registrationURL);
    }

    public void setRegistrationURL(String v) {
        this.setString(registrationURL, v, null);
    }

    public BEnvironment getEnvironment() {
        return (BEnvironment)this.get(environment);
    }

    public void setEnvironment(BEnvironment v) {
        this.set(environment, (BValue)v, null);
    }

    public BOrd easyOnBoard() {
        return (BOrd)this.invoke(easyOnBoard, null, null);
    }

    public BOrd clean() {
        return (BOrd)this.invoke(clean, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public BOrd doEasyOnBoard() {
        BOnboardJob onboardJob = new BOnboardJob(this);
        return onboardJob.submit(null);
    }

    public BOrd doClean() {
        BCleanCloudConfigJob cleanupJob = new BCleanCloudConfigJob(this);
        return cleanupJob.submit(null);
    }

    @Override
    public boolean isTestMode() {
        return !productionEnvironments.contains((Object)this.getEnvironment());
    }

    @Override
    public boolean isMigratingAKnownDevice() {
        return this.getMigratingAKnownDevice();
    }

    @Override
    public Map<String, String> getKnownAppIds() {
        HashMap<String, String> map = new HashMap<String, String>();
        Arrays.stream(this.getDynamicPropertiesArray()).filter(x -> x.getName().startsWith("appid_")).forEach(x -> {
            String s = this.get((Property)x).toString();
            map.put(x.getName(), s);
        });
        return map;
    }

    @Override
    public String getEnvironmentName() {
        return this.getEnvironment().toString();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (this.isRunning() && property.equals(environment)) {
            this.updateEnvironment();
        }
    }

    public void started() throws Exception {
        super.started();
        if (this.getKnownAppIds().isEmpty()) {
            this.updateEnvironment();
        }
    }

    private void updateEnvironment() {
        EnvironmentSettings env = this.getEnvironment().getSettings();
        this.setDeviceAuthenticationURL(env.getDeviceAuthenticationUrl());
        this.setDeviceRegistrationURL(env.getDeviceRegistrationUrl());
        this.setRegistrationURL(env.getRegistrationUrl());
        this.setSystemType(env.getSystemType());
        this.removeExistingAppIds();
        this.add("appid_model", (BValue)BString.make((String)env.getModelsyncAppId()), 1);
        this.add("appid_alarm", (BValue)BString.make((String)env.getAlarmAckAppId()), 1);
    }

    private void removeExistingAppIds() {
        List appIdList = Arrays.stream(this.getDynamicPropertiesArray()).filter(x -> x.getName().startsWith("appid_")).map(y -> y.getName()).collect(Collectors.toList());
        for (String appId : appIdList) {
            this.remove(appId);
        }
    }

    static {
        productionEnvironments.add(BEnvironment.cbProduction);
        productionEnvironments.add(BEnvironment.hbtProduction);
        productionEnvironments.add(BEnvironment.uaeProduction);
    }
}

