/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.ui;

import com.tridium.aaphp.BAaPhpDevice;
import com.tridium.aaphp.BAaPhpDeviceFolder;
import com.tridium.aaphp.BAaPhpNetwork;
import com.tridium.aaphp.BAaPhpStarDevice;
import com.tridium.aaphp.datatypes.BAaPhpLearnDeviceEntry;
import com.tridium.aaphp.datatypes.BAaPhpLearnDevicesParameter;
import com.tridium.aaphp.job.BAaPhpGatherSetupInfoJob;
import com.tridium.aaphp.job.BAaPhpLearnDevicesJob;
import com.tridium.aaphp.ui.AaPhpDeviceState;
import com.tridium.aaphp.ui.AaPhpExamineSetupCommand;
import com.tridium.aaphp.ui.AaPhpRecvFileCommand;
import com.tridium.aaphp.ui.AaPhpSendFileCommand;
import com.tridium.aaphp.ui.AaPhpTextFileCompare;
import com.tridium.aaphp.ui.BAaPhpVisualDiffDialog;
import com.tridium.aaphp.ui.BAaPhpVisualDiffPane;
import com.tridium.util.ArrayUtil;
import com.tridium.util.TimeFormat;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceController;
import javax.baja.driver.ui.device.DeviceExtsColumn;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobState;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"aaphp:AaPhpNetwork", "aaphp:AaPhpDeviceFolder", "aaphp:AaPhpStarNetwork", "aaphp:AaPhpStarDeviceFolder"})})
public class BAaPhpDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpDeviceManager.class);
    DiscoveryListSubscriber discoveryListSubscriber;
    static Lexicon lex = Lexicon.make(BAaPhpDeviceManager.class);
    MgrColumn colName = new MgrColumn.Name();
    MgrColumn colType = new MgrColumn.Type();
    MgrColumn colDeviceExts = new DeviceExtsColumn((BDevice)new BAaPhpStarDevice());
    MgrColumn colStatus = new MgrColumn.Prop(BDevice.status);
    MgrColumn colEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    MgrColumn colHealth = new MgrColumn.Prop(BDevice.health, 0);
    MgrColumn colAddress = new MgrColumn.Prop(BAaPhpDevice.address, 1);
    MgrColumn[] cols = new MgrColumn[]{this.colName, this.colType, this.colDeviceExts, this.colAddress, this.colStatus, this.colEnabled, this.colHealth};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BAaPhpDeviceManager() {
        this.discoveryListSubscriber = new DiscoveryListSubscriber();
    }

    protected MgrModel makeModel() {
        return new AaPhpDeviceModel(this);
    }

    protected MgrLearn makeLearn() {
        return new AaPhpDeviceLearn();
    }

    protected MgrController makeController() {
        return new AaPhpDeviceController(this);
    }

    protected MgrState makeState() {
        return new AaPhpDeviceState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void gatherSetupInfoJobComplete(BAaPhpGatherSetupInfoJob job) {
        if (job.getJobState() == BJobState.success && !job.getCompareComplete()) {
            try {
                if (BDialog.confirm((BWidget)this, (String)this.getLexicon().getText("examineSetup.compare.prompt1.title"), (Object)this.getLexicon().getText("examineSetup.compare.prompt1.question")) == 4) {
                    StringBuilder defSaveCompareFileName = new StringBuilder();
                    defSaveCompareFileName.append(TextUtil.capitalize((String)TYPE.getModule().getModuleName()));
                    defSaveCompareFileName.append(TextUtil.capitalize((String)this.getAaPhpNetwork().getHost().getNavName()));
                    defSaveCompareFileName.append(TextUtil.capitalize((String)job.getDeviceName()));
                    defSaveCompareFileName.append("SetupComp");
                    defSaveCompareFileName.append(TimeFormat.format((BAbsTime)BAbsTime.now(), (String)"YYYYMMDDHHmmss")).append(".txt");
                    BOrd file1 = job.getResultsFileOrd();
                    BOrd file2 = AaPhpTextFileCompare.promptForFile((BWidget)this, this.getLexicon().getText("examineSetup.compare.prompt2.title"), job.getEarlierResultsFileOrd(), null);
                    if (file2 != null) {
                        BAaPhpVisualDiffPane visualDiffPane = new BAaPhpVisualDiffPane();
                        visualDiffPane.computeDiff((BIFile)file2.get(), (BIFile)file1.get());
                        BAaPhpVisualDiffDialog compareWindow = new BAaPhpVisualDiffDialog((BWidget)this, this.getLexicon().getText("examineSetup.comparing"), visualDiffPane, defSaveCompareFileName.toString());
                        compareWindow.open();
                    }
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (String)"Bug in Program", (Object)"Please have my program fixed.", (Throwable)e);
            }
            finally {
                job.setCompareComplete(true);
            }
        }
    }

    public BAaPhpNetwork getAaPhpNetwork() {
        BObject owner = this.getCurrentValue();
        if (owner instanceof BAaPhpDeviceFolder) {
            return (BAaPhpNetwork)((BAaPhpDeviceFolder)owner).getNetwork();
        }
        if (owner instanceof BAaPhpNetwork) {
            return (BAaPhpNetwork)owner;
        }
        return null;
    }

    public void doLoadValue(BObject obj, Context cx) {
        super.doLoadValue(obj, cx);
        this.updateLearnData();
    }

    void updateLearnData() {
        BJob mgrJob = this.getLearn().getJob();
        if (mgrJob != null && mgrJob instanceof BAaPhpLearnDevicesJob) {
            BAaPhpLearnDevicesJob learnJob = (BAaPhpLearnDevicesJob)mgrJob;
            this.getLearn().updateRoots(learnJob.getLearnedDevices().getChildren(BAaPhpLearnDeviceEntry.class));
        }
    }

    public BAaPhpDevice[] getSelectedDevices() {
        if (this.getModel() == null || this.getModel().getTable() == null) {
            return new BAaPhpDevice[0];
        }
        BComponent[] selection = this.getModel().getTable().getSelectedComponents();
        Object[] devices = new BAaPhpDevice[]{};
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i].getType().is(BAaPhpDevice.TYPE)) continue;
            devices = (BAaPhpDevice[])ArrayUtil.addOne((Object[])devices, (Object)((BAaPhpDevice)selection[i]));
        }
        return devices;
    }

    class DiscoveryListSubscriber
    extends Subscriber {
        DiscoveryListSubscriber() {
        }

        public void event(BComponentEvent event) {
            BAaPhpDeviceManager.this.updateLearnData();
        }
    }

    class AaPhpDeviceController
    extends DeviceController {
        final AaPhpSendFileCommand sendFileCommand;
        final AaPhpRecvFileCommand recvFileCommand;
        final AaPhpExamineSetupCommand examineSetupCommand;

        AaPhpDeviceController(BDeviceManager mgr) {
            super(mgr);
            this.sendFileCommand = new AaPhpSendFileCommand((BAaPhpDeviceManager)mgr);
            this.sendFileCommand.setFlags(7);
            this.recvFileCommand = new AaPhpRecvFileCommand((BAaPhpDeviceManager)mgr);
            this.recvFileCommand.setFlags(7);
            this.examineSetupCommand = new AaPhpExamineSetupCommand((BAaPhpDeviceManager)mgr);
            this.examineSetupCommand.setFlags(7);
        }

        protected MgrController.IMgrCommand[] makeCommands() {
            return AaPhpDeviceController.append((MgrController.IMgrCommand[])super.makeCommands(), (MgrController.IMgrCommand[])new MgrController.IMgrCommand[]{this.sendFileCommand, this.recvFileCommand, this.examineSetupCommand});
        }

        public void updateAaPhpSpecialCommands() {
            boolean newEnableState = false;
            BAaPhpDevice[] selection = BAaPhpDeviceManager.this.getSelectedDevices();
            BJob j = BAaPhpDeviceManager.this.getLearn().getJob();
            if (!(selection == null || selection.length != 1 || j != null && j.isAlive())) {
                newEnableState = true;
            }
            this.sendFileCommand.setEnabled(newEnableState);
            this.recvFileCommand.setEnabled(newEnableState);
            this.examineSetupCommand.setEnabled(newEnableState);
        }

        public void updateCommands() {
            super.updateCommands();
            this.updateAaPhpSpecialCommands();
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BAaPhpNetwork aaphpNet = BAaPhpDeviceManager.this.getAaPhpNetwork();
            BAaPhpLearnDevicesParameter learnParam = (BAaPhpLearnDevicesParameter)BWbFieldEditor.dialog((BWidget)this.getManager(), (String)lex.getText("discoverDevices.prompt.title"), (BObject)aaphpNet.getLastLearnParam().newCopy());
            if (learnParam != null) {
                aaphpNet.setLastLearnParam((BAaPhpLearnDevicesParameter)learnParam.newCopy());
                BOrd ordToDiscoveryJob = aaphpNet.submitDeviceDiscoveryJob(learnParam);
                BAaPhpDeviceManager.this.getLearn().setJob(ordToDiscoveryJob);
            }
            return null;
        }
    }

    class AaPhpDeviceLearn
    extends MgrLearn {
        AaPhpDeviceLearn() {
            super((BAbstractManager)BAaPhpDeviceManager.this);
        }

        protected MgrColumn[] makeColumns() {
            return new MgrColumn[]{new MgrColumn.Prop(BAaPhpLearnDeviceEntry.deviceName, 1), new MgrColumn.Prop(BAaPhpLearnDeviceEntry.unitNumberAddress, 1)};
        }

        public MgrTypeInfo[] toTypes(Object discovery) {
            return MgrTypeInfo.makeArray((Type)BAaPhpDeviceManager.this.getAaPhpNetwork().getDeviceType());
        }

        public void toRow(Object discovery, MgrEditRow row) {
            BAaPhpLearnDeviceEntry learnEntry = (BAaPhpLearnDeviceEntry)discovery;
            row.setCell(BAaPhpDeviceManager.this.colAddress, (BValue)BInteger.make((int)learnEntry.getUnitNumberAddress()));
            row.setDefaultName(learnEntry.getDeviceName());
        }

        public boolean isExisting(Object dis, BComponent comp) {
            BAaPhpLearnDeviceEntry learnEntry = (BAaPhpLearnDeviceEntry)dis;
            BAaPhpDevice d = (BAaPhpDevice)comp;
            return BAaPhpDeviceManager.this.getAaPhpNetwork().translateAddress(d.getAddress()) == learnEntry.getUnitNumberAddress();
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            if (job instanceof BAaPhpLearnDevicesJob) {
                BAaPhpDeviceManager.this.updateLearnData();
            } else if (job instanceof BAaPhpGatherSetupInfoJob) {
                BAaPhpDeviceManager.this.gatherSetupInfoJobComplete((BAaPhpGatherSetupInfoJob)job);
            }
        }
    }

    class AaPhpDeviceModel
    extends DeviceModel {
        AaPhpDeviceModel(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BAaPhpDeviceManager.this.cols;
        }
    }
}

