/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.fcTagDict.relation;

import com.tridium.fcTagDict.common.BSourceLocationType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMarker;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.tag.BasicRelation;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;
import javax.baja.tagdictionary.BRelationInfo;
import javax.baja.util.BTypeSpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="findObjectRelationFrom", type="BSourceLocationType", defaultValue="BSourceLocationType.entity"), @NiagaraProperty(name="relatedObjectType", type="BTypeSpec", defaultValue="BTypeSpec.NULL", facets={@Facet(name="\"showAbstract\"", value="BBoolean.TRUE"), @Facet(name="\"showInterface\"", value="BBoolean.TRUE")}), @NiagaraProperty(name="outboundRelations", type="BFacets", defaultValue="BFacets.DEFAULT"), @NiagaraProperty(name="inboundRelations", type="BFacets", defaultValue="BFacets.DEFAULT")})
public class BCustomRelation
extends BRelationInfo {
    public static final Property findObjectRelationFrom = BCustomRelation.newProperty((int)0, (BValue)BSourceLocationType.entity, null);
    public static final Property relatedObjectType = BCustomRelation.newProperty((int)0, (BValue)BTypeSpec.NULL, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showAbstract", (BIDataValue)BBoolean.TRUE), (BFacets)BFacets.make((String)"showInterface", (BIDataValue)BBoolean.TRUE)));
    public static final Property outboundRelations = BCustomRelation.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Property inboundRelations = BCustomRelation.newProperty((int)0, (BValue)BFacets.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BCustomRelation.class);
    private final String STATION_PATH = "slot:/";
    private final String BQL_PREFIX = "station:|";
    private final String BQL_QUERY_FRAGMENT = "|bql:select * from ";

    public BSourceLocationType getFindObjectRelationFrom() {
        return (BSourceLocationType)this.get(findObjectRelationFrom);
    }

    public void setFindObjectRelationFrom(BSourceLocationType v) {
        this.set(findObjectRelationFrom, (BValue)v, null);
    }

    public BTypeSpec getRelatedObjectType() {
        return (BTypeSpec)this.get(relatedObjectType);
    }

    public void setRelatedObjectType(BTypeSpec v) {
        this.set(relatedObjectType, (BValue)v, null);
    }

    public BFacets getOutboundRelations() {
        return (BFacets)this.get(outboundRelations);
    }

    public void setOutboundRelations(BFacets v) {
        this.set(outboundRelations, (BValue)v, null);
    }

    public BFacets getInboundRelations() {
        return (BFacets)this.get(inboundRelations);
    }

    public void setInboundRelations(BFacets v) {
        this.set(inboundRelations, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void addRelations(Entity entity, Collection<Relation> relations) {
        boolean isCompMounted;
        boolean bl = isCompMounted = entity instanceof BComponent && ((BComponent)entity).isMounted();
        if (!isCompMounted) {
            return;
        }
        try {
            BComponent[] objectList;
            for (BComponent objectComponent : objectList = this.getAllObjectList((BComponent)entity)) {
                for (Id inBoundRelationId : this.getInboundRelationArray()) {
                    relations.add((Relation)new BasicRelation(inBoundRelationId, (Entity)objectComponent, true));
                }
                for (Id outBoundRelationId : this.getOutboundRelationArray()) {
                    relations.add((Relation)new BasicRelation(outBoundRelationId, (Entity)objectComponent, false));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Optional<Relation> getRelation(Entity entity) {
        boolean isCompMounted;
        boolean bl = isCompMounted = entity instanceof BComponent && ((BComponent)entity).isMounted();
        if (!isCompMounted) {
            return Optional.empty();
        }
        try {
            BComponent[] predicateList;
            for (BComponent component : predicateList = this.getAllObjectList((BComponent)entity)) {
                int n = 0;
                Id[] idArray = this.getInboundRelationArray();
                int n2 = idArray.length;
                if (n < n2) {
                    Id inBoundRelationId = idArray[n];
                    return Optional.of(new BasicRelation(inBoundRelationId, (Entity)component, true));
                }
                n = 0;
                idArray = this.getOutboundRelationArray();
                n2 = idArray.length;
                if (n >= n2) continue;
                Id outBoundRelationId = idArray[n];
                return Optional.of(new BasicRelation(outBoundRelationId, (Entity)component, false));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    private BComponent[] getAllObjectList(BComponent entityComp) {
        String bqlQuery = this.createBqlQuery(entityComp);
        ArrayList<BComponent> components = new ArrayList<BComponent>();
        BOrd networksQuery = BOrd.make((String)bqlQuery);
        BITable result = (BITable)networksQuery.get();
        try (TableCursor c = result.cursor();){
            while (c.next()) {
                BComponent bComponent = (BComponent)c.get();
                components.add(bComponent);
            }
        }
        return components.toArray(new BComponent[components.size()]);
    }

    private String createBqlQuery(BComponent entityComp) {
        String queryPath = "";
        if (this.getFindObjectRelationFrom() == BSourceLocationType.entity) {
            queryPath = entityComp.getSlotPathOrd().toString(null);
        } else if (this.getFindObjectRelationFrom() == BSourceLocationType.station) {
            queryPath = "slot:/";
        }
        return "station:|" + queryPath + "|bql:select * from " + this.getRelatedObjectType().toString(null);
    }

    private Id[] getRelations(BFacets facets) {
        String[] keyList = facets.list();
        ArrayList<Id> relIdList = new ArrayList<Id>();
        for (String key : keyList) {
            if (!BMarker.MARKER.toString().equals(facets.gets(key, null))) continue;
            String strRelation = SlotPath.unescape((String)key);
            try {
                relIdList.add(Id.newId((String)strRelation));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return relIdList.toArray(new Id[relIdList.size()]);
    }

    private Id[] getInboundRelationArray() {
        return this.getRelations(this.getInboundRelations());
    }

    private Id[] getOutboundRelationArray() {
        return this.getRelations(this.getOutboundRelations());
    }
}

