/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.awsUtils;

import com.tridium.awsUtils.AwsUtils;
import com.tridium.awsUtils.auth.AwsAccessCredentials;
import com.tridium.awsUtils.auth.AwsAuthException;
import com.tridium.awsUtils.auth.AwsAuthUtils;
import com.tridium.awsUtils.auth.BAwsAccessKeyFolder;
import com.tridium.awsUtils.iot.BAwsIoT;
import com.tridium.awsUtils.rest.AwsRestClient;
import com.tridium.awsUtils.rest.AwsRestException;
import com.tridium.awsUtils.rest.requests.IAwsRequest;
import com.tridium.json.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Optional;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BAbstractService;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="regionRange", type="BEnumRange", defaultValue="BEnumRange.make(new String[]{})", flags=4), @NiagaraProperty(name="region", type="BDynamicEnum", defaultValue="BDynamicEnum.make(0, BEnumRange.DEFAULT)"), @NiagaraProperty(name="accessKeys", type="BAwsAccessKeyFolder", defaultValue="new BAwsAccessKeyFolder()"), @NiagaraProperty(name="awsIoT", type="BAwsIoT", defaultValue="new BAwsIoT()")})
public class BAwsService
extends BAbstractService
implements BIRestrictedComponent {
    @Generated
    public static final Property regionRange = BAwsService.newProperty((int)4, (BValue)BEnumRange.make((String[])new String[0]), null);
    @Generated
    public static final Property region = BAwsService.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.DEFAULT), null);
    @Generated
    public static final Property accessKeys = BAwsService.newProperty((int)0, (BValue)new BAwsAccessKeyFolder(), null);
    @Generated
    public static final Property awsIoT = BAwsService.newProperty((int)0, (BValue)new BAwsIoT(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAwsService.class);
    public static final Lexicon LEX = Lexicon.make(BAwsService.class);
    public static final Logger AWS_LOG = Logger.getLogger("awsUtils");
    private static final String[] KNOWN_REGIONS = new String[]{"af-south-1", "ap-east-1", "ap-northeast-1", "ap-northeast-2", "ap-northeast-3", "ap-south-1", "ap-southeast-1", "ap-southeast-2", "ap-southeast-3", "ca-central-1", "eu-central-1", "eu-north-1", "eu-south-1", "eu-west-1", "eu-west-2", "eu-west-3", "me-south-1", "sa-east-1", "us-east-1", "us-east-2", "us-west-1", "us-west-2", "us-gov-east-1", "us-gov-west-1"};
    private static final BIcon ICON = BIcon.std((String)"cloud.png");

    @Generated
    public BEnumRange getRegionRange() {
        return (BEnumRange)this.get(regionRange);
    }

    @Generated
    public void setRegionRange(BEnumRange v) {
        this.set(regionRange, (BValue)v, null);
    }

    @Generated
    public BDynamicEnum getRegion() {
        return (BDynamicEnum)this.get(region);
    }

    @Generated
    public void setRegion(BDynamicEnum v) {
        this.set(region, (BValue)v, null);
    }

    @Generated
    public BAwsAccessKeyFolder getAccessKeys() {
        return (BAwsAccessKeyFolder)this.get(accessKeys);
    }

    @Generated
    public void setAccessKeys(BAwsAccessKeyFolder v) {
        this.set(accessKeys, (BValue)v, null);
    }

    @Generated
    public BAwsIoT getAwsIoT() {
        return (BAwsIoT)this.get(awsIoT);
    }

    @Generated
    public void setAwsIoT(BAwsIoT v) {
        this.set(awsIoT, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type[] getServiceTypes() {
        return new Type[]{this.getType()};
    }

    public void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentIsServiceContainer((BComponent)parent, (BIRestrictedComponent)this);
        BIRestrictedComponent.checkForDuplicates((BComponent)parent, (BIRestrictedComponent)this, (boolean)false);
    }

    public void started() throws Exception {
        this.updateRegions();
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property.equals(regionRange)) {
            this.updateRegions();
        }
    }

    private void updateRegions() {
        HashSet<String> existingRegions = new HashSet<String>();
        ArrayList<String> newRange = new ArrayList<String>();
        for (int i = 0; i < this.getRegionRange().getOrdinals().length; ++i) {
            String region = this.getRegionRange().getTag(i);
            existingRegions.add(region);
            newRange.add(i, region);
        }
        int indexForNewEntries = this.getRegionRange().getOrdinals().length;
        for (String region : KNOWN_REGIONS) {
            String escRegion = SlotPath.escape((String)region);
            if (existingRegions.contains(escRegion)) continue;
            newRange.add(indexForNewEntries++, escRegion);
        }
        this.setRegionRange(BEnumRange.make((String[])newRange.toArray(new String[0])));
        this.setRegion(BDynamicEnum.make((int)this.getRegion().getOrdinal(), (BEnumRange)this.getRegionRange()));
    }

    public JSONObject sendAwsRequest(IAwsRequest request, String accessKeyId, Context cx) throws AwsRestException, AwsAuthException {
        if (!this.getEnabled()) {
            throw new AwsRestException(LEX.get("aws.service.not.enabled"), request);
        }
        if (accessKeyId.isEmpty()) {
            throw new AwsRestException(LEX.getText("aws.rest.no.accessKeyId"), request);
        }
        AwsUtils.checkAwsPermission();
        AwsAccessCredentials credentials = AwsAuthUtils.getCredentials(this.getRegion().getTag(), accessKeyId, cx);
        AwsRestClient awsRestSender = new AwsRestClient(credentials);
        return BAwsService.sendAwsRequest(awsRestSender, request);
    }

    private static JSONObject sendAwsRequest(AwsRestClient awsRestSender, IAwsRequest request) throws AwsRestException {
        Optional<String> response = awsRestSender.send(request);
        if (response.isPresent()) {
            String rspJson = response.get();
            return new JSONObject(rspJson);
        }
        return new JSONObject();
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        AwsRestClient.appendCounts(out);
    }

    public BIcon getIcon() {
        return ICON;
    }
}

