/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule.ui;

import com.tridium.schedule.ui.BAbstractScheduleWidget;
import com.tridium.schedule.ui.BStatusValueEd;
import com.tridium.schedule.ui.BTimeWidget;
import com.tridium.schedule.ui.Utils;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="finishModified"), @NiagaraAction(name="outputModified"), @NiagaraAction(name="startModified")})
public class BTimeScheduleEd
extends BAbstractScheduleWidget {
    @Generated
    public static final Action finishModified = BTimeScheduleEd.newAction((int)0, null);
    @Generated
    public static final Action outputModified = BTimeScheduleEd.newAction((int)0, null);
    @Generated
    public static final Action startModified = BTimeScheduleEd.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTimeScheduleEd.class);
    boolean loading = false;
    BTime earliestStart;
    BFacets facets;
    BWbFieldEditor finish;
    BTime latestFinish;
    BStatusValueEd output;
    BStatusValue prototype;
    BTimeSchedule schedule;
    BWbFieldEditor start;

    @Generated
    public void finishModified() {
        this.invoke(finishModified, null, null);
    }

    @Generated
    public void outputModified() {
        this.invoke(outputModified, null, null);
    }

    @Generated
    public void startModified() {
        this.invoke(startModified, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BTimeScheduleEd() {
        BTime t = BTime.make((BAbsTime)Clock.time());
        this.start = new BTimeWidget();
        this.start.setReadonly(true);
        this.start.loadValue((BObject)t);
        this.finish = new BTimeWidget();
        this.finish.setReadonly(true);
        this.finish.loadValue((BObject)t);
        this.output = new BStatusValueEd();
        BGridPane gp = new BGridPane(2);
        gp.setValign(BValign.center);
        gp.setHalign(BHalign.left);
        gp.add("startLabel", (BValue)new BLabel(this.lex("day.start")));
        gp.add("start", (BValue)this.start);
        gp.add("finishLabel", (BValue)new BLabel(this.lex("day.finish")));
        gp.add("finish", (BValue)this.finish);
        gp.add("outLabel", (BValue)new BLabel(this.lex("day.output")));
        gp.add("output", (BValue)this.output);
        this.setContent((BWidget)gp);
        this.linkTo((BComponent)this.start, (Slot)BTimeWidget.pluginModified, (Slot)startModified);
        this.linkTo((BComponent)this.finish, (Slot)BTimeWidget.pluginModified, (Slot)finishModified);
        this.linkTo((BComponent)this.output, (Slot)BStatusValueEd.modified, (Slot)outputModified);
    }

    public void doFinishModified() {
        if (this.loading) {
            return;
        }
        try {
            BTime val = (BTime)this.finish.saveValue();
            if (this.latestFinish.getTimeOfDayMillis() > 0L && val.isAfter(this.latestFinish)) {
                val = this.latestFinish;
                this.finish.loadValue((BObject)val, null);
            } else {
                long earliestFinish = this.schedule.getStart().getTimeOfDayMillis() + 60000L;
                if (val.getTimeOfDayMillis() < earliestFinish) {
                    val = BTime.make((BRelTime)BRelTime.make((long)earliestFinish));
                    this.finish.loadValue((BObject)val, null);
                }
            }
            this.schedule.setFinish(val);
            this.fireModified(null);
        }
        catch (Exception x) {
            Utils.error(this, x);
        }
    }

    @Override
    public void doLayout(BWidget[] kids) {
        BAbstractSchedule root;
        BFacets tmp;
        if (this.schedule != null && (tmp = (BFacets)(root = this.schedule.getRootSchedule()).get("facets")) != null && tmp != this.facets) {
            this.facets = tmp;
            if (this.output != null) {
                this.output.load(this.schedule.getEffectiveValue(), this.facets);
            }
        }
        super.doLayout(kids);
    }

    public void doOutputModified() {
        if (this.loading) {
            return;
        }
        this.fireModified(null);
    }

    public void doStartModified() {
        if (this.loading) {
            return;
        }
        try {
            BTime val = (BTime)this.start.saveValue();
            if (val.isBefore(this.earliestStart)) {
                val = this.earliestStart;
                this.start.loadValue((BObject)val, null);
            } else {
                long latestStart = this.schedule.getFinish().getTimeOfDayMillis();
                if (latestStart == 0L) {
                    latestStart = 86400000L;
                }
                if (val.getTimeOfDayMillis() > (latestStart -= 60000L)) {
                    val = BTime.make((BRelTime)BRelTime.make((long)latestStart));
                    this.start.loadValue((BObject)val, null);
                }
            }
            this.schedule.setStart(val);
            this.fireModified(null);
        }
        catch (Exception x) {
            Utils.error(this, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(BTimeSchedule sch, BTime earliestStart, BTime latestFinish) {
        try {
            this.schedule = sch;
            this.earliestStart = earliestStart;
            this.latestFinish = latestFinish;
            this.loading = true;
            this.start.loadValue((BObject)this.schedule.getStart(), null);
            this.finish.loadValue((BObject)this.schedule.getFinish(), null);
            BAbstractSchedule root = sch.getRootSchedule();
            this.facets = (BFacets)root.get("facets");
            this.output.load(this.schedule.getEffectiveValue(), this.facets);
        }
        finally {
            this.loading = false;
        }
    }

    public void loadProto(BStatusValue proto, BFacets rootFacets) {
        this.prototype = proto;
        this.output.load(this.prototype, rootFacets);
        this.output.setReadonly(true);
        BTime t = BTime.make((BAbsTime)Clock.time());
        this.start.loadValue((BObject)t, null);
        this.finish.loadValue((BObject)t, null);
    }

    public void reload() {
        if (this.schedule == null) {
            return;
        }
        try {
            this.loading = true;
            this.start.loadValue((BObject)this.schedule.getStart(), null);
            this.finish.loadValue((BObject)this.schedule.getFinish(), null);
            this.start.repaint();
            this.finish.repaint();
        }
        finally {
            this.loading = false;
        }
    }

    @Override
    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        if (this.start != null) {
            this.start.setReadonly(ro);
            this.finish.setReadonly(ro);
            this.output.setReadonly(ro);
        }
    }
}

