/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platMstp.BBacnetMstpPlatformService;
import com.tridium.platMstp.BBacnetMstpPlatformServiceEmstp;
import com.tridium.platMstp.MstpFrame;
import com.tridium.platMstp.MstpListener;
import java.io.File;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.license.LicenseDatabaseException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.PortDeniedException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetMstpPlatformServiceQnx
extends BBacnetMstpPlatformServiceEmstp {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMstpPlatformServiceQnx.class);
    private static boolean nativesLoaded = false;
    private final HashMap<Integer, MstpTrunkListener> trunkListeners = new HashMap();
    private Process mstpd;

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isValidPlatform() {
        return PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx);
    }

    protected synchronized boolean loadLibraries() {
        if (this.usingCoprocessor) {
            return true;
        }
        if (nativesLoaded) {
            return true;
        }
        return AccessController.doPrivileged(() -> {
            try {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("BacnetMstp: Loading platmstp native library");
                }
                System.loadLibrary("platmstp");
                nativesLoaded = true;
            }
            catch (Throwable e) {
                log.log(Level.SEVERE, "BacnetMstp: Cannot load platmstp native library", e);
            }
            return nativesLoaded;
        });
    }

    @Override
    protected boolean initMstp() {
        if (!this.loadLibraries()) {
            throw new RuntimeException("Cannot load mstp natives");
        }
        AtomicBoolean initSuccess = new AtomicBoolean(false);
        try {
            AccessController.doPrivileged(() -> {
                File f = new File("/dev/mstp1");
                if (f.exists()) {
                    log.info("BacnetMstp: MSTP daemon already running");
                } else {
                    String[] opts;
                    int numTrunks = 6;
                    int usageTimeout = 20;
                    String extraOpts = "";
                    String optString = "-n " + numTrunks + " -u " + usageTimeout;
                    try {
                        optString = FileUtil.readString((File)new File("/var/cookies/mstp.opt"));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (String opt : opts = optString.split("-")) {
                        String arg = opt.trim();
                        if (arg.isEmpty()) continue;
                        if (arg.startsWith("n")) {
                            try {
                                numTrunks = Integer.parseInt(arg.substring(1).trim());
                            }
                            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
                            continue;
                        }
                        if (arg.startsWith("u")) {
                            try {
                                usageTimeout = Integer.parseInt(arg.substring(1).trim());
                            }
                            catch (IndexOutOfBoundsException | NumberFormatException runtimeException) {}
                            continue;
                        }
                        if (arg.startsWith("?") || arg.startsWith("t")) continue;
                        extraOpts = " -" + arg;
                    }
                    try {
                        int numTrunksLicensed = 6;
                        Feature feat = Sys.getLicenseManager().checkFeature("tridium", this.getLicenseFeature());
                        String portLimit = feat.get("port.limit");
                        if (portLimit != null && !"none".equals(TextUtil.toLowerCase((String)portLimit))) {
                            numTrunksLicensed = Integer.parseInt(portLimit);
                        }
                        if (numTrunksLicensed > 6) {
                            numTrunksLicensed = 6;
                        }
                        if (numTrunksLicensed < numTrunks) {
                            numTrunks = numTrunksLicensed;
                        }
                        if (!this.usingCoprocessor) {
                            ArrayList<String> command = new ArrayList<String>(Arrays.asList(("/proc/boot/mstp -n " + numTrunks + " -u " + usageTimeout).split(" ")));
                            if (!extraOpts.isEmpty()) {
                                command.addAll(Arrays.asList(extraOpts.split(" ")));
                            }
                            this.mstpd = new ProcessBuilder(command.toArray(new String[0])).start();
                        }
                    }
                    catch (FeatureNotLicensedException | LicenseDatabaseException ignored) {
                        initSuccess.set(false);
                        return null;
                    }
                }
                initSuccess.set(true);
                return null;
            });
        }
        catch (PrivilegedActionException pae) {
            throw new RuntimeException(pae.getException());
        }
        return initSuccess.get();
    }

    @Override
    protected void cleanupMstp() {
        if (this.mstpd != null) {
            this.mstpd.destroy();
            this.mstpd = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int startDriverLegacy(String trunk, String osSerialPortName, int baudRate, int tsAddr, int maxMaster, int maxFrames, MstpListener linkListener) {
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Starting mstp driver on " + osSerialPortName + " at " + baudRate + " baud, tsAddr=" + tsAddr + " maxMaster=" + maxMaster + " maxInfoFrames=" + maxFrames);
        }
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Cannot load mstp natives");
        }
        if (osSerialPortName == null) {
            throw new NullPointerException("BacnetMstp: Invalid serial port");
        }
        boolean success = false;
        try {
            this.lockSerial(osSerialPortName);
        }
        catch (PortDeniedException pde) {
            log.severe("BacnetMstp: Failed to obtain lock on " + osSerialPortName);
            throw new RuntimeException("BacnetMstp: Failed to obtain lock on " + osSerialPortName);
        }
        try {
            int handle = this.openDriver0(trunk, osSerialPortName, baudRate, tsAddr, maxMaster, maxFrames);
            if (handle == -1) {
                log.severe("BacnetMstp: Cannot get handle to mstp daemon " + trunk);
                throw new RuntimeException("BacnetMstp: Cannot get handle to mstp daemon " + trunk);
            }
            this.handleToName.put(handle, osSerialPortName);
            MstpTrunkListener trunkListener = new MstpTrunkListener(handle, linkListener);
            Thread trunkListenerThread = new Thread((Runnable)trunkListener, "BacnetMstp:MstpTrunkListener" + handle);
            trunkListenerThread.start();
            trunkListener.myThread = trunkListenerThread;
            this.trunkListeners.put(handle, trunkListener);
            success = true;
            int n = handle;
            return n;
        }
        finally {
            if (!success) {
                try {
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("BacnetMstp: Failed to open MSTP, unlocking serial device " + osSerialPortName);
                    }
                    this.unlockSerial(osSerialPortName);
                }
                catch (PortDeniedException pde) {
                    log.log(Level.WARNING, "BacnetMstp: Failed to unlock mstp serial device " + osSerialPortName, pde);
                }
            }
        }
    }

    @Override
    protected void stopDriverLegacy(int handle) {
        String port = (String)this.handleToName.get(handle);
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Stopping mstp driver on " + port);
        }
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Stopping mstp driver but drivers are not loaded, port " + port);
        }
        MstpTrunkListener ls = this.trunkListeners.get(handle);
        if (ls == null) {
            throw new RuntimeException("BacnetMstp: Stopping trunk listeners, but invalid mstp trunk listener handle for " + port);
        }
        ls.done = true;
        ls.myThread.interrupt();
        this.closeDriver0(handle);
        this.handleToName.remove(handle);
        try {
            this.unlockSerial(port);
        }
        catch (PortDeniedException pde) {
            log.severe("BacnetMstp: Stopping trunk listeners, but failed to unlock " + port);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Driver stopped on " + port);
        }
    }

    @Override
    public void sendFrameLegacy(int handle, byte destAddr, byte[] packet, boolean dataExpectingReply) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        this.sendFrame0(handle, (byte)(destAddr & 0xFF), packet, dataExpectingReply);
    }

    @Override
    protected void setBaudRateLegacy(int handle, int baudRate) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Setting baud rate on " + (String)this.handleToName.get(handle) + " to " + baudRate);
        }
        this.setBaudRate0(handle, baudRate);
    }

    @Override
    protected void setMaxMasterLegacy(int handle, int maxMaster) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Setting max master on " + (String)this.handleToName.get(handle) + " to " + maxMaster);
        }
        this.setMaxMaster0(handle, maxMaster);
    }

    @Override
    protected void setMaxInfoFramesLegacy(int handle, int maxInfoFrames) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Setting max info frames on " + (String)this.handleToName.get(handle) + " to " + maxInfoFrames);
        }
        this.setMaxInfoFrames0(handle, maxInfoFrames);
    }

    @Override
    protected void setAddressLegacy(int handle, int macAddress) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Setting address on " + (String)this.handleToName.get(handle) + " to " + macAddress);
        }
        this.setAddress0(handle, macAddress);
    }

    @Override
    protected int getAddressLegacy(int handle) {
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        return this.getAddress0(handle);
    }

    @Override
    protected void setParameterLegacy(int handle, String name, String value) {
        if (name == null || value == null) {
            throw new RuntimeException("BacnetMstp: Null mstp parameter");
        }
        if (!this.loadLibraries()) {
            throw new RuntimeException("BacnetMstp: Mstp natives not loaded");
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("BacnetMstp: Setting mstp parameter " + name + " on " + (String)this.handleToName.get(handle) + " to " + value);
        }
        this.setParameter0(handle, name, value);
    }

    private native int openDriver0(String var1, String var2, int var3, int var4, int var5, int var6);

    private native void closeDriver0(int var1);

    private native void rcvFrame0(int var1, MstpFrame var2);

    private native void sendFrame0(int var1, byte var2, byte[] var3, boolean var4);

    private native void setBaudRate0(int var1, int var2);

    private native void setMaxMaster0(int var1, int var2);

    private native void setMaxInfoFrames0(int var1, int var2);

    private native void setAddress0(int var1, int var2);

    private native int getAddress0(int var1);

    private native void setParameter0(int var1, String var2, String var3);

    class MstpTrunkListener
    implements Runnable {
        int handle;
        MstpListener linkListener;
        Thread myThread;
        boolean done = false;
        String portName;

        public MstpTrunkListener(int handle, MstpListener linkListener) {
            this.handle = handle;
            this.linkListener = linkListener;
            this.portName = (String)BBacnetMstpPlatformServiceQnx.this.handleToName.get(handle);
        }

        @Override
        public void run() {
            MstpFrame frame = new MstpFrame();
            if (BBacnetMstpPlatformService.log.isLoggable(Level.FINE)) {
                BBacnetMstpPlatformService.log.fine("BacnetMstp: Mstp trunk listener starting on port " + this.portName);
            }
            while (!this.done) {
                try {
                    BBacnetMstpPlatformServiceQnx.this.rcvFrame0(this.handle, frame);
                    if (this.linkListener == null) continue;
                    this.linkListener.receiveFrame(frame.getAddr(), frame.getData(), frame.getDataExpectingReply());
                }
                catch (Exception e) {
                    if (this.done) continue;
                    e.printStackTrace();
                }
            }
            if (BBacnetMstpPlatformService.log.isLoggable(Level.FINE)) {
                BBacnetMstpPlatformService.log.fine("BacnetMstp: Mstp trunk listener done on " + this.portName);
            }
        }
    }
}

