/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platMstp;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platMstp.BBacnetMstpLinkParameters;
import com.tridium.platMstp.MstpListener;
import com.tridium.platSerial.BSerialPort;
import com.tridium.platSerial.BSerialPortPlatformService;
import com.tridium.platform.BPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.serial.BISerialService;
import javax.baja.serial.PortDeniedException;
import javax.baja.serial.PortNotFoundException;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="useCoprocessor", type="boolean", defaultValue="true", flags=4)
@NiagaraAction(name="testCommDriver", parameterType="BBacnetMstpLinkParameters", defaultValue="new BBacnetMstpLinkParameters()", flags=20)
public abstract class BBacnetMstpPlatformService
extends BPlatformService {
    @Generated
    public static final Property useCoprocessor = BBacnetMstpPlatformService.newProperty((int)4, (boolean)true, null);
    @Generated
    public static final Action testCommDriver = BBacnetMstpPlatformService.newAction((int)20, (BValue)new BBacnetMstpLinkParameters(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetMstpPlatformService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/serialPortService.png");
    public static Logger log = Logger.getLogger("platmstp");
    protected static String STATION_PREFIX = "station:";
    private static volatile BSerialPortPlatformService serialPortPlatformService = null;
    HashMap<Integer, String> handleToName = new HashMap();
    public static final String MSTP_TRUNK_PREFIX = "/dev/mstp";
    private static int numMessagesSent = 0;
    private static int numMessagesReceived = 0;

    @Generated
    public boolean getUseCoprocessor() {
        return this.getBoolean(useCoprocessor);
    }

    @Generated
    public void setUseCoprocessor(boolean v) {
        this.setBoolean(useCoprocessor, v, null);
    }

    @Generated
    public void testCommDriver(BBacnetMstpLinkParameters parameter) {
        this.invoke(testCommDriver, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetMstpPlatformService() {
        this.setPlatformServiceDescription(this.getLexicon().getText("BacnetMstpPlatformService.description"));
    }

    public String getLicenseFeature() {
        return "mstp";
    }

    public BIcon getIcon() {
        return icon;
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    protected abstract boolean initMstp();

    protected abstract void cleanupMstp();

    public abstract int startDriver(String var1, String var2, int var3, int var4, int var5, int var6, MstpListener var7);

    public abstract void stopDriver(int var1);

    public abstract void setBaudRate(int var1, int var2);

    public abstract void setMaxMaster(int var1, int var2);

    public abstract void setMaxInfoFrames(int var1, int var2);

    public abstract void setAddress(int var1, int var2);

    public abstract void sendFrame(int var1, byte var2, byte[] var3, boolean var4);

    public abstract int getAddress(int var1);

    public abstract void setParameter(int var1, String var2, String var3);

    synchronized void lockSerial(String osPortName) throws PortDeniedException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to lock " + osPortName + " for owner BacnetMstp");
        }
        if (osPortName == null) {
            throw new NullPointerException("Can not lock null device");
        }
        String lockFileName = this.getLockFileName(osPortName);
        if (lockFileName == null) {
            log.severe("Can not lock " + osPortName + ", can not map os name to lock file");
            return;
        }
        String currentOwner = this.getLockFileOwner(lockFileName);
        if (!"none".equalsIgnoreCase(currentOwner)) {
            log.severe("Unable to create lock for " + osPortName + " for owner BacnetMstp, already owned by " + currentOwner);
            throw new PortDeniedException("Unable to create lock for " + osPortName + " for owner BacnetMstp, already owned by " + currentOwner);
        }
        try {
            FileOutputStream fos;
            try {
                fos = AccessController.doPrivileged(() -> new FileOutputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            fos.write((STATION_PREFIX + "BacnetMstp").getBytes(StandardCharsets.UTF_8));
            fos.close();
        }
        catch (Exception e) {
            log.severe("Unable to create lock for " + osPortName + " for owner BacnetMstp : " + e);
            throw new PortDeniedException("Unable to create lock for " + osPortName + " for owner BacnetMstp : " + e);
        }
        this.setOwner(osPortName, "BacnetMstp");
        if (log.isLoggable(Level.FINE)) {
            log.fine(osPortName + " locked for owner BacnetMstp");
        }
    }

    synchronized void unlockSerial(String osPortName) throws PortDeniedException {
        if (log.isLoggable(Level.FINE)) {
            log.fine("Attempting to unlock " + osPortName + " as owner BacnetMstp");
        }
        if (osPortName == null) {
            throw new NullPointerException("Can not unlock null device");
        }
        String lockFileName = this.getLockFileName(osPortName);
        if (lockFileName == null) {
            log.severe("Can not unlock " + osPortName + ", can not map lock file");
            return;
        }
        String currentOwner = this.getLockFileOwner(lockFileName);
        if (!currentOwner.equalsIgnoreCase(STATION_PREFIX + "BacnetMstp")) {
            throw new PortDeniedException("Unable to unlock " + osPortName + ", BacnetMstp does not have the port lock, owned by " + currentOwner);
        }
        File file = new File(lockFileName);
        boolean result = AccessController.doPrivileged(file::delete);
        if (!result) {
            throw new PortDeniedException("Unable to unlock " + osPortName + ", failed to delete " + lockFileName);
        }
        this.setOwner(osPortName, "none");
        if (log.isLoggable(Level.FINE)) {
            log.fine("Successfully released BacnetMstp lock on " + osPortName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLockFileOwner(String lockFileName) {
        FileInputStream fis = null;
        try {
            try {
                fis = AccessController.doPrivileged(() -> new FileInputStream(lockFileName));
            }
            catch (PrivilegedActionException e) {
                throw e.getException();
            }
            StringBuilder buf = new StringBuilder();
            int c = fis.read();
            while (c != -1) {
                buf.append((char)c);
                c = fis.read();
            }
            fis.close();
            String owner = buf.toString().trim();
            owner = TextUtil.replace((String)owner, (String)"\n", (String)"");
            String string = owner = TextUtil.replace((String)owner, (String)"\r", (String)"");
            return string;
        }
        catch (FileNotFoundException buf) {
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Problem reading lock file " + lockFileName + " for BacnetMstp defaulting to no ownership", e);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception exception) {}
        }
        return "none";
    }

    private void setOwner(String osPortName, String owner) {
        String[] portNames;
        if (BBacnetMstpPlatformService.getSerialService() == null) {
            log.severe("Could not locate serial port platform service, can not lock serial port for BacnetMstp");
            return;
        }
        for (String portName : portNames = serialPortPlatformService.getPortNames()) {
            BSerialPort serialPort = (BSerialPort)serialPortPlatformService.get(portName);
            if (!serialPort.getOsPortName().equalsIgnoreCase(osPortName)) continue;
            serialPort.setOwner(owner);
            return;
        }
    }

    private String getLockFileName(String osPortName) {
        if (BBacnetMstpPlatformService.getSerialService() == null) {
            log.severe("Could not locate serial port platform service, can not lock serial port for BacnetMstp");
            return null;
        }
        String[] portNames = serialPortPlatformService.getPortNames();
        int index = -1;
        for (String portName : portNames) {
            BSerialPort serialPort = (BSerialPort)serialPortPlatformService.get(portName);
            if (!serialPort.getOsPortName().equalsIgnoreCase(osPortName)) continue;
            index = serialPort.getPortIndex();
        }
        if (index == -1) {
            log.severe("Could not locate serial port index in serial port platform service serial platform service, can not lock serial port for BacnetMstp");
            return null;
        }
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            if (osPortName.contains("gprs")) {
                return "/dev/shmem" + File.separatorChar + "sergprs" + index + ".owner";
            }
            return "/dev/shmem" + File.separatorChar + "ser" + index + ".owner";
        }
        return TempDirectoryHolder.TEMP_DIRECTORY + File.separatorChar + "niagara-ser" + index + ".owner";
    }

    static BSerialPortPlatformService getSerialService() {
        if (serialPortPlatformService == null) {
            try {
                serialPortPlatformService = (BSerialPortPlatformService)Sys.getService((Type)BSerialPortPlatformService.TYPE);
            }
            catch (Exception ignored) {
                log.warning("mstp platform service cannot locate the serial port service");
            }
        }
        return serialPortPlatformService;
    }

    public void doTestCommDriver(final BBacnetMstpLinkParameters linkParameters) {
        new Thread("TestCommDriver"){

            @Override
            public void run() {
                BBacnetMstpPlatformService.this.doTestCommDriverEntry(linkParameters);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doTestCommDriverEntry(BBacnetMstpLinkParameters linkParameters) {
        String osName;
        BISerialService serialService;
        log.info("[TestCommDriver] Start");
        try {
            serialService = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
            serialService.checkPropertiesLoaded();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to load serial port service, can not test MSTP", e);
            return;
        }
        BComponent serialPortComponent = null;
        String serialPortName = linkParameters.getSerialPort();
        boolean lockSucceeded = false;
        try {
            serialPortComponent = (BComponent)((BComponent)serialService).get(serialPortName);
            if (serialPortComponent == null) {
                throw new PortNotFoundException(serialPortName);
            }
            Property p = serialPortComponent.getProperty("owner");
            String owner = serialPortComponent.getString(p);
            if (owner == null) {
                serialPortComponent.setString(p, "BacnetMstpTest");
            } else {
                if (!owner.isEmpty()) {
                    if (!"none".equals(owner)) throw new PortDeniedException(serialPortName + " is already owned by " + owner);
                }
                serialPortComponent.setString(p, "BacnetMstpTest");
            }
            lockSucceeded = true;
            Property osPortNameProp = serialPortComponent.getProperty("osPortName");
            osName = serialPortComponent.getString(osPortNameProp);
            if (osName == null) throw new PortDeniedException(serialPortName + " has invalid os name " + osName);
            if (osName.trim().isEmpty()) {
                throw new PortDeniedException(serialPortName + " has invalid os name " + osName);
            }
        }
        catch (Exception e) {
            try {
                if (lockSucceeded) {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
            }
            catch (Exception p) {
                // empty catch block
            }
            log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to resolve serial port " + serialPortName + " to OS name, can not test MSTP", e);
            return;
        }
        byte[] TOO_LARGE_BYTES = new byte[16384];
        String TOO_LARGE_STRING = new String(TOO_LARGE_BYTES);
        try {
            int handle;
            log.info("[TestCommDriver] Trying startDriver(null, " + osName + ", 1, 1, 1, 1, null);");
            try {
                this.startDriver(null, osName, 1, 1, 1, 1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", null, 1, 1, 1, 1, null);");
            try {
                this.startDriver("", null, 1, 1, 1, 1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", " + osName + ", -1, 1, 1, 1, null);");
            try {
                this.startDriver("", osName, -1, 1, 1, 1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", " + osName + ", 1, -1, 1, 1, null);");
            try {
                this.startDriver("", osName, 1, -1, 1, 1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", " + osName + ", 1, 1, -1, 1, null);");
            try {
                this.startDriver("", osName, 1, 1, -1, 1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", " + osName + ", 1, 1, 1, -1, null);");
            try {
                this.startDriver("", osName, 1, 1, 1, -1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying startDriver(\"\", " + osName + ", 1, 1, 1, -1, null);");
            try {
                this.startDriver("", osName, 1, 1, 1, -1, null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying stopDriver(-1);");
            try {
                this.stopDriver(-1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setBaudRate(-1, 57600);");
            try {
                this.setBaudRate(-1, 57600);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setBaudRate(1, -1);");
            try {
                this.setBaudRate(1, -1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setMaxMaster(-1, 127);");
            try {
                this.setMaxMaster(-1, 127);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setMaxMaster(1, -1);");
            try {
                this.setMaxMaster(1, -1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setMaxInfoFrames(-1, 20);");
            try {
                this.setMaxInfoFrames(-1, 20);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setMaxInfoFrames(1, -1);");
            try {
                this.setMaxInfoFrames(1, -1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setAddress(-1, 1);");
            try {
                this.setAddress(-1, 1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setAddress(1, -1);");
            try {
                this.setAddress(1, -1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendFrame(-1, (byte)0, new byte [] { 0x00 }, false);");
            try {
                this.sendFrame(-1, (byte)0, new byte[]{0}, false);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendFrame(1, (byte)1, null, false);");
            try {
                this.sendFrame(1, (byte)1, null, false);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying sendFrame(1, (byte)1, TOO_LARGE_BYTES, false);");
            try {
                this.sendFrame(1, (byte)1, TOO_LARGE_BYTES, false);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setParameter(-1, 'foo', 'foo');");
            try {
                this.setParameter(-1, "foo", "foo");
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setParameter(1, null, 'foo');");
            try {
                this.setParameter(1, null, "foo");
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setParameter(1, 'foo', null);");
            try {
                this.setParameter(1, "foo", null);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setParameter(1, TOO_LARGE_STRING, 'foo');");
            try {
                this.setParameter(1, TOO_LARGE_STRING, "foo");
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying setParameter(1, 'foo', TOO_LARGE_STRING);");
            try {
                this.setParameter(1, "foo", TOO_LARGE_STRING);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Trying getAddress(-1);");
            try {
                this.getAddress(-1);
            }
            catch (Throwable osPortNameProp) {
                // empty catch block
            }
            log.info("[TestCommDriver] Link checks passed");
            try {
                log.info("[TestCommDriver] Starting the MSTP driver on [ trunk = /dev/mstp1 | device = " + osName + " | baud = 19200 | address = 1 | max master = 127 | max info frames = 20 ]");
                handle = this.startDriver("/dev/mstp1", osName, linkParameters.getBaudRate().getOrdinal(), linkParameters.getAddress(), linkParameters.getMaxMaster(), linkParameters.getMaxInfoFrames(), new MstpTrunkTestListener());
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to open the MSTP port, can not test MSTP", e);
                try {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
                catch (Exception p) {
                    // empty catch block
                }
                log.info("[TestCommDriver] End");
                return;
            }
            log.info("[TestCommDriver] Opened the MSTP driver, handle = " + handle);
            try {
                this.setBaudRate(handle, linkParameters.getBaudRate().getOrdinal());
                this.setAddress(handle, linkParameters.getAddress());
                this.setMaxMaster(handle, linkParameters.getMaxMaster());
                this.setMaxInfoFrames(handle, linkParameters.getMaxInfoFrames());
                byte[] whois = new byte[]{1, 32, -1, -1, 0, -1, 16, 8};
                int destination = linkParameters.getDestinationAddress();
                int messagesToSend = 10;
                numMessagesReceived = 0;
                for (numMessagesSent = 0; numMessagesSent < messagesToSend; ++numMessagesSent) {
                    log.info("[TestCommDriver] Sending WHOIS to " + (destination & 0xFF) + ", message count = " + numMessagesSent);
                    byte[] tx = new byte[whois.length];
                    System.arraycopy(whois, 0, tx, 0, whois.length);
                    this.sendFrame(handle, (byte)(destination & 0xFF), tx, false);
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                log.info("[TestCommDriver] Number of message sent = " + numMessagesSent);
                log.info("[TestCommDriver] Number of messages received = " + numMessagesReceived);
                if (numMessagesSent == numMessagesReceived) {
                    // empty if block
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] Failed to transmit message: ", e);
            }
            try {
                log.info("[TestCommDriver] Stopping the MSTP driver on [ trunk = /dev/mstp1 | device = " + osName + " ]");
                this.stopDriver(handle);
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "[TestCommDriver] ERROR: Failed to open the MSTP port, can not test MSTP", e);
                try {
                    Property p = serialPortComponent.getProperty("owner");
                    serialPortComponent.setString(p, "none");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                log.info("[TestCommDriver] End");
                return;
            }
            log.info("[TestCommDriver] Driver closed");
            return;
        }
        finally {
            try {
                Property p = serialPortComponent.getProperty("owner");
                serialPortComponent.setString(p, "none");
            }
            catch (Exception exception) {}
            log.info("[TestCommDriver] End");
        }
    }

    static class MstpTrunkTestListener
    implements MstpListener {
        MstpTrunkTestListener() {
        }

        @Override
        public void receiveFrame(byte srcAddress, byte[] data, boolean dataExpectingReply) {
            if (data != null && data.length > 0) {
                log.info("[TestCommDriver] Received MSTP Frame: SRC " + srcAddress + " DATA " + TextUtil.bytesToHexString((byte[])data) + " DER " + dataExpectingReply);
                numMessagesReceived++;
            }
        }
    }

    private static final class TempDirectoryHolder {
        private static final String TEMP_DIRECTORY = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getTempDirPath());

        private TempDirectoryHolder() {
        }
    }
}

