/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.asn.AsnUtil;
import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.BBacnetAwsNetwork;
import com.tridium.bacnetAws.datatypes.BRestoreConfig;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.config.BBacnetFile;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.datatypes.BBacnetOctetString;
import javax.baja.bacnet.datatypes.BBacnetPropertyValue;
import javax.baja.bacnet.enums.BBacnetBackupState;
import javax.baja.bacnet.enums.BBacnetFileAccessMethod;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.bacnet.enums.BBacnetPropertyIdentifier;
import javax.baja.bacnet.enums.BBacnetReinitializedDeviceState;
import javax.baja.bacnet.io.ErrorException;
import javax.baja.bacnet.io.ErrorType;
import javax.baja.bacnet.io.PropertyValue;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.SortUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BEnum;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public class BRestoreJob
extends BDeviceManagerJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRestoreJob.class);
    private static final Logger logger = Logger.getLogger("bacnet.client.restore");
    private BBacnetAwsNetwork bacnetAws;
    private BRestoreConfig params;
    private InputStream inputStream;
    static Lexicon lex = Lexicon.make((String)"bacnetAws");
    private BackupFileComparator backupFileComparator = new BackupFileComparator();

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRestoreJob() {
    }

    public BRestoreJob(BBacnetAwsNetwork bacnet, BRestoreConfig params) {
        super((BBacnetNetwork)bacnet);
        this.bacnetAws = bacnet;
        this.params = params;
    }

    public BRestoreJob(BBacnetAwsNetwork bacnet, BRestoreConfig params, InputStream inputStream) {
        this(bacnet, params);
        this.inputStream = inputStream;
    }

    public void run(Context cx) throws Exception {
        if (this.bacnet == null) {
            throw new IllegalStateException("Must submit thru BacnetNetwork.submitDeviceManagerJob()");
        }
        if (this.params == null) {
            return;
        }
        BBacnetDevice device = this.bacnetAws.lookupDeviceById(this.params.getDeviceId());
        if (device == null) {
            throw new IllegalStateException("Could not find BBacnetDevice for device ID " + this.params.getDeviceId());
        }
        this.progress(0);
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Restoring device at " + this.params.getDeviceAddress() + "...");
        }
        String password = null;
        String pw = AccessController.doPrivileged(() -> ((BPassword)this.params.getPassword()).getValue());
        if (pw.length() > 0) {
            password = pw;
        }
        int backupFailureTimeoutOrig = -1;
        boolean resetTimeout = false;
        try {
            long waitTime;
            long waitStart;
            boolean hasBRState;
            long protRev = 0L;
            long vendorId = 0L;
            try {
                protRev = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 139));
            }
            catch (Exception e) {
                this.log().message("Protocol Revision cannot be determined: " + e);
            }
            this.progress(2);
            try {
                vendorId = AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 120));
            }
            catch (Exception e) {
                this.log().message("Vendor ID cannot be determined: " + e);
            }
            this.progress(4);
            int brState = 6;
            boolean useTridiumIds = false;
            if (protRev < 10L && vendorId == 36L) {
                useTridiumIds = true;
            }
            boolean bl = hasBRState = (brState = this.readBRProp(338, useTridiumIds, -1, 9)) >= 0;
            if (brState > 0 && brState < 5) {
                throw new IllegalStateException("Cannot restore device; BackupAndRestoreState " + BBacnetBackupState.tag((int)brState) + " is not IDLE!");
            }
            this.progress(6);
            try {
                backupFailureTimeoutOrig = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(153, false)));
                resetTimeout = true;
            }
            catch (BacnetException e) {
                this.log().message("Could not read Backup_Failure_Timeout property:" + (Object)((Object)e));
            }
            try {
                int backupFailureTimeoutNew = 90;
                this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)backupFailureTimeoutNew));
                this.log().message("Successful write to Backup_Failure_Timeout property: " + backupFailureTimeoutNew + 's');
            }
            catch (BacnetException e) {
                resetTimeout = false;
                this.log().message("Could not write Backup_Failure_Timeout property:" + (Object)((Object)e));
            }
            this.progress(10);
            long restoreCompletionTime = 60L;
            if (hasBRState) {
                restoreCompletionTime = this.readBRProp(340, useTridiumIds, 60, 2);
            }
            restoreCompletionTime *= 1000L;
            this.progress(12);
            this.log().message("Sending START_RESTORE command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.startRestore, password, this.params.getCharacterSet());
            this.progress(14);
            if (hasBRState) {
                this.log().message("Monitoring Backup_And_Restore_State...");
                brState = this.readBRProp(338, useTridiumIds, -1, 9);
                waitStart = Clock.ticks();
                waitTime = 0L;
                while (brState != 4) {
                    this.log().message("Waiting for device restore preparation to complete (" + waitTime / 1000L + " sec)...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.checkCancel(lex.getText("restore.canceled"));
                    waitTime = Clock.ticks() - waitStart;
                    brState = this.readBRProp(338, useTridiumIds, -1, 9);
                    if (brState != -1 && brState != 5) continue;
                    throw new RuntimeException("RESTORE_FAILURE received from device: unable to enter restore mode!");
                }
            }
            this.progress(20);
            if (this.inputStream != null) {
                int count = 0;
                this.progress(45);
                ZipInputStream zipInputStream = new ZipInputStream(this.inputStream);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                if (zipEntry == null) {
                    throw new RuntimeException("Zip based restore requires zip file");
                }
                while (zipEntry != null) {
                    this.checkCancel(lex.getText("restore.canceled"));
                    String fileName = SlotPath.unescape((String)zipEntry.getName());
                    FileInfo fileInfo = this.getFileInfo(fileName);
                    if (fileInfo.index != count) {
                        throw new RuntimeException("Zip based Restore requires files in original backup order 'fileName_Instance_Index': " + fileName);
                    }
                    this.log().message("Reading local file data from " + fileName);
                    ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                    FileUtil.pipe((InputStream)zipInputStream, (OutputStream)outputStream);
                    this.writeFile(device, fileInfo, outputStream.toByteArray());
                    this.progress(count, 45, 45, 90);
                    ++count;
                    zipEntry = zipInputStream.getNextEntry();
                }
            } else {
                BFileSystem fs = BFileSystem.INSTANCE;
                this.checkCancel(lex.getText("restore.canceled"));
                FilePath dirfp = BRestoreJob.toFilePath(this.params.getDirectory().normalize());
                BDirectory dir = fs.makeDir(dirfp);
                Object[] backupFiles = dir.listFiles();
                this.progress(45);
                SortUtil.sort((Object[])backupFiles, (Object[])backupFiles, (Comparator)this.backupFileComparator);
                for (int i = 0; i < backupFiles.length; ++i) {
                    this.checkCancel(lex.getText("restore.canceled"));
                    Object f = backupFiles[i];
                    this.log().message("Reading local file data from " + f.getFileName());
                    FileInfo fileInfo = this.getFileInfo(SlotPath.unescape((String)f.getFileName()));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("file #" + i + ": remote fileId=" + fileInfo.instanceNum + "; local fileName=" + f.getFileName());
                    }
                    byte[] fileData = f.read();
                    this.writeFile(device, fileInfo, fileData);
                    this.progress(i, backupFiles.length, 45, 90);
                }
            }
            if (resetTimeout) {
                this.resetBackupFailureTimeout(backupFailureTimeoutOrig);
            }
            this.log().message("Sending END_RESTORE command...");
            this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.endRestore, password, this.params.getCharacterSet());
            this.progress(95);
            if (hasBRState) {
                brState = this.readBRProp(338, useTridiumIds, -1, 9);
                waitTime = waitStart = Clock.ticks();
                while (waitTime < restoreCompletionTime && brState != 0) {
                    this.log().message("Waiting for device restore completion (" + waitTime / 1000L + " sec)...");
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException fs) {
                        // empty catch block
                    }
                    if (!this.isAlive()) {
                        throw new BajaRuntimeException(lex.getText("restore.canceled"));
                    }
                    waitTime = Clock.ticks();
                    brState = this.readBRProp(338, useTridiumIds, -1, 9);
                    if (brState != -1 && brState != 6) continue;
                    throw new RuntimeException("RESTORE_FAILURE received from device!");
                }
            }
            this.log().success("Finished Restore Procedure!");
            String msg = MessageFormat.format(lex.getText("restore.completion"), restoreCompletionTime);
            this.log().message(msg);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception restoring device: " + e, e);
            String msg = MessageFormat.format(lex.getText("restore.fail"), e);
            this.add("failureCause", (BValue)BString.make((String)e.toString()));
            this.log().failed(msg);
            try {
                this.log().message("Sending ABORT_RESTORE command...");
                this.client().reinitializeDevice(this.params.getDeviceAddress(), BBacnetReinitializedDeviceState.abortRestore, password, this.params.getCharacterSet());
            }
            catch (Exception e2) {
                logger.log(Level.INFO, "Exception occurred in sending ABORT_RESTORE command: " + e2, e2);
                this.log().failed("Exception occurred in sending ABORT_RESTORE command!");
            }
            if (resetTimeout) {
                this.resetBackupFailureTimeout(backupFailureTimeoutOrig);
            }
            throw e;
        }
    }

    private void writeFile(BBacnetDevice device, FileInfo fileInfo, byte[] fileData) throws BacnetException {
        this.log().message("Writing file data to remote file:" + fileInfo.instanceNum);
        BBacnetObjectIdentifier fileId = BBacnetObjectIdentifier.make((BBacnetObjectType)BBacnetObjectType.file, (int)fileInfo.instanceNum);
        if (fileInfo.isStreamAccess) {
            this.checkRemoteFile(fileId, fileInfo, fileData.length);
            BBacnetFile.writeFile((BBacnetDevice)device, (BBacnetObjectIdentifier)fileId, (byte[])fileData);
        } else {
            BBacnetOctetString[] fileRecordData = BBacnetFile.getFileRecordData((byte[])fileData);
            this.checkRemoteFile(fileId, fileInfo, fileRecordData.length);
            BBacnetFile.writeFile((BBacnetDevice)device, (BBacnetObjectIdentifier)fileId, (int)fileRecordData.length, (BBacnetOctetString[])fileRecordData);
        }
    }

    private void checkRemoteFile(BBacnetObjectIdentifier fileId, FileInfo fileInfo, int fileDataSize) throws BacnetException {
        int remoteFileSize;
        try {
            this.checkFileAccessMethod(fileId, fileInfo.isStreamAccess ? BBacnetFileAccessMethod.streamAccess : BBacnetFileAccessMethod.recordAccess);
        }
        catch (ErrorException e) {
            ErrorType errorType = e.getErrorType();
            if (errorType.getErrorClass() != 1 && errorType.getErrorCode() != 31) {
                throw new BacnetException("Error reading file access method of " + fileId, (Throwable)e);
            }
            this.createFileObject(fileId, fileInfo);
        }
        int n = remoteFileSize = fileInfo.isStreamAccess ? this.readUnsigned(fileId, BBacnetPropertyIdentifier.fileSize) : this.readUnsigned(fileId, BBacnetPropertyIdentifier.recordCount);
        if (remoteFileSize != fileDataSize) {
            if (fileInfo.isStreamAccess) {
                this.writeUnsigned(fileId, BBacnetPropertyIdentifier.fileSize, 0);
            } else {
                this.writeUnsigned(fileId, BBacnetPropertyIdentifier.recordCount, 0);
            }
        }
    }

    private void checkFileAccessMethod(BBacnetObjectIdentifier fileId, BBacnetFileAccessMethod localAccessMethod) throws BacnetException {
        BBacnetFileAccessMethod remoteAccessMethod = this.readFileAccessMethod(fileId);
        if (!remoteAccessMethod.equals((Object)localAccessMethod)) {
            throw new IllegalStateException("Remote file access method \"" + remoteAccessMethod + '\"' + " does not match local method \"" + localAccessMethod + '\"' + "; fileId: " + fileId);
        }
    }

    private void createFileObject(BBacnetObjectIdentifier fileId, FileInfo fileInfo) throws BacnetException {
        this.log().message("File object not found, sending create object request " + fileId);
        Array initialValues = new Array(PropertyValue.class);
        initialValues.add((Object)new BBacnetPropertyValue(77, (BSimple)BString.make((String)fileInfo.name)));
        initialValues.add((Object)new BBacnetPropertyValue(41, (BSimple)(fileInfo.isStreamAccess ? BBacnetFileAccessMethod.streamAccess : BBacnetFileAccessMethod.recordAccess)));
        this.client().createObject(this.params.getDeviceAddress(), fileId, initialValues);
    }

    private BBacnetFileAccessMethod readFileAccessMethod(BBacnetObjectIdentifier objectId) throws BacnetException {
        return (BBacnetFileAccessMethod)AsnUtil.fromAsnEnumerated((BEnum)BBacnetFileAccessMethod.DEFAULT, (byte[])this.client().readProperty(this.params.getDeviceAddress(), objectId, 41));
    }

    private int readUnsigned(BBacnetObjectIdentifier objectId, BBacnetPropertyIdentifier propertyId) throws BacnetException {
        return AsnUtil.fromAsnUnsignedInt((byte[])this.client().readProperty(this.params.getDeviceAddress(), objectId, propertyId.getOrdinal()));
    }

    private void writeUnsigned(BBacnetObjectIdentifier objectId, BBacnetPropertyIdentifier propertyId, int value) throws BacnetException {
        this.client().writeProperty(this.params.getDeviceAddress(), objectId, propertyId.getOrdinal(), AsnUtil.toAsnUnsigned((long)value));
    }

    private void resetBackupFailureTimeout(int backupFailureTimeoutOrig) {
        try {
            this.client().writeProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), 153, AsnUtil.toAsnUnsigned((long)backupFailureTimeoutOrig));
            this.log().message("Successful reset of Backup_Failure_Timeout property to " + backupFailureTimeoutOrig + 's');
        }
        catch (Exception e) {
            this.log().message("Failed to reset Backup_Failure_Timeout property to " + backupFailureTimeoutOrig + "s: " + e);
        }
    }

    public static FilePath toFilePath(BOrd ord) {
        OrdQuery[] q = ord.parse();
        for (int i = 0; i < q.length; ++i) {
            if (!(q[i] instanceof FilePath)) continue;
            return (FilePath)q[i];
        }
        throw new IllegalStateException();
    }

    private int readBRProp(int propId, boolean useTridium, int defValue, int asnType) {
        String propName = BBacnetPropertyIdentifier.tag((int)propId);
        if (useTridium) {
            propName = propName + " (Niagara)";
        }
        int ret = defValue;
        try {
            switch (asnType) {
                case 2: {
                    ret = (int)AsnUtil.fromAsnUnsignedInteger((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(propId, useTridium)));
                    break;
                }
                case 9: {
                    ret = AsnUtil.fromAsnEnumerated((byte[])this.client().readProperty(this.params.getDeviceAddress(), this.params.getDeviceId(), this.propId(propId, useTridium)));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid asnType supplied to readBRProp:" + asnType);
                }
            }
        }
        catch (Exception e) {
            this.log().message("Error reading " + propName + ":" + e);
        }
        return ret;
    }

    private int propId(int basePropId, boolean useTridium) {
        return useTridium ? basePropId + 1000 : basePropId;
    }

    private FileInfo getFileInfo(String fileName) {
        int instanceNum;
        boolean isStreamAccess;
        String[] split = fileName.split("_");
        if (split.length < 3) {
            throw new IllegalArgumentException("invalid backup file for comparison:" + fileName);
        }
        String instanceNumElem = split[split.length - 2];
        if (instanceNumElem.contains("s")) {
            isStreamAccess = true;
            instanceNum = BRestoreJob.parseInstanceNum(instanceNumElem);
        } else if (instanceNumElem.contains("r")) {
            isStreamAccess = false;
            instanceNum = BRestoreJob.parseInstanceNum(instanceNumElem);
        } else {
            isStreamAccess = true;
            instanceNum = Integer.parseInt(instanceNumElem);
        }
        String indexElem = split[split.length - 1];
        int index = Integer.parseInt(indexElem);
        String name = fileName.substring(0, fileName.length() - indexElem.length() - instanceNumElem.length() - 2);
        return new FileInfo(name, instanceNum, index, isStreamAccess);
    }

    private static int parseInstanceNum(String instanceNumElem) {
        return Integer.parseInt(instanceNumElem.substring(0, instanceNumElem.length() - 1));
    }

    class BackupFileComparator
    implements Comparator<Object> {
        BackupFileComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof BIFile)) {
                throw new ClassCastException("BackupFileComparator only compares BIFiles");
            }
            if (!(o2 instanceof BIFile)) {
                throw new ClassCastException("BackupFileComparator only compares BIFiles");
            }
            try {
                BIFile f1 = (BIFile)o1;
                BIFile f2 = (BIFile)o2;
                StringTokenizer st = new StringTokenizer(f1.getFileName(), "_");
                int tokens = st.countTokens();
                if (tokens < 3) {
                    throw new IllegalArgumentException("invalid backup file for comparison:" + f1.getFileName());
                }
                for (int i = 0; i < tokens - 1; ++i) {
                    st.nextToken();
                }
                int order1 = Integer.parseInt(st.nextToken());
                st = new StringTokenizer(f2.getFileName(), "_");
                tokens = st.countTokens();
                if (tokens < 3) {
                    throw new IllegalArgumentException("invalid backup file for comparison:" + f2.getFileName());
                }
                for (int i = 0; i < tokens - 1; ++i) {
                    st.nextToken();
                }
                int order2 = Integer.parseInt(st.nextToken());
                return order1 - order2;
            }
            catch (Exception e) {
                throw new ClassCastException("BackupFileComparator cannot compare:" + e.toString());
            }
        }
    }

    private static class FileInfo {
        public final String name;
        public final int instanceNum;
        public final int index;
        public final boolean isStreamAccess;

        public FileInfo(String name, int instanceNum, int index, boolean isStreamAccess) {
            this.name = name;
            this.instanceNum = instanceNum;
            this.index = index;
            this.isStreamAccess = isStreamAccess;
        }
    }
}

