/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnetAws.job;

import com.tridium.bacnet.job.BDeviceManagerJob;
import com.tridium.bacnetAws.datatypes.BCreateObjectParameters;
import com.tridium.driver.util.StringUtil;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bacnet.BBacnetNetwork;
import javax.baja.bacnet.BBacnetObject;
import javax.baja.bacnet.BacnetException;
import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BBacnetCreateObjectJob
extends BDeviceManagerJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetCreateObjectJob.class);
    BCreateObjectParameters params;
    BBacnetDevice dev;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetCreateObjectJob() {
    }

    public BBacnetCreateObjectJob(BBacnetDevice d, BCreateObjectParameters p) {
        super((BBacnetNetwork)d.getNetwork());
        this.dev = d;
        this.params = p;
    }

    public void run(Context cx) throws Exception {
        BBacnetObjectIdentifier[] oids = (BBacnetObjectIdentifier[])StringUtil.getSimpleArray((String)this.params.getObjectIds(), (BSimple)BBacnetObjectIdentifier.DEFAULT);
        String[] names = StringUtil.getStringArray((String)this.params.getNames());
        BComponent parent = (BComponent)this.params.getParentOrd().get();
        for (int i = 0; i < oids.length; ++i) {
            String name = names[i];
            try {
                BBacnetObjectIdentifier oid = oids[i];
                BBacnetObjectIdentifier returned = null;
                returned = oid.getInstanceNumber() < 0 ? this.bacnet.getBacnetComm().createObject(this.dev.getAddress(), oid.getObjectType(), null) : this.bacnet.getBacnetComm().createObject(this.dev.getAddress(), oid, null);
                if (returned == null || returned.getInstanceNumber() <= 0) continue;
                BBacnetObject bo = BBacnetObject.make((BBacnetObjectIdentifier)returned);
                bo.setObjectName(name);
                if (bo.getObjectId().getInstanceNumber() < 0) {
                    throw new BacnetException("Duplicate Object Id");
                }
                parent.add(name, (BValue)bo);
                this.log().message("Created " + name);
                continue;
            }
            catch (BacnetException e) {
                this.log().failed("Error creating " + name, (Throwable)e);
            }
        }
    }
}

