/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ddfSerial.comm;

import com.tridium.ddf.BDdfCommDevice;
import com.tridium.ddf.BDdfCommNetwork;
import com.tridium.ddf.comm.BIDdfCommunicating;
import com.tridium.ddf.comm.defaultComm.BDdfCommunicator;
import com.tridium.ddfSerial.BDdfSerialNetwork;
import com.tridium.ddfSerial.comm.BDdfSerialNullReceiver;
import com.tridium.ddfSerial.comm.BDdfSerialTransmitter;
import com.tridium.ddfSerial.comm.DdfSerialDriverCommLexicon;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.log.Log;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BISerialHelperParent;
import javax.baja.serial.BISerialPort;
import javax.baja.serial.BISerialService;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="serialPortParameters", type="BSerialHelper", defaultValue="new BSerialHelper()"), @NiagaraProperty(name="transmitter", type="BDdfTransmitter", defaultValue="new BDdfSerialTransmitter()", override=true), @NiagaraProperty(name="receiver", type="BDdfReceiver", defaultValue="new BDdfSerialNullReceiver()", override=true)})
public class BDdfSerialCommunicator
extends BDdfCommunicator
implements BISerialHelperParent {
    @Generated
    public static final Property serialPortParameters = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BSerialHelper(), null);
    @Generated
    public static final Property transmitter = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BDdfSerialTransmitter(), null);
    @Generated
    public static final Property receiver = BDdfSerialCommunicator.newProperty((int)0, (BValue)new BDdfSerialNullReceiver(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDdfSerialCommunicator.class);
    public static final int DEFAULT_SERIAL_RX_BUFFER_SIZE = 4096;
    protected BISerialPort serialPort = null;
    protected InputStream serialIn = null;
    protected OutputStream serialOut = null;
    private String portName = null;

    @Generated
    public BSerialHelper getSerialPortParameters() {
        return (BSerialHelper)this.get(serialPortParameters);
    }

    @Generated
    public void setSerialPortParameters(BSerialHelper v) {
        this.set(serialPortParameters, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BDdfSerialCommunicator() {
        this.getSerialPortParameters().setPortName("COM1");
    }

    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BDdfSerialNetwork;
    }

    public void descendantsStarted() throws Exception {
        this.portName = this.getSerialPortParameters().getPortName();
        super.descendantsStarted();
    }

    public void reopenPort() {
        BIDdfCommunicating commParent = this.getDdfCommunicatingParent();
        if (commParent instanceof BDdfCommNetwork) {
            ((BDdfCommNetwork)commParent).setEnabled(false);
        } else if (commParent instanceof BDdfCommDevice) {
            ((BDdfCommDevice)commParent).setEnabled(false);
        }
        this.stopCommunicating();
        this.closeSerialPort();
        try {
            this.openSerialPort();
            this.startCommunicating();
            this.updatePortSettings();
            if (commParent instanceof BDdfCommNetwork) {
                ((BDdfCommNetwork)commParent).setEnabled(true);
            } else if (commParent instanceof BDdfCommDevice) {
                ((BDdfCommDevice)commParent).setEnabled(true);
            }
        }
        catch (Exception e) {
            this.getLog().error(DdfSerialDriverCommLexicon.reopenPortException(e));
            this.closeSerialPort();
        }
    }

    public final void communicatorStarted() throws Exception {
        try {
            this.openSerialPort();
            this.serialCommunicatorStarted();
        }
        catch (Exception e) {
            this.handleOpenSerialPortException(e);
            throw e;
        }
    }

    public final void communicatorStopped() throws Exception {
        this.closeSerialPort();
        this.serialCommunicatorStopped();
    }

    public Log getLog() {
        return Log.getLog((String)(this.getParent().getName() + '_' + this.portName));
    }

    public BDdfSerialNetwork getDdfSerialNetwork() {
        return (BDdfSerialNetwork)this.getParent();
    }

    public InputStream getSerialInputStream() {
        return this.serialIn;
    }

    public OutputStream getSerialOutputStream() {
        return this.serialOut;
    }

    protected void serialCommunicatorStarted() {
    }

    protected void serialCommunicatorStopped() {
    }

    private void _configFail(BComplex commParent, String reason) {
        if (commParent instanceof BDevice) {
            ((BDevice)commParent).configFail(reason);
        } else if (commParent instanceof BDeviceNetwork) {
            ((BDeviceNetwork)commParent).configFail(reason);
        } else {
            this.getLog().error(reason);
        }
    }

    private void _configOk(BComplex commParent) {
        if (commParent instanceof BDevice) {
            ((BDevice)commParent).configOk();
        } else if (commParent instanceof BDeviceNetwork) {
            ((BDeviceNetwork)commParent).configOk();
        } else {
            this.getLog().message(DdfSerialDriverCommLexicon.LEX.getText("OpenSerialPortSuccess"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openSerialPort() throws Exception {
        block11: {
            BComplex commParent;
            for (commParent = this.getParent(); commParent != null && !(commParent instanceof BIDdfCommunicating); commParent = commParent.getParent()) {
            }
            if (commParent == null) {
                this.getLog().error(DdfSerialDriverCommLexicon.LEX.getText("SerialCommunicatorNotUnderBIDdfCommunicating", new Object[]{this.getSlotPath()}));
            } else if (this.getSerialPortParameters().getPortName().equals("none")) {
                this._configFail(commParent, DdfSerialDriverCommLexicon.noPortSelected);
            } else {
                try {
                    BISerialService platSvc = (BISerialService)Sys.getService((Type)BISerialService.TYPE);
                    this.serialPort = this.getSerialPortParameters().open(commParent.getName());
                    this.serialPort.enableReceiveTimeout(platSvc.getMinTimeout());
                    this.serialIn = new BufferedInputStream(this.serialPort.getInputStream(), this.getSerialRxBufferSize());
                    this.serialOut = this.serialPort.getOutputStream();
                    for (BComplex navParent = this.getParent(); navParent != null && !(navParent instanceof BIDdfCommunicating); navParent = navParent.getParent()) {
                    }
                    this._configOk(commParent);
                }
                catch (Exception e) {
                    this._configFail(commParent, DdfSerialDriverCommLexicon.errorOpeningSerialPort(e));
                    this.serialIn = null;
                    this.serialOut = null;
                    if (this.serialPort == null) break block11;
                    try {
                        this.serialPort.close();
                    }
                    finally {
                        this.serialPort = null;
                    }
                }
            }
        }
    }

    protected int getSerialRxBufferSize() {
        return 4096;
    }

    protected void handleOpenSerialPortException(Exception e) {
        this.getLog().error(DdfSerialDriverCommLexicon.errorOpeningSerialPort(e));
        this.closeSerialPort();
    }

    protected void closeSerialInputStream() {
        if (this.serialIn != null) {
            try {
                this.serialIn.close();
            }
            catch (Exception x) {
                this.getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialInputStream, (Throwable)x);
            }
        }
    }

    protected void closeSerialOutputStream() {
        if (this.serialOut != null) {
            try {
                this.serialOut.close();
            }
            catch (Exception x) {
                this.getLog().error(DdfSerialDriverCommLexicon.unableToCloseSerialOutputStream, (Throwable)x);
            }
        }
    }

    protected void closeSerialPort() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        this.serialPort = null;
        this.serialIn = null;
        this.serialOut = null;
    }

    private void updatePortSettings() {
        String newPortName = this.getSerialPortParameters().getPortName();
        if (this.portName != null) {
            int previousLogSeverity;
            int newLogSeverity;
            Log newerLog;
            Log previousLog;
            String previousPortName = this.portName;
            if (!previousPortName.equals(newPortName) && (previousLog = Log.getLog((String)(this.getParent().getName() + '_' + previousPortName))) != null && (newerLog = Log.getLog((String)(this.getParent().getName() + '_' + newPortName))) != null && (newLogSeverity = newerLog.getSeverity()) > (previousLogSeverity = previousLog.getSeverity())) {
                newerLog.setSeverity(previousLog.getSeverity());
            }
            this.portName = newPortName;
        }
    }
}

