/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.velocity;

import com.tridium.velocity.BVelocityDoc;
import com.tridium.velocity.BVelocityDocView;
import com.tridium.web.WebUtil;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.ViewQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.util.Lexicon;
import javax.baja.web.BWebServlet;
import javax.baja.web.WebOp;
import javax.servlet.http.HttpServletRequest;

@NiagaraType
@NiagaraProperty(name="servletName", type="String", defaultValue="velocity", override=true)
public final class BVelocityServlet
extends BWebServlet {
    @Generated
    public static final Property servletName = BVelocityServlet.newProperty((int)0, (String)"velocity", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BVelocityServlet.class);
    private static final BIcon icon = BIcon.std((String)"web.png");
    private static final String viewQueryParamsRegExp = "view\\:[^?]*\\?(.*)$";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return icon;
    }

    public final void doGet(WebOp op) throws Exception {
        this.checkVelocityLicense(op);
        String uri = this.getQueryPath(op);
        if (!this.isServletRequest(uri)) {
            this.handleNonServletRequest(op, op.getRequest(), uri);
        } else {
            BVelocityDoc doc = this.getServletDocWithPermission(op);
            if (doc != null) {
                BVelocityDocView.INSTANCE.doGet(new BVelocityDocView.DocWebOp(op, doc));
            }
        }
    }

    public final void doPost(WebOp op) throws Exception {
        this.checkVelocityLicense(op);
        String uri = this.getQueryPath(op);
        if (!this.isServletRequest(uri)) {
            this.handleNonServletRequest(op, op.getRequest(), uri);
        } else {
            BVelocityDoc doc = this.getServletDocWithPermission(op);
            if (doc != null) {
                BVelocityDocView.INSTANCE.doPost(new BVelocityDocView.DocWebOp(op, doc));
            }
        }
    }

    private String getQueryPath(WebOp op) {
        HttpServletRequest req = op.getRequest();
        String path = req.getRequestURI();
        String queryStr = req.getQueryString();
        String uri = path;
        if (queryStr != null && queryStr.length() > 0) {
            uri = uri + "?" + queryStr;
        }
        return uri;
    }

    private void handleNonServletRequest(WebOp op, HttpServletRequest req, String uri) throws IOException {
        BVelocityDoc doc = null;
        ViewQuery viewQuery = op.getViewQuery();
        if (viewQuery != null && viewQuery.getViewId() != null) {
            BValue value = this.get(viewQuery.getViewId());
            if (value != null && value instanceof BVelocityDoc) {
                doc = (BVelocityDoc)value;
            } else {
                op.getResponse().sendError(404);
                return;
            }
        }
        if (doc == null) {
            doc = this.getFirstDocumentWithUserPermission(op);
        }
        if (doc == null) {
            op.getResponse().sendError(404);
        } else {
            this.redirectToDocument(op, req, uri, doc);
        }
    }

    private void redirectToDocument(WebOp op, HttpServletRequest req, String uri, BVelocityDoc doc) throws IOException {
        String newQueryStr = "";
        Pattern viewQueryParamsPattern = Pattern.compile(viewQueryParamsRegExp);
        Matcher matcher = viewQueryParamsPattern.matcher(uri);
        if (matcher.find()) {
            newQueryStr = "?" + matcher.group(1).replace(';', '&');
        }
        String redirect = WebUtil.getRedirect((HttpServletRequest)req, (String)("/velocity/" + doc.getName() + newQueryStr));
        op.getResponse().sendRedirect(redirect);
    }

    private BVelocityDoc getFirstDocumentWithUserPermission(WebOp op) {
        SlotCursor cursor = this.getSlots();
        BUser user = op.getUser();
        while (cursor.next(BVelocityDoc.class)) {
            BVelocityDoc document = (BVelocityDoc)cursor.get();
            BPermissions permissions = user.getPermissionsFor((BIProtected)document);
            if (!permissions.has(1)) continue;
            return document;
        }
        return null;
    }

    private boolean isServletRequest(String uri) {
        return uri.indexOf(this.getServletName() + "/") == 1;
    }

    private BVelocityDoc getServletDocWithPermission(WebOp op) throws IOException {
        String pathInfo = op.getPathInfo();
        String docName = null;
        if (pathInfo.length() < 2 || pathInfo.charAt(0) != '/') {
            op.getResponse().sendError(404);
            return null;
        }
        int secondSlash = pathInfo.indexOf(47, 1);
        docName = secondSlash == -1 ? pathInfo.substring(1) : pathInfo.substring(1, secondSlash);
        BVelocityDoc doc = (BVelocityDoc)this.get(docName);
        if (doc == null) {
            op.getResponse().sendError(404);
            return null;
        }
        BUser user = op.getUser();
        BPermissions permissions = user.getPermissionsFor((BIProtected)doc);
        if (!permissions.has(1)) {
            op.getResponse().sendError(403);
            return null;
        }
        return doc;
    }

    private void checkVelocityLicense(WebOp op) throws LocalizableException {
        try {
            Sys.getLicenseManager().checkFeature("tridium", "axvelocity");
        }
        catch (FeatureNotLicensedException e) {
            throw new LocalizableException(Lexicon.make((String)"axvelocity", (Context)op), "notLicensed");
        }
    }
}

