/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nss.dashboard;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.PermissionException;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BIObject;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.baja.user.BUserService;
import javax.baja.util.LexiconModule;

@NiagaraType(agent={@AgentOn(types={"nss:SecurityService"})})
public class BFileSystemSecurityDashboardItemProviderAgent
extends BObject
implements BISecurityDashboardProviderAgent {
    @Generated
    public static final Type TYPE = Sys.loadType(BFileSystemSecurityDashboardItemProviderAgent.class);
    private final SecurityDashboardItemBuilder builder = new SecurityDashboardItemBuilder((BIObject)this);
    private static final List<String> SENSITIVE_EXTENSIONS = Arrays.asList("css", "htm", "html", "js", "nav", "px", "pxvm", "vm");
    private static final int MAX_FILES_TO_SCAN = AccessController.doPrivileged(() -> Integer.getInteger("niagara.securityService.fileSystem.maxFilesToScan", 500));
    private static final LexiconModule LEX = LexiconModule.make((Type)TYPE);
    private static final String HEADER = "securityDashboard.fileSystem.header";
    private static final String SENSITIVE_ACCESS_FILE_COUNT = "securityDashboard.fileSystem.sensitiveAccess.scannedFileCount";
    private static final String SENSITIVE_ACCESS_SOME_SUMMARY = "securityDashboard.fileSystem.sensitiveAccess.some.summary";
    private static final String SENSITIVE_ACCESS_NONE_SUMMARY = "securityDashboard.fileSystem.sensitiveAccess.none.summary";
    private static final String SENSITIVE_ACCESS_DESCRIPTION = "securityDashboard.fileSystem.sensitiveAccess.description";

    @Generated
    public Type getType() {
        return TYPE;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)HEADER);
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return null;
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        SensitiveFileVisitor visitor = this.scanUsers();
        List sensitiveUsers = visitor.writableUsers;
        String countMessage = visitor.hitFileScanLimit ? LEX.getText(SENSITIVE_ACCESS_FILE_COUNT, cx, new Object[]{visitor.filesScanned}) : "";
        String summary = sensitiveUsers.isEmpty() ? SENSITIVE_ACCESS_NONE_SUMMARY : SENSITIVE_ACCESS_SOME_SUMMARY;
        return Collections.singletonList(this.builder.makeInfo().withSummary(summary, new Object[]{String.join((CharSequence)", ", sensitiveUsers), countMessage}).withDescription(SENSITIVE_ACCESS_DESCRIPTION, new Object[]{String.join((CharSequence)", ", SENSITIVE_EXTENSIONS)}));
    }

    protected SensitiveFileVisitor scanUsers() {
        return new SensitiveFileVisitor(this.getUsersToScan(), (BIFile)this.getRootDirectory());
    }

    protected List<BUser> getUsersToScan() {
        BUserService userService = (BUserService)Sys.getService((Type)BUserService.TYPE);
        return Arrays.asList(userService.getUsers());
    }

    protected BDirectory getRootDirectory() {
        return BFileSystem.INSTANCE.getStationHome();
    }

    protected int getMaxFilesToScan() {
        return MAX_FILES_TO_SCAN;
    }

    public static boolean canWrite(BIFile file, Context cx) {
        try {
            file.getFileSpace().checkWritePermission(file.getFilePath(), cx);
            return true;
        }
        catch (PermissionException e) {
            return false;
        }
    }

    public static boolean isSensitiveFile(BIFile file) {
        if (file == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String extension = file.getExtension();
        if (extension == null) {
            return false;
        }
        return SENSITIVE_EXTENSIONS.contains(extension.toLowerCase(Locale.ENGLISH));
    }

    private final class SensitiveFileVisitor {
        private final List<BUser> users;
        private final List<String> writableUsers = new ArrayList<String>();
        private int filesScanned;
        private boolean hitFileScanLimit;

        private SensitiveFileVisitor(List<BUser> users, BIFile file) {
            this.users = new ArrayList<BUser>(users);
            this.visit(file);
        }

        private void visit(BIFile file) {
            if (file == null || this.hitFileScanLimit || this.users.isEmpty()) {
                return;
            }
            if (BFileSystemSecurityDashboardItemProviderAgent.isSensitiveFile(file)) {
                Iterator<BUser> it = this.users.iterator();
                while (it.hasNext()) {
                    BUser user = it.next();
                    if (!BFileSystemSecurityDashboardItemProviderAgent.canWrite(file, (Context)user)) continue;
                    this.writableUsers.add(user.getUsername());
                    it.remove();
                }
            }
            if (this.filesScanned == BFileSystemSecurityDashboardItemProviderAgent.this.getMaxFilesToScan()) {
                this.hitFileScanLimit = true;
            } else {
                ++this.filesScanned;
            }
            if (file.isDirectory()) {
                for (BIFile kid : ((BIDirectory)file).listFiles()) {
                    this.visit(kid);
                }
            }
        }
    }
}

