/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import com.tridium.platcrypto.signing.GetSigningResult;
import java.util.concurrent.TimeUnit;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.Context;

class SubmitRenewalCsr
extends BaseSigningRequesterTask {
    private final NPKCS10CertificationRequest csr;

    public SubmitRenewalCsr(BAbstractSigningRequester requester, NPKCS10CertificationRequest csr, Context cx) {
        super(requester, cx);
        this.csr = csr;
    }

    @Override
    public void execute() throws Exception {
        BAbstractSigningRequester requester = this.getSigningRequester();
        try {
            requester.submitCertificateSigningRequest(this.csr, true, this.getContext());
            requester.setRequesterState(BRequesterState.renewalCsrSubmitted);
            this.scheduleNextTask(new GetSigningResult(requester, true, this.getContext()), requester.getSigningCheckCheckRetryDelay(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            requester.setRequesterState(BRequesterState.renewalFailed);
            requester.scheduleRenewalCheck(BAbsTime.now().add(requester.getRetryPeriod()));
            throw e;
        }
    }
}

