/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.cert.CertificateKeyAlgorithm;
import com.tridium.crypto.core.cert.CertificateParseException;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NEcdsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NGeneralName;
import com.tridium.crypto.core.cert.NKeyPairGenerator;
import com.tridium.crypto.core.cert.NRsaKeyPairGenerator;
import com.tridium.crypto.core.cert.NX509CertificateBuilder;
import com.tridium.crypto.core.cert.ext.NSubjectAlternativeName;
import com.tridium.crypto.core.cert.ext.NX509Extension;
import com.tridium.platcrypto.signing.BCertificateDnFieldParameter;
import com.tridium.platcrypto.signing.BCertificateExtensionParameter;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.CertificateParameterType;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.security.IX509Extension;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import org.bouncycastle.asn1.x500.X500Name;

public final class ParameterSet
extends LinkedHashSet<BCertificateParameter> {
    public static final String DEFAULT_CURVE_SPEC = "secp256r1";
    private static final int DEFAULT_MIN_KEY_SIZE = 2048;
    private static final int DEFAULT_CERT_DAYS = 365;
    private static final KeyPurpose DEFAULT_KEY_PURPOSE = KeyPurpose.CLIENT_CERT;

    public IX509CertificateEntry toCertificateEntry() throws Exception {
        KeyPurpose keyPurpose = this.extractKeyPurpose();
        String dn = this.extractDN();
        BAbsTime now = BAbsTime.now();
        BAbsTime expiry = BAbsTime.now().add(BRelTime.makeDays((int)365));
        NX509CertificateBuilder builder = NX509CertificateBuilder.getInstance((KeyPurpose)keyPurpose).withSubjectDN(dn).withNotBefore(new Date(now.getMillis())).withNotAfter(new Date(expiry.getMillis()));
        this.addCertificateExtensions(builder, keyPurpose);
        CertificateKeyAlgorithm algorithm = this.extractKeyAlgorithm();
        if (algorithm == CertificateKeyAlgorithm.EC) {
            String curveSpec = this.extractCurveSpec();
            return builder.generateEntry((NKeyPairGenerator)new NEcdsaKeyPairGenerator(curveSpec));
        }
        int keySize = this.extractKeySize();
        return builder.generateEntry((NKeyPairGenerator)new NRsaKeyPairGenerator(keySize));
    }

    private void addCertificateExtensions(NX509CertificateBuilder builder, KeyPurpose keyPurpose) throws CertificateParseException, IOException {
        Collection<BCertificateExtensionParameter> extParams = this.extractExtensionParams();
        NSubjectAlternativeName subjectAltNameExt = null;
        for (BCertificateExtensionParameter extParam : extParams) {
            IX509Extension extension = NX509Extension.decodeFromString((String)extParam.getValue().toString());
            if (extension instanceof NSubjectAlternativeName) {
                subjectAltNameExt = subjectAltNameExt == null ? (NSubjectAlternativeName)extension : subjectAltNameExt.merge((NSubjectAlternativeName)extension);
                extension = subjectAltNameExt;
            }
            builder.withExtension(extension);
        }
        if (subjectAltNameExt == null && keyPurpose == KeyPurpose.SERVER_CERT) {
            this.addDefaultSanExtension(builder);
        }
    }

    private void addDefaultSanExtension(NX509CertificateBuilder builder) throws IOException {
        String cn = this.extractCN();
        if (cn == null || cn.isEmpty()) {
            cn = "Niagara4";
        }
        builder.withExtension((IX509Extension)NSubjectAlternativeName.make((boolean)false, (NGeneralName[])new NGeneralName[]{NGeneralName.makeDnsName((String)cn)}));
    }

    private CertificateKeyAlgorithm extractKeyAlgorithm() {
        Optional<BString> extractedKeyType = this.extractParameter(CertificateParameterType.KEY_TYPE);
        BString keyType = extractedKeyType.orElse(BString.make((String)CertificateKeyAlgorithm.RSA.toString()));
        return CertificateKeyAlgorithm.valueOf((String)keyType.getString());
    }

    private int extractKeySize() {
        Optional<BInteger> extractedMinKeySize;
        Optional<BInteger> extractedKeySize = this.extractParameter(CertificateParameterType.KEY_SIZE);
        int keySize = extractedKeySize.orElse((extractedMinKeySize = this.extractParameter(CertificateParameterType.MIN_KEY_SIZE)).orElse(BInteger.make((int)2048))).getInt();
        if (keySize < 2048) {
            throw new IllegalArgumentException("Key Size parameter below minimum value: 2048");
        }
        return keySize;
    }

    private KeyPurpose extractKeyPurpose() {
        Optional<BInteger> extractedKeyPurpose = this.extractParameter(CertificateParameterType.KEY_PURPOSE);
        return extractedKeyPurpose.map(kp -> KeyPurpose.values()[kp.getInt()]).orElse(null);
    }

    private String extractDN() {
        Optional dnParam = this.extractParameter(CertificateParameterType.DN);
        String dn = dnParam.isPresent() ? ((BString)dnParam.get()).getString() : "";
        String dnFields = this.stream().filter(param -> param instanceof BCertificateDnFieldParameter).map(param -> ((BCertificateDnFieldParameter)param.as(BCertificateDnFieldParameter.class)).getDnField().toUpperCase() + '=' + param.getValue().toString()).collect(Collectors.joining(","));
        if (dnFields.isEmpty() && dn.isEmpty()) {
            throw new IllegalArgumentException("No DN parameters defined");
        }
        if (!(dnFields.isEmpty() || dn.isEmpty() || dn.endsWith(","))) {
            dn = dn + ",";
        }
        String fullDn = dn + dnFields;
        return new X500Name(fullDn).toString();
    }

    private String extractCN() {
        return this.stream().filter(param -> param.maySupplyCommonName()).map(param -> param.supplyCommonName()).filter(cn -> cn != null).findFirst().orElse(null);
    }

    private String extractCurveSpec() {
        Optional<BString> spec = this.extractParameter(CertificateParameterType.EC_CURVE);
        BString curveSpec = spec.orElse(BString.make((String)DEFAULT_CURVE_SPEC));
        return curveSpec.getString();
    }

    private Collection<BCertificateExtensionParameter> extractExtensionParams() {
        return this.stream().filter(param -> param instanceof BCertificateExtensionParameter).map(param -> (BCertificateExtensionParameter)param.as(BCertificateExtensionParameter.class)).filter(param -> param.hasJsonExtValue()).collect(Collectors.toList());
    }

    private <T> Optional<T> extractParameter(CertificateParameterType paramType) {
        return this.stream().filter(param -> param.getParameterType().equals(paramType.name())).map(param -> param.getValue()).findFirst();
    }

    @Override
    public boolean add(BCertificateParameter parameter) {
        if (!this.contains(parameter)) {
            return super.add(parameter);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof BCertificateParameter) {
            BCertificateParameter other = (BCertificateParameter)o;
            return this.stream().anyMatch(param -> param.equivalent(other));
        }
        return false;
    }
}

