/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.signing;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NPKCS10CertificationRequest;
import com.tridium.platcrypto.signing.BAbstractSigningRequester;
import com.tridium.platcrypto.signing.BCertificateParameter;
import com.tridium.platcrypto.signing.BRequesterState;
import com.tridium.platcrypto.signing.BaseSigningRequesterTask;
import com.tridium.platcrypto.signing.GetSigningResult;
import com.tridium.platcrypto.signing.IRequesterComponent;
import com.tridium.platcrypto.signing.ParameterSet;
import java.security.AccessController;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;

class GenerateCertificateAndSubmitCsr
extends BaseSigningRequesterTask {
    public GenerateCertificateAndSubmitCsr(BAbstractSigningRequester requester, Context cx) {
        super(requester, cx);
    }

    @Override
    public boolean isOnboardingTaskOnly() {
        return true;
    }

    @Override
    public void execute() throws Exception {
        BAbstractSigningRequester requester = this.getSigningRequester();
        try {
            BCertificateParameter[] requesterParams;
            Optional<X509Certificate> cert;
            IRequesterComponent requesterComponent = requester.getRequesterComponent();
            X509Certificate certificate = null;
            PrivateKey privateKey = null;
            if (requesterComponent.allowExistingCertReplacement() && (cert = requester.getCertificate(true)).isPresent()) {
                certificate = cert.get();
                privateKey = requester.getPrivateKey(true);
            }
            BAbstractSigningRequester.LOG.finest("GenerateCertificateAndSubmitCsr requires csr template? " + requester.getRequesterComponent().requiresCertificateParameterTemplates());
            ParameterSet mergedParams = new ParameterSet();
            if (requesterComponent.requiresCertificateParameterTemplates()) {
                mergedParams.addAll(Arrays.asList(requester.getCertificateParameterTemplates()));
            }
            if ((requesterParams = requesterComponent.getCertificateParameters()) != null) {
                mergedParams.addAll(Arrays.asList(requesterParams));
            }
            Context cx = this.getContext();
            ArrayList<BCertificateParameter> parameterList = new ArrayList<BCertificateParameter>(mergedParams);
            Collections.sort(parameterList);
            parameterList.forEach(param -> param.resolve(requesterComponent, cx));
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINEST)) {
                parameterList.forEach(certParam -> BAbstractSigningRequester.LOG.finest(String.format("Certificate Parameter: %s/%s", certParam.getParameterType(), certParam.getValue())));
            }
            IX509CertificateEntry certificateEntry = mergedParams.toCertificateEntry();
            X509Certificate certWithAdditionalExtsToMerge = null;
            if (certificate == null) {
                privateKey = certificateEntry.getPrivateKey();
                certificate = certificateEntry.getCertificates()[0];
            } else {
                certWithAdditionalExtsToMerge = certificateEntry.getCertificates()[0];
            }
            X509Certificate cert2 = certificate;
            PrivateKey pk = privateKey;
            AccessController.doPrivileged(() -> {
                requester.storeUnsignedCertificate(pk, new X509Certificate[]{cert2});
                return null;
            });
            NPKCS10CertificationRequest csr = CertUtils.generateCSR((X509Certificate)cert2, (PrivateKey)pk, (X509Certificate)certWithAdditionalExtsToMerge);
            requester.submitCertificateSigningRequest(csr, false, this.getContext());
            requester.setRequesterState(BRequesterState.csrSubmitted);
            this.scheduleNextTask(new GetSigningResult(requester, false, this.getContext()), requester.getSigningCheckCheckRetryDelay(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Exception cause;
            if (BAbstractSigningRequester.LOG.isLoggable(Level.FINE)) {
                BAbstractSigningRequester.LOG.log(Level.WARNING, "Failed to submit CSR, resetting requester state to notOnboarded", e);
            } else {
                BAbstractSigningRequester.LOG.log(Level.WARNING, "Failed to submit CSR, resetting requester state to notOnboarded");
            }
            requester.setRequesterState(BRequesterState.notOnboarded);
            Exception exception = cause = e instanceof PrivilegedActionException ? ((PrivilegedActionException)e).getException() : e;
            if (cause != null && "Password strength not met.".equals(cause.getMessage())) {
                throw new LocalizableException("platCrypto", "signingRequester.certPasswordStrengthFailure");
            }
            throw e;
        }
    }
}

