/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon.messages;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.net.HttpUtil;
import com.tridium.nre.security.SecretBytes;
import com.tridium.nre.security.SecretChars;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import java.io.OutputStream;
import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.Base64;
import java.util.logging.Level;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.xml.XWriter;

public class SetKeyEntryMessage
extends KeyStoreMessage {
    private final String alias;
    private Key key;
    private byte[] rawKey;
    private SecretChars password;
    private final X509Certificate[] chain;

    public SetKeyEntryMessage(String keyStoreType, String alias, byte[] key, X509Certificate[] chain, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.chain = chain;
        this.rawKey = key;
        this.password = null;
        this.sharedSecretKey = sharedSecretKey;
    }

    public SetKeyEntryMessage(String keyStoreType, String alias, Key key, char[] password, X509Certificate[] chain, SharedSecretKey sharedSecretKey) {
        super(keyStoreType);
        this.add("alias", alias);
        this.alias = alias;
        this.chain = chain;
        this.key = key;
        if (password != null) {
            this.password = new SecretChars(password, false);
        }
        this.sharedSecretKey = sharedSecretKey;
    }

    @Override
    public String getAction() {
        return "setKeyEntry";
    }

    public String getMethod() {
        return "POST";
    }

    @Override
    public boolean isStateChangeMessage() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out) {
        XWriter xml = null;
        try {
            xml = new XWriter(out);
            xml.w((Object)"<keyEntry ").attr("alias", this.alias).w((Object)">");
            if (this.rawKey != null) {
                xml.w((Object)"<key>");
                try (X509Certificate[] secretBytes = new SecretBytes(this.rawKey, true);){
                    xml.w((Object)Base64.getEncoder().encodeToString(this.sharedSecretKey.encrypt((SecretBytes)secretBytes)));
                }
                xml.w((Object)"</key>");
            } else if (this.key != null) {
                xml.w((Object)"<key>");
                try {
                    xml.w((Object)HttpUtil.decodeUrl((String)this.prepareMessage(NKey.encodeToString((Key)this.key), this.sharedSecretKey)));
                }
                catch (Exception secretBytes) {
                    // empty catch block
                }
                xml.w((Object)"</key>");
            }
            if (this.chain != null && this.chain.length > 0) {
                xml.w((Object)"<certChain>");
                for (X509Certificate link : this.chain) {
                    xml.w((Object)"<certificate>");
                    try {
                        xml.w((Object)CertUtils.encodeX509Certificate((X509Certificate)link));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    xml.w((Object)"</certificate>");
                }
                xml.w((Object)"</certChain>");
            }
            xml.w((Object)"</keyEntry>");
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.WARNING, "Failed to create SetKeyEntryMessage output", e);
            } else {
                LOG.log(Level.WARNING, "Failed to create SetKeyEntryMessage output: " + e);
            }
        }
        finally {
            if (xml != null) {
                xml.flush();
                xml.close();
            }
        }
    }

    @Override
    public synchronized String getMessageString() {
        this.add("sharedKeyName", this.sharedSecretKey.getName());
        if (this.password != null && this.password.size() > 0) {
            String encodedPassword = this.prepareMessage(this.password, this.sharedSecretKey);
            encodedPassword = HttpUtil.decodeUrl((String)encodedPassword);
            this.add("passwd", encodedPassword);
            this.password.close();
            this.password = null;
        }
        return super.getMessageString();
    }
}

