/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.daemon;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.NKey;
import com.tridium.crypto.core.cert.NX509CertificateEntry;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.nre.security.KeyStorePermission;
import com.tridium.platcrypto.daemon.BPlatCryptoBase;
import com.tridium.platcrypto.daemon.messages.DeleteEntryMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateAliasMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateChainMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificateMessage;
import com.tridium.platcrypto.daemon.messages.GetCertificatesMessage;
import com.tridium.platcrypto.daemon.messages.GetKeyMessage;
import com.tridium.platcrypto.daemon.messages.KeyStoreMessage;
import com.tridium.platcrypto.daemon.messages.SaveMessage;
import com.tridium.platcrypto.daemon.messages.SetCertificateEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryMessage;
import com.tridium.platcrypto.daemon.messages.SetKeyEntryWithResponseMessage;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.message.DaemonMessage;
import java.io.InputStream;
import java.security.Key;
import java.security.KeyStore;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509Certificate;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.nre.security.SharedSecretKey;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;
import javax.baja.xml.XText;

@NiagaraType
public class BPlatKeyStore
extends BPlatCryptoBase
implements ICoreKeyStore {
    @Generated
    public static final Type TYPE = Sys.loadType(BPlatKeyStore.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPlatKeyStore() {
    }

    public BPlatKeyStore(BDaemonSession newSession) {
        super(newSession);
    }

    private static void handleN4SetKeyResponse(XElem response, String alias) throws Exception {
        if (response.text() != null && !"success".equalsIgnoreCase(response.text().string())) {
            throw new Exception("Set key entry for alias '" + alias + "' failed: " + response.text().string());
        }
        if (response.name() != null && "error".equalsIgnoreCase(response.name())) {
            String text;
            XElem nonlocalized;
            String cause = "Unknown failure";
            XElem message = response.elem("message");
            if (message != null && (nonlocalized = message.elem("nonlocalized")) != null && (text = nonlocalized.get("text")) != null) {
                cause = text;
            }
            throw new Exception("Set key entry for alias '" + alias + "' failed: " + cause);
        }
    }

    public String getKeyStoreType() {
        return "userKeyStore";
    }

    private List<String> getAliases() throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType()));
        XElem keyStore = XParser.make((InputStream)in).parse();
        XElem[] keys = keyStore.elems("key");
        ArrayList<String> aliases = new ArrayList<String>(keys != null ? keys.length : 0);
        if (keys != null) {
            for (XElem key : keys) {
                String alias = key.get("alias");
                if (alias == null || alias.isEmpty()) continue;
                aliases.add(alias);
            }
        }
        return aliases;
    }

    public long getLastModified() throws Exception {
        return 0L;
    }

    public boolean isReadOnly() {
        return false;
    }

    public Key getKey(String alias, char[] password) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        SharedSecretKey sharedKey = this.getDaemonSession().generateSharedSecretKey("getKey");
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new GetKeyMessage(this.getKeyStoreType(), alias, password, sharedKey));
        try {
            String key;
            XText value;
            XElem keyElem = XParser.make((InputStream)in).parse();
            if (keyElem != null && (value = keyElem.text()) != null && (key = value.toString()) != null && !key.isEmpty()) {
                String decrypted = sharedKey.decryptChars(Base64.getDecoder().decode(key)).asString(true);
                return NKey.decodeFromString((String)decrypted);
            }
        }
        catch (Exception e) {
            if (password == null && alias != null) {
                LOGGER.log(Level.FINE, "unable to retrieve key '" + alias + "' without a password (" + e + ")");
            }
            LOGGER.log(Level.SEVERE, "unable to retrieve key '" + alias + "' with provided password", e);
        }
        throw new UnrecoverableKeyException("unable to recover key");
    }

    public void setKeyEntry(String alias, Key key, char[] password, X509Certificate[] chain) throws Exception {
        KeyStorePermission.checkWrite((String)this.getKeyStoreType());
        if (this.getDaemonSession().getHostProperties().isNiagara4()) {
            XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, password, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
            BPlatKeyStore.handleN4SetKeyResponse(response, alias);
            return;
        }
        XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, password, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
        if (response.text() != null) {
            if (!"success".equalsIgnoreCase(response.text().string())) {
                throw new Exception(response.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), alias, key, password, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntry")));
        }
    }

    public void setKeyEntry(String alias, byte[] key, X509Certificate[] chain) throws Exception {
        KeyStorePermission.checkWrite((String)this.getKeyStoreType());
        if (this.getDaemonSession().getHostProperties().isNiagara4()) {
            XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
            BPlatKeyStore.handleN4SetKeyResponse(response, alias);
            return;
        }
        XElem response = this.send(new SetKeyEntryWithResponseMessage(this.getKeyStoreType(), alias, key, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntryWithResponse")));
        if (response.text() != null) {
            if (!"success".equalsIgnoreCase(response.text().string())) {
                throw new Exception(response.text().string());
            }
        } else {
            this.send(new SetKeyEntryMessage(this.getKeyStoreType(), alias, key, chain, this.getDaemonSession().generateSharedSecretKey("setKeyEntry")));
        }
    }

    public Enumeration<String> aliases() throws Exception {
        return Collections.enumeration(this.getAliases());
    }

    public boolean containsAlias(String alias) throws Exception {
        return this.getAliases().contains(alias.toLowerCase(Locale.ENGLISH));
    }

    public void deleteEntry(String alias) throws Exception {
        KeyStorePermission.checkWrite((String)this.getKeyStoreType());
        this.getDaemonSession().sendMessage((DaemonMessage)new DeleteEntryMessage(this.getKeyStoreType(), alias));
    }

    public X509Certificate getCertificate(String alias) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        XElem certificate = this.send(new GetCertificateMessage(this.getKeyStoreType(), alias));
        if (certificate != null && certificate.text() != null) {
            String cert = certificate.text().toString();
            return CertUtils.decodeX509Certificate((String)cert);
        }
        return null;
    }

    public String getCertificateAlias(X509Certificate cert) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        XElem keyStore = this.send(new GetCertificateAliasMessage(this.getKeyStoreType(), cert));
        try {
            if (keyStore == null) {
                return null;
            }
            return keyStore.get("alias");
        }
        catch (XException ignored) {
            return null;
        }
    }

    public X509Certificate[] getCertificateChain(String alias) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        XElem[] certs = this.send(new GetCertificateChainMessage(this.getKeyStoreType(), alias), "certificate");
        if (certs == null || certs.length == 0) {
            return null;
        }
        X509Certificate[] certificates = new X509Certificate[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            if (certs[i] == null || certs[i].text() == null || certs[i].text().length() <= 0) continue;
            certificates[i] = CertUtils.decodeX509Certificate((String)certs[i].text().string());
        }
        return certificates;
    }

    public Date getCreationDate(String alias) throws Exception {
        String date;
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        if (keys.length > 0 && (date = keys[0].get("creationDate")) != null && date.length() == "yyyy-MM-dd HH:mm:ss".length()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
            return format.parse(date);
        }
        return null;
    }

    public boolean isKeyEntry(String alias) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        return keys.length > 0 && keys[0].getb("keyEntry");
    }

    public boolean isCertificateEntry(String alias) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        InputStream in = this.getDaemonSession().getInputStream((DaemonMessage)new KeyStoreMessage(this.getKeyStoreType(), alias));
        XElem[] keys = XParser.make((InputStream)in).parse().elems("key");
        return keys.length > 0 && keys[0].getb("certEntry");
    }

    public void setCertificateEntry(String alias, X509Certificate cert) throws Exception {
        KeyStorePermission.checkWrite((String)this.getKeyStoreType());
        this.send(new SetCertificateEntryMessage(this.getKeyStoreType(), alias, cert));
    }

    public int size() throws Exception {
        return this.getAliases().size();
    }

    public void load() throws Exception {
    }

    public void save() throws Exception {
        KeyStorePermission.checkWrite((String)this.getKeyStoreType());
        this.send(new SaveMessage(this.getKeyStoreType()));
    }

    public Iterable<IX509CertificateEntry> getCertificateEntries() throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        XElem[] certificates = this.send(new GetCertificatesMessage(this.getKeyStoreType()), "certificateEntry");
        ArrayList<IX509CertificateEntry> certificatesList = new ArrayList<IX509CertificateEntry>(certificates != null ? certificates.length : 0);
        if (certificates != null) {
            for (XElem certificate : certificates) {
                String certEntry = certificate.text().toString();
                if (certEntry == null || certEntry.isEmpty()) continue;
                certificatesList.add((IX509CertificateEntry)NX509CertificateEntry.decodeFromString((String)certEntry));
            }
        }
        return certificatesList;
    }

    public String findCertificate(X509Certificate cert) throws Exception {
        KeyStorePermission.checkRead((String)this.getKeyStoreType());
        for (IX509CertificateEntry certEntry : this.getCertificateEntries()) {
            IX509Certificate otherCert = certEntry.getCertificate(0);
            if (otherCert == null || !otherCert.getPublicKey().equals(cert.getPublicKey())) continue;
            return certEntry.getAlias();
        }
        return null;
    }

    public void deleteEntries(String[] aliases) throws Exception {
        for (String alias : aliases) {
            this.deleteEntry(alias);
        }
    }

    public KeyStore getKeyStore() throws Exception {
        throw new UnsupportedOperationException("can't access raw keystore remotely");
    }
}

