/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platcrypto.core;

import com.tridium.crypto.core.cert.CertUtils;
import com.tridium.crypto.core.cert.KeyPurpose;
import com.tridium.crypto.core.cert.NX509Certificate;
import com.tridium.crypto.core.cert.NoOpHostnameVerifier;
import com.tridium.crypto.core.io.CoreCryptoManager;
import com.tridium.crypto.core.io.CryptoStoreId;
import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreExemptionStore;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.fox.sys.BFoxChannelRegistry;
import com.tridium.fox.sys.BFoxSession;
import com.tridium.nre.security.ISecurityInfoProvider;
import com.tridium.nre.security.SecurityInitializer;
import com.tridium.platcrypto.core.ICryptoManagerProvider;
import com.tridium.platcrypto.core.IExtCryptoManager;
import com.tridium.platcrypto.core.IProviderInfo;
import com.tridium.platcrypto.core.NExemptionStore;
import com.tridium.platcrypto.core.NKeyStore;
import com.tridium.platcrypto.core.NProviderInfo;
import com.tridium.platcrypto.core.NTrustStore;
import com.tridium.platcrypto.fox.BCryptoChannel;
import com.tridium.platcrypto.fox.ChannelCryptoManager;
import com.tridium.platcrypto.socket.CryptoClientSocketFactory;
import com.tridium.platcrypto.socket.CryptoServerSocketFactory;
import com.tridium.platform.BPlatformService;
import com.tridium.sys.Nre;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.file.BFileSystem;
import javax.baja.file.FilePath;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.ClientTlsParameters;
import javax.baja.nre.security.ServerTlsParameters;
import javax.baja.rpc.NiagaraRpc;
import javax.baja.rpc.Transport;
import javax.baja.rpc.TransportType;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.security.crypto.BSslTlsEnum;
import javax.baja.security.crypto.ICryptoManager;
import javax.baja.security.crypto.IKeyStore;
import javax.baja.security.crypto.ITrustStore;
import javax.baja.security.dashboard.BISecurityDashboardProvider;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.security.dashboard.SecurityDashboardItemBuilder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.user.BUser;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

@NiagaraType
public final class BCertManagerService
extends BPlatformService
implements IExtCryptoManager,
ICryptoManagerProvider,
BISecurityDashboardProvider {
    @Generated
    public static final Type TYPE = Sys.loadType(BCertManagerService.class);
    private static final BIcon icon = BIcon.std((String)"navOnly/certManagerService.png");
    private static final Logger LOGGER = Logger.getLogger("platCrypto");
    private static final int DASHBOARD_VERSION = 1;
    private static final SecurityDashboardItemBuilder dashboardItemBuilder = new SecurityDashboardItemBuilder(TYPE);
    private ICoreCryptoManager cryptoManager = null;
    private NTrustStore userTrustStore = null;
    private NTrustStore userUntrustedStore = null;
    private NTrustStore systemTrustStore = null;
    private NKeyStore keyStore = null;
    private NExemptionStore exemptionStore = null;
    private IProviderInfo providerInfo = null;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BCertManagerService() throws Exception {
        this.setPlatformServiceDescription(this.getLexicon().getText("CertManagerService.description"));
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("crypto") == null) {
            registry.add("crypto", (BValue)new BCryptoChannel());
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public boolean isValidPlatform() {
        return true;
    }

    public int getSlotFlags() {
        return 1;
    }

    public synchronized void serviceStarted() throws Exception {
        super.serviceStarted();
        try {
            AccessController.doPrivileged(new SetSSLSocketFactoryAction());
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        BISession session = this.getSession();
        if (session instanceof BLocalHost) {
            ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
            this.cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)provider);
        } else if (session instanceof BFoxSession) {
            this.cryptoManager = new ChannelCryptoManager((BComponent)this);
        } else {
            throw new Exception("unrecognized session: " + session.getClass().getName());
        }
    }

    public void serviceStopped() throws Exception {
        super.serviceStopped();
        BFoxChannelRegistry registry = BFoxChannelRegistry.getPrototype();
        if (registry.get("crypto") != null) {
            registry.remove("crypto");
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public synchronized ITrustStore getUserTrustStore() throws Exception {
        if (this.userTrustStore == null) {
            this.userTrustStore = new NTrustStore(this.cryptoManager.getUserTrustStore());
        }
        return this.userTrustStore;
    }

    public synchronized ITrustStore getUserUntrustedStore() throws Exception {
        if (this.userUntrustedStore == null) {
            this.userUntrustedStore = new NTrustStore(this.cryptoManager.getUserUntrustedStore());
        }
        return this.userUntrustedStore;
    }

    public synchronized ITrustStore getSystemTrustStore() throws Exception {
        if (this.systemTrustStore == null) {
            this.systemTrustStore = new NTrustStore(this.cryptoManager.getSystemTrustStore());
        }
        return this.systemTrustStore;
    }

    public synchronized IKeyStore getKeyStore() throws Exception {
        if (this.keyStore == null) {
            this.keyStore = new NKeyStore(this.cryptoManager.getKeyStore());
        }
        return this.keyStore;
    }

    @Override
    public synchronized ICoreExemptionStore getExemptionStore() throws Exception {
        if (this.exemptionStore == null) {
            this.exemptionStore = new NExemptionStore(this.cryptoManager.getExemptionStore());
        }
        return this.exemptionStore;
    }

    @Override
    public synchronized IProviderInfo getProviderInfo() throws Exception {
        if (this.providerInfo == null) {
            this.providerInfo = new NProviderInfo(this.cryptoManager.getProviderInfo());
        }
        return this.providerInfo;
    }

    @Override
    public File getBaseDir() {
        try {
            return new File(BCertManagerService.getFilePath(BOrd.make((String)"file:~")));
        }
        catch (Exception e) {
            return Nre.getNiagaraHome();
        }
    }

    @Deprecated
    public ServerSocketFactory getServerSocketFactory(BSslTlsEnum type, boolean clientAuth, String serverAlias) throws Exception {
        ServerTlsParameters tlsParams = new ServerTlsParameters(type.getTag(), serverAlias, null, clientAuth);
        return this.getServerSocketFactory(tlsParams);
    }

    public ServerSocketFactory getServerSocketFactory(ServerTlsParameters tlsParams) throws Exception {
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        return new CryptoServerSocketFactory(provider, tlsParams);
    }

    @Deprecated
    public SocketFactory getClientSocketFactory(BSslTlsEnum type) throws Exception {
        return this.getClientSocketFactory(new ClientTlsParameters(type.getTag()));
    }

    public SocketFactory getClientSocketFactory(ClientTlsParameters tlsParams) throws Exception {
        ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
        return new CryptoClientSocketFactory(provider, tlsParams);
    }

    public ICryptoManager getCryptoManager() {
        return this;
    }

    @Override
    public synchronized ICoreCryptoManager getCoreCryptoManager() throws Exception {
        if (this.cryptoManager == null) {
            BISession session = this.getSession();
            if (session instanceof BLocalHost) {
                ISecurityInfoProvider provider = AccessController.doPrivileged(() -> SecurityInitializer.getInstance().getSecurityInfoProvider());
                this.cryptoManager = CoreCryptoManager.get((ISecurityInfoProvider)provider);
            } else if (session instanceof BFoxSession) {
                this.cryptoManager = new ChannelCryptoManager((BComponent)this);
            } else {
                throw new Exception("unrecognized session: " + session.getClass().getName());
            }
        }
        return this.cryptoManager;
    }

    @NiagaraRpc(transports={@Transport(type=TransportType.box)})
    public List<String> getCertificateAliases(String storeIdName, String purposeIdName, Context cx) throws Exception {
        ITrustStore keyStore;
        CryptoStoreId storeId = CryptoStoreId.valueOf((String)storeIdName);
        KeyPurpose purposeId = purposeIdName != null && !purposeIdName.isEmpty() ? KeyPurpose.valueOf((String)purposeIdName) : null;
        ArrayList<String> aliases = new ArrayList<String>();
        BUser user = BUser.getCurrentAuthenticatedUser();
        if (user == null) {
            LOGGER.fine("no authenticated user, returning empty alias list");
            return Collections.emptyList();
        }
        BPermissions perms = user.getPermissionsFor((BIProtected)this);
        if (!perms.hasOperatorRead()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("user " + user.getUsername() + " does not have operator read permissions, returning empty alias list");
            }
            return Collections.emptyList();
        }
        switch (storeId) {
            case USER_TRUST_STORE: {
                keyStore = this.getUserTrustStore();
                break;
            }
            case SYSTEM_TRUST_STORE: {
                keyStore = this.getSystemTrustStore();
                break;
            }
            case USER_KEY_STORE: {
                keyStore = this.getKeyStore();
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported request for keystore type: " + storeId.getValue());
            }
        }
        Enumeration aliasesEnum = keyStore.aliases();
        while (aliasesEnum.hasMoreElements()) {
            String alias = (String)aliasesEnum.nextElement();
            try {
                X509Certificate cert = keyStore.getCertificate(alias);
                if (cert == null) continue;
                if (purposeId != null) {
                    switch (purposeId) {
                        case SERVER_CERT: {
                            if (!CertUtils.isServerCertificate((X509Certificate)cert)) break;
                            aliases.add(alias);
                            break;
                        }
                        case CA_CERT: {
                            if (!CertUtils.isCACertificate((X509Certificate)cert)) break;
                            aliases.add(alias);
                            break;
                        }
                        case CLIENT_CERT: {
                            if (!CertUtils.isClientCert((X509Certificate)cert)) break;
                            aliases.add(alias);
                            break;
                        }
                        case CODE_SIGNING_CERT: {
                            if (!CertUtils.isCodeSigningCertificate((X509Certificate)cert)) break;
                            aliases.add(alias);
                        }
                    }
                    continue;
                }
                aliases.add(alias);
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, "Exception occurred evaluating cert " + alias, e);
            }
        }
        return Collections.unmodifiableList(aliases);
    }

    private static String getFilePath(BOrd ord) {
        OrdQuery[] o = ord.parse();
        FilePath p = (FilePath)o[o.length - 1];
        File f = BFileSystem.INSTANCE.pathToLocalFile(p);
        return f.getPath();
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        try {
            items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.keystore.size.summary", new Object[]{this.getKeyStore().size()}).withDescription("securityDashboard.keystore.size.description", new Object[0]));
            items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.systemTruststore.size.summary", new Object[]{this.getSystemTrustStore().size()}).withDescription("securityDashboard.systemTruststore.size.description", new Object[0]));
            items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.userTruststore.size.summary", new Object[]{this.getUserTrustStore().size()}).withDescription("securityDashboard.userTruststore.size.description", new Object[0]));
            AccessController.doPrivileged(() -> {
                items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.exemptionStore.size.summary", new Object[]{this.getExemptionStore().size()}).withDescription("securityDashboard.exemptionStore.size.description", new Object[0]));
                return null;
            });
            int globalKeyStoreCount = 0;
            int uniqueKeyStoreCount = 0;
            int selfSignedKeyStoreCount = 0;
            int expiredKeyStoreCount = 0;
            ICoreKeyStore keyStore = (ICoreKeyStore)this.getKeyStore();
            Enumeration aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                NX509Certificate cert = NX509Certificate.make((X509Certificate)keyStore.getCertificate(alias));
                if (!cert.checkValidity()) {
                    ++expiredKeyStoreCount;
                }
                if ("default".equals(alias)) continue;
                if (cert.isSelfSigned()) {
                    ++selfSignedKeyStoreCount;
                }
                if (CertUtils.isPrivateKeyGloballyEncrypted((String)alias, (ICoreKeyStore)keyStore)) {
                    ++globalKeyStoreCount;
                    continue;
                }
                ++uniqueKeyStoreCount;
            }
            if (globalKeyStoreCount > 0) {
                items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.globallyEncrypted.keystore.size.summary", new Object[]{globalKeyStoreCount}).withDescription("securityDashboard.globallyEncrypted.keystore.size.description", new Object[]{"default"}));
            } else {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.globallyEncrypted.keystore.size.summary", new Object[]{globalKeyStoreCount}).withDescription("securityDashboard.globallyEncrypted.keystore.size.description", new Object[]{"default"}));
            }
            if (uniqueKeyStoreCount > 0) {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.uniquelyEncrypted.keystore.size.summary", new Object[]{uniqueKeyStoreCount}).withDescription("securityDashboard.uniquelyEncrypted.keystore.size.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.uniquelyEncrypted.keystore.size.summary", new Object[]{uniqueKeyStoreCount}).withDescription("securityDashboard.uniquelyEncrypted.keystore.size.description", new Object[0]));
            }
            items.add(dashboardItemBuilder.makeInfo().withSummary("securityDashboard.selfSigned.keystore.size.summary", new Object[]{selfSignedKeyStoreCount}).withDescription("securityDashboard.selfSigned.keystore.size.description", new Object[]{"default"}));
            if (expiredKeyStoreCount > 0) {
                items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.expired.keystore.size.summary", new Object[]{expiredKeyStoreCount}).withDescription("securityDashboard.expired.keystore.size.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.expired.keystore.size.summary", new Object[]{expiredKeyStoreCount}).withDescription("securityDashboard.expired.keystore.size.description", new Object[0]));
            }
            int expiredUserTrustStoreCount = 0;
            ICoreTrustStore userTrustStore = (ICoreTrustStore)this.getUserTrustStore();
            aliases = userTrustStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = (String)aliases.nextElement();
                NX509Certificate cert = NX509Certificate.make((X509Certificate)userTrustStore.getCertificate(alias));
                if (cert.checkValidity()) continue;
                ++expiredUserTrustStoreCount;
            }
            if (expiredUserTrustStoreCount > 0) {
                items.add(dashboardItemBuilder.makeAlert().withSummary("securityDashboard.expired.userTruststore.size.summary", new Object[]{expiredUserTrustStoreCount}).withDescription("securityDashboard.expired.userTruststore.size.description", new Object[0]));
            } else {
                items.add(dashboardItemBuilder.makeOk().withSummary("securityDashboard.expired.userTruststore.size.summary", new Object[]{expiredUserTrustStoreCount}).withDescription("securityDashboard.expired.userTruststore.size.description", new Object[0]));
            }
        }
        catch (Exception e) {
            items.clear();
            LOGGER.log(Level.WARNING, "Error loading dashboard items.", e);
            items.add(dashboardItemBuilder.makeWarning().withSummary("securityDashboard.error.summary", new Object[0]).withDescription("securityDashboard.error.description", new Object[0]));
        }
        return items;
    }

    private static class SetSSLSocketFactoryAction
    implements PrivilegedExceptionAction<SSLSocketFactory> {
        private SetSSLSocketFactoryAction() {
        }

        @Override
        public SSLSocketFactory run() {
            HttpsURLConnection.setDefaultHostnameVerifier((HostnameVerifier)new NoOpHostnameVerifier());
            return null;
        }
    }
}

