/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.jackson.io;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.jackson.io.JacksonSerializer;
import io.jsonwebtoken.lang.Assert;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class JacksonDeserializer<T>
implements Deserializer<T> {
    private final Class<T> returnType;
    private final ObjectMapper objectMapper;

    public JacksonDeserializer() {
        this(JacksonSerializer.DEFAULT_OBJECT_MAPPER);
    }

    public JacksonDeserializer(Map<String, Class> claimTypeMap) {
        this(new ObjectMapper());
        Assert.notNull(claimTypeMap, "Claim type map cannot be null.");
        SimpleModule module = new SimpleModule();
        module.addDeserializer(Object.class, new MappedTypeDeserializer(Collections.unmodifiableMap(claimTypeMap)));
        this.objectMapper.registerModule(module);
    }

    public JacksonDeserializer(ObjectMapper objectMapper) {
        this(objectMapper, Object.class);
    }

    private JacksonDeserializer(ObjectMapper objectMapper, Class<T> returnType) {
        Assert.notNull(objectMapper, "ObjectMapper cannot be null.");
        Assert.notNull(returnType, "Return type cannot be null.");
        this.objectMapper = objectMapper;
        this.returnType = returnType;
    }

    @Override
    public T deserialize(byte[] bytes) throws DeserializationException {
        try {
            return this.readValue(bytes);
        }
        catch (IOException e) {
            String msg = "Unable to deserialize bytes into a " + this.returnType.getName() + " instance: " + e.getMessage();
            throw new DeserializationException(msg, e);
        }
    }

    protected T readValue(byte[] bytes) throws IOException {
        return this.objectMapper.readValue(bytes, this.returnType);
    }

    private static class MappedTypeDeserializer
    extends UntypedObjectDeserializer {
        private final Map<String, Class> claimTypeMap;

        private MappedTypeDeserializer(Map<String, Class> claimTypeMap) {
            super(null, null);
            this.claimTypeMap = claimTypeMap;
        }

        @Override
        public Object deserialize(JsonParser parser, DeserializationContext context) throws IOException {
            String name = parser.currentName();
            if (this.claimTypeMap != null && name != null && this.claimTypeMap.containsKey(name)) {
                Class type = this.claimTypeMap.get(name);
                return parser.readValueAsTree().traverse(parser.getCodec()).readValueAs(type);
            }
            return super.deserialize(parser, context);
        }
    }
}

