/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.util.jwt;

import java.util.Objects;
import javax.baja.sys.BComplex;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Type;

public final class ParentLegal {
    private static final String LEX_KEY = "mustBeParentedBy";

    private ParentLegal() {
    }

    public static boolean is(BComplex child, BComplex proposedParent, Type ... expected) {
        Objects.requireNonNull(child);
        Objects.requireNonNull(proposedParent);
        Objects.requireNonNull(expected);
        boolean valid = false;
        for (Type t : expected) {
            if (t == null || !proposedParent.getType().is(t)) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return ParentLegal.reportBadParent(child, proposedParent, expected);
        }
        return true;
    }

    private static boolean reportBadParent(BComplex child, BComplex proposedParent, Type ... expected) {
        StringBuilder expectedParentList = new StringBuilder();
        for (int i = 0; i < expected.length; ++i) {
            expectedParentList.append(expected[i]);
            if (i >= expected.length - 1) continue;
            expectedParentList.append(", ");
        }
        Object[] expectedParentLexiconMsgArgs = new Object[]{child.getType().getTypeName(), expectedParentList, proposedParent.getType().getTypeName()};
        IllegalParentException pe = new IllegalParentException(child.getType().getModule().getModuleName(), LEX_KEY, expectedParentLexiconMsgArgs);
        throw pe;
    }
}

