/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.proxyExt.publishers;

import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import com.tridium.mqttClientDriver.proxyExt.BMqttClientAbstractProxyExt;
import java.util.logging.Logger;
import javax.baja.control.BControlPoint;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="retained", type="boolean", defaultValue="true"), @NiagaraProperty(name="publishMessageOnChange", type="boolean", defaultValue="true")})
@NiagaraAction(name="publish", flags=16)
public abstract class BMqttClientAbstractPublisherPoint
extends BMqttClientAbstractProxyExt {
    @Generated
    public static final Property retained = BMqttClientAbstractPublisherPoint.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property publishMessageOnChange = BMqttClientAbstractPublisherPoint.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Action publish = BMqttClientAbstractPublisherPoint.newAction((int)16, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BMqttClientAbstractPublisherPoint.class);
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.publisher");

    @Generated
    public boolean getRetained() {
        return this.getBoolean(retained);
    }

    @Generated
    public void setRetained(boolean v) {
        this.setBoolean(retained, v, null);
    }

    @Generated
    public boolean getPublishMessageOnChange() {
        return this.getBoolean(publishMessageOnChange);
    }

    @Generated
    public void setPublishMessageOnChange(boolean v) {
        this.setBoolean(publishMessageOnChange, v, null);
    }

    @Generated
    public void publish() {
        this.invoke(publish, null, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doPublish() {
        String message = this.getMessageToPublish();
        try {
            this.publishMessageToTopic(message);
            BStatusValue out = this.getWriteValue();
            this.writeOk(out);
            this.readOk(out);
        }
        catch (Exception ex) {
            this.writeFail("Could not publish " + ex.getMessage());
            logger.warning(ex.getMessage());
        }
    }

    private void publishMessageToTopic(String message) {
        String topic = this.getTopic();
        int qos = this.getQoS().getOrdinal();
        if (this.checkIfMessageIsOfCorrectType(message) && this.getEnabled()) {
            this.publishMessageToTopic(topic, qos, message);
        }
    }

    private void publishMessageToTopic(String topic, int qos, String message) {
        try {
            boolean retainedFlag = this.getRetained();
            if (this.nMqttClient == null || !this.nMqttClient.isConnected()) {
                return;
            }
            this.nMqttClient.publish(topic, qos, message, retainedFlag);
        }
        catch (Exception e) {
            logger.fine(e.getMessage());
            throw new LocalizableRuntimeException("abstractMqttDriver", "couldNotPublish");
        }
    }

    @Override
    public boolean write(Context cx) throws Exception {
        String message = this.getMessageToPublish();
        if (this.getPublishMessageOnChange()) {
            try {
                this.publishMessageToTopic(message);
                BStatusValue out = this.getWriteValue();
                this.writeOk(out);
                this.readOk(out);
                return true;
            }
            catch (Exception ex) {
                this.writeFail(ex.getMessage());
                logger.warning(ex.getLocalizedMessage());
                return false;
            }
        }
        this.writeFail("Could not publish.");
        return false;
    }

    @Override
    public boolean addLink() {
        String targetSlot = "in15";
        String pubPropertyName = "publisherLink";
        String localSlotName = this.getLocalPointSlot().getTag();
        BControlPoint targetPoint = this.getParentPoint();
        BOrd ord = this.getLocalPoint();
        if (!ord.equals((Object)BOrd.NULL)) {
            BLink[] targetLinks;
            BControlPoint sourcePoint = (BControlPoint)ord.get((BObject)this);
            BFacets sourceFacets = sourcePoint.getFacets();
            targetPoint.setFacets(sourceFacets);
            BLink newLink = new BLink(sourcePoint.getHandleOrd(), localSlotName, targetSlot, true);
            for (BLink link : targetLinks = targetPoint.getLinks(targetPoint.getSlot(targetSlot))) {
                if (!pubPropertyName.equals(link.getName())) continue;
                targetPoint.remove((BComplex)link);
            }
            try {
                targetPoint.add(pubPropertyName, (BValue)newLink, 2);
                newLink.activate();
            }
            catch (Exception e) {
                logger.info(BAbstractMqttDevice.lex.get("couldNotLink") + e.getMessage());
                return false;
            }
            BStatusValue sourceValue = sourcePoint.getOutStatusValue();
            targetPoint.set(targetSlot, sourceValue.newCopy(), null);
            return true;
        }
        return false;
    }

    protected abstract String getMessageToPublish();

    public abstract boolean checkIfMessageIsOfCorrectType(String var1);
}

