/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mqttClientDriver.clients.aws;

import com.amazonaws.services.iot.client.AWSIotConnectionStatus;
import com.amazonaws.services.iot.client.AWSIotMqttClient;
import com.amazonaws.services.iot.client.AWSIotQos;
import com.tridium.mqttClientDriver.BAbstractMqttDevice;
import java.util.concurrent.Callable;
import java.util.logging.Logger;

public class MqttAwsPubCallable
implements Callable<String> {
    private AWSIotMqttClient mqttClient;
    private String message;
    private String topic;
    private int qos;
    protected static final Logger logger = Logger.getLogger("abstractMqttDriver.mqttClient");

    public MqttAwsPubCallable(String topic, AWSIotMqttClient mqttClient, int qos, String message) {
        this.mqttClient = mqttClient;
        this.message = message;
        this.topic = topic;
        this.qos = qos;
    }

    @Override
    public String call() throws Exception {
        try {
            if (this.mqttClient != null && this.mqttClient.getConnectionStatus() == AWSIotConnectionStatus.CONNECTED) {
                this.mqttClient.publish(this.topic, AWSIotQos.valueOf(this.qos), this.message);
            }
            return this.topic;
        }
        catch (Exception e) {
            logger.fine(BAbstractMqttDevice.lex.getText("publishMessageLost", new Object[]{e.getMessage()}));
            throw e;
        }
    }
}

