/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.schedule;

import com.tridium.schedule.Chronometer;
import com.tridium.sys.metrics.IMetricResource;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCalendarSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="alwaysEffective", type="boolean", defaultValue="false", flags=0x10000104, override=true), @NiagaraProperty(name="union", type="boolean", defaultValue="false", flags=0x10000104, override=true), @NiagaraProperty(name="dates", type="BCalendarSchedule", defaultValue="new BCalendarSchedule()", flags=260), @NiagaraProperty(name="times", type="BDaySchedule", defaultValue="new BDaySchedule()", flags=260), @NiagaraProperty(name="enabled", type="boolean", defaultValue="true", flags=0x10000108), @NiagaraProperty(name="lastTrigger", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=265), @NiagaraProperty(name="nextTrigger", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=265), @NiagaraProperty(name="nextTriggerSearchLimit", type="BRelTime", defaultValue="Chronometer._90_DAYS", flags=0x10000100), @NiagaraProperty(name="lastModified", type="BAbsTime", defaultValue="BAbsTime.NULL", flags=257), @NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=257, override=true)})
@NiagaraAction(name="execute", flags=20)
@NiagaraTopics(value={@NiagaraTopic(name="trigger", flags=8), @NiagaraTopic(name="triggerMissed", eventType="BAbsTime")})
public class BTriggerSchedule
extends BCompositeSchedule
implements BIStatus,
IMetricResource {
    @Generated
    public static final Property alwaysEffective = BTriggerSchedule.newProperty((int)0x10000104, (boolean)false, null);
    @Generated
    public static final Property union = BTriggerSchedule.newProperty((int)0x10000104, (boolean)false, null);
    @Generated
    public static final Property dates = BTriggerSchedule.newProperty((int)260, (BValue)new BCalendarSchedule(), null);
    @Generated
    public static final Property times = BTriggerSchedule.newProperty((int)260, (BValue)new BDaySchedule(), null);
    @Generated
    public static final Property enabled = BTriggerSchedule.newProperty((int)0x10000108, (boolean)true, null);
    @Generated
    public static final Property lastTrigger = BTriggerSchedule.newProperty((int)265, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property nextTrigger = BTriggerSchedule.newProperty((int)265, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property nextTriggerSearchLimit = BTriggerSchedule.newProperty((int)0x10000100, (BValue)Chronometer._90_DAYS, null);
    @Generated
    public static final Property lastModified = BTriggerSchedule.newProperty((int)257, (BValue)BAbsTime.NULL, null);
    @Generated
    public static final Property status = BTriggerSchedule.newProperty((int)257, (BValue)BStatus.ok, null);
    @Generated
    public static final Action execute = BTriggerSchedule.newAction((int)20, null);
    @Generated
    public static final Topic trigger = BTriggerSchedule.newTopic((int)8, null);
    @Generated
    public static final Topic triggerMissed = BTriggerSchedule.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTriggerSchedule.class);
    private Clock.Ticket ticket = null;
    private static final Pattern TIME_PATTERN = Pattern.compile("(?<hours>^\\d{1,2}):(?<mins>\\d{1,2})[ ]?(?<ampm>[a|p]m)?$", 2);

    @Generated
    public BCalendarSchedule getDates() {
        return (BCalendarSchedule)this.get(dates);
    }

    @Generated
    public void setDates(BCalendarSchedule v) {
        this.set(dates, (BValue)v, null);
    }

    @Generated
    public BDaySchedule getTimes() {
        return (BDaySchedule)this.get(times);
    }

    @Generated
    public void setTimes(BDaySchedule v) {
        this.set(times, (BValue)v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BAbsTime getLastTrigger() {
        return (BAbsTime)this.get(lastTrigger);
    }

    @Generated
    public void setLastTrigger(BAbsTime v) {
        this.set(lastTrigger, (BValue)v, null);
    }

    @Generated
    public BAbsTime getNextTrigger() {
        return (BAbsTime)this.get(nextTrigger);
    }

    @Generated
    public void setNextTrigger(BAbsTime v) {
        this.set(nextTrigger, (BValue)v, null);
    }

    @Generated
    public BRelTime getNextTriggerSearchLimit() {
        return (BRelTime)this.get(nextTriggerSearchLimit);
    }

    @Generated
    public void setNextTriggerSearchLimit(BRelTime v) {
        this.set(nextTriggerSearchLimit, (BValue)v, null);
    }

    @Generated
    public BAbsTime getLastModified() {
        return (BAbsTime)this.get(lastModified);
    }

    @Generated
    public void setLastModified(BAbsTime v) {
        this.set(lastModified, (BValue)v, null);
    }

    @Generated
    public void execute() {
        this.invoke(execute, null, null);
    }

    @Generated
    public void fireTrigger(BValue event) {
        this.fire(trigger, event, null);
    }

    @Generated
    public void fireTriggerMissed(BAbsTime event) {
        this.fire(triggerMissed, (BValue)event, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void addDates(String name, BAbstractSchedule sch) {
        this.getDates().add(name, (BValue)sch);
    }

    public boolean addTime(int hour, int min) {
        return this.getTimes().addTrigger(hour, min);
    }

    public boolean addTime(String time) {
        Matcher m = TIME_PATTERN.matcher(time);
        boolean matches = m.matches();
        if (!matches) {
            throw new IllegalArgumentException("Invalid argument (hh:mm [am|pm]): " + time);
        }
        String hours = m.group("hours");
        String mins = m.group("mins");
        String ampm = m.group("ampm");
        int ihours = Integer.parseInt(hours);
        int imins = Integer.parseInt(mins);
        if ("PM".equalsIgnoreCase(ampm)) {
            if (ihours < 12) {
                ihours += 12;
            }
        } else if (ihours == 12) {
            ihours = 0;
        }
        return this.getTimes().addTrigger(ihours, imins);
    }

    public void clearTimes() {
        this.getTimes().clear();
    }

    public void clockChanged(BRelTime shift) throws Exception {
        super.clockChanged(shift);
        this.execute();
    }

    public void doExecute() {
        BAbsTime next;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        BAbsTime time = Clock.time();
        if (!this.isMounted()) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        if (this.isEffective(time)) {
            if (this.getEnabled()) {
                this.fireTrigger(null);
                this.setLastTrigger(time);
            }
        } else if (this.getNextTrigger() != BAbsTime.NULL && time.getMillis() > this.getNextTrigger().getMillis() + 1000L && this.getEnabled()) {
            this.fireTriggerMissed(this.getNextTrigger());
        }
        if ((next = this.nextTrigger(time, time.add(this.getNextTriggerSearchLimit()))) == null) {
            this.setNextTrigger(BAbsTime.NULL);
            next = Clock.time().add(BRelTime.DAY);
        } else {
            this.setNextTrigger(next);
        }
        this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)execute, null);
    }

    @Override
    public BAbsTime nextEvent(BAbsTime after) {
        if (this.getTimes().nextEvent(after) == null) {
            return null;
        }
        if (this.getDates().isEffective(after)) {
            return super.nextEvent(after);
        }
        return this.getDates().nextEvent(after);
    }

    public BAbsTime nextTrigger(BAbsTime from, BAbsTime to) {
        return this.next(true, from, to);
    }

    public IFuture post(Action action, BValue arg, Context cx) {
        BControlSchedule.pool.enqueue((Runnable)new Invocation((BComponent)this, action, arg, cx));
        return null;
    }

    public void started() throws Exception {
        super.started();
        if (Sys.isStationStarted()) {
            this.execute();
        }
    }

    public void stationStarted() throws Exception {
        super.stationStarted();
        this.execute();
    }

    public void stopped() throws Exception {
        super.stopped();
        if (this.ticket != null) {
            this.ticket.cancel();
        }
    }

    @Override
    protected void modified() {
        this.setLastModified(Clock.time());
        this.execute();
        super.modified();
    }
}

