/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.schedule;

import com.tridium.schedule.BIScheduleSnapshotHandler;
import com.tridium.schedule.ScheduleUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.collection.TableCursor;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BWeeklySchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDate;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BSingleton;
import javax.baja.sys.BTime;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

@NiagaraType(agent={@AgentOn(types={"schedule:AbstractSchedule"})})
@NiagaraSingleton
public final class BScheduleSnapshotHandler
extends BSingleton
implements BIScheduleSnapshotHandler {
    @Generated
    public static final BScheduleSnapshotHandler INSTANCE = new BScheduleSnapshotHandler();
    @Generated
    public static final Type TYPE = Sys.loadType(BScheduleSnapshotHandler.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    private BScheduleSnapshotHandler() {
    }

    @Override
    public BAbstractSchedule getSnapshot(BComponent source, Context cx) {
        return (BAbstractSchedule)source.newCopy(true);
    }

    @Override
    public BAbstractSchedule saveSnapshot(BComponent source, BAbstractSchedule schedule, Context cx) {
        ScheduleUtil.validateSchedule(schedule, cx);
        BAbstractSchedule sourceSchedule = (BAbstractSchedule)source;
        ScheduleUtil.stationSideAuditableCopyFrom(sourceSchedule, schedule, cx);
        if (source instanceof BControlSchedule) {
            BControlSchedule controlSchedule = (BControlSchedule)source;
            controlSchedule.setLastModified(BAbsTime.now());
            controlSchedule.execute();
        }
        return sourceSchedule;
    }

    @Override
    public BOrd getRefBaseOrd(BComponent source) {
        return source.getNavOrd();
    }

    @Override
    public List<BDate> getHighlightedDates(BComponent source, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        if (start == null) {
            throw new IllegalArgumentException("start required");
        }
        if (end == null) {
            throw new IllegalArgumentException("end required");
        }
        if (start.isAfter(end)) {
            throw new IllegalArgumentException("start cannot be after end");
        }
        ArrayList<BDate> dates = new ArrayList<BDate>();
        BAbsTime today = BScheduleSnapshotHandler.toAbsTime(start);
        BAbsTime tomorrow = today.nextDay();
        BAbsTime endDate = BScheduleSnapshotHandler.toAbsTime(end);
        while (endDate.isAfter(today)) {
            if (sched.isEffective(today) || sched.next(true, today, tomorrow) != null) {
                dates.add(today.getDate());
            }
            today = tomorrow;
            tomorrow = tomorrow.nextDay();
        }
        return dates;
    }

    @Override
    public List<BOrd> findCalendarSchedules(BComponent source, Context cx) {
        BITable table = (BITable)BOrd.make((String)"station:|slot:/|bql:select slotPathOrd from schedule:CalendarSchedule").get((BObject)BLocalHost.INSTANCE, cx);
        Column slotPathOrdCol = table.getColumns().get(0);
        ArrayList<BOrd> calendars = new ArrayList<BOrd>();
        try (TableCursor cursor = table.cursor();){
            while (cursor.next()) {
                calendars.add((BOrd)cursor.cell(slotPathOrdCol));
            }
        }
        return calendars;
    }

    @Override
    public List<Map<String, String>> getSummary(BComponent source, BAbstractSchedule sched, BDate start, BDate end, Context cx) {
        ArrayList<Map<String, String>> summary = new ArrayList<Map<String, String>>();
        BWeeklySchedule weeklySchedule = (BWeeklySchedule)sched;
        BFacets facets = weeklySchedule.getFacets();
        BAbsTime time = BScheduleSnapshotHandler.toAbsTime(start);
        BAbsTime endTime = BScheduleSnapshotHandler.toAbsTime(end);
        String lastOutput = "";
        String lastSource = "";
        while (time != null && time.isBefore(endTime)) {
            String output = weeklySchedule.getOutput(time).toString((Context)facets);
            String sourceStr = weeklySchedule.getSummary(weeklySchedule.getOutputSource(time), cx);
            if (!output.equals(lastOutput) || !sourceStr.equals(lastSource)) {
                HashMap<String, String> info = new HashMap<String, String>(3);
                info.put("timestamp", time.toString(cx));
                info.put("output", output);
                info.put("source", sourceStr);
                summary.add(info);
                lastOutput = output;
                lastSource = sourceStr;
            }
            time = sched.nextEvent(time);
        }
        return summary;
    }

    @Override
    public Map<String, Object> getScheduleOptions(BComponent source, Context cx) {
        HashMap<String, Object> options = new HashMap<String, Object>(3);
        options.put("version", Sys.getBajaVersion().toString());
        options.put("typeSpec", source.getType().toString());
        BComplex parent = source.getParent();
        Property prop = source.getPropertyInParent();
        boolean readonly = parent != null && Flags.isReadonly((BComplex)parent, (Slot)prop) || !source.getPermissions(cx).hasOperatorWrite() || source.get("ext") != null;
        options.put("readonly", readonly);
        return options;
    }

    private static BAbsTime toAbsTime(BDate date) {
        return BAbsTime.make((BDate)date, (BTime)BTime.MIDNIGHT, (BTimeZone)BTimeZone.getLocal());
    }
}

