/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.jetty;

import com.tridium.jetty.NiagaraHttpSession;
import com.tridium.session.SessionManager;
import com.tridium.web.session.NiagaraWebSession;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.server.session.DefaultSessionCache;
import org.eclipse.jetty.server.session.Session;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.server.session.SessionHandler;

public class NiagaraSessionCache
extends DefaultSessionCache {
    private static final Logger LOGGER = Logger.getLogger("security.sessionManager");

    public NiagaraSessionCache(SessionHandler manager) {
        super(manager);
    }

    public Session newSession(SessionData data) {
        Session session = super.newSession(data);
        NiagaraHttpSession niagaraSession = (NiagaraHttpSession)SessionManager.getNiagaraSession((String)session.getId(), NiagaraWebSession.class);
        if (niagaraSession != null && !niagaraSession.contains((HttpSession)session)) {
            niagaraSession.addHttpSession((HttpSession)session, false);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(String.format("Created new NiagaraHttpSession: id = %s, superId = %s", niagaraSession.getId(), niagaraSession.getSuperId()));
            }
        }
        return session;
    }
}

