/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.px.editor;

import com.tridium.px.editor.commands.EditPropertiesContext;
import com.tridium.px.editor.factory.AliasNavNodeFactory;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BActionArgCE;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BVariablesCE;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BWidgetEventCE;
import com.tridium.px.editor.sidebars.cellsheet.celleditors.BWidgetPropertyCE;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.px.editor.BIPxTransferWidget;
import javax.baja.px.editor.BPxEditor;
import javax.baja.px.editor.factory.ImageFileFactory;
import javax.baja.px.editor.factory.JsFileFactory;
import javax.baja.px.editor.factory.LabelFactory;
import javax.baja.px.editor.factory.NavNodeFactory;
import javax.baja.px.editor.factory.PictureFactory;
import javax.baja.px.editor.factory.PxFileFactory;
import javax.baja.px.editor.factory.WidgetCloningFactory;
import javax.baja.px.editor.factory.WidgetFactory;
import javax.baja.px.editor.factory.WidgetInserter;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BMenu;
import javax.baja.ui.Command;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.util.BTypeSpec;
import javax.baja.workbench.celleditor.BWbCellEditor;

public class PxEditorController {
    private static Type ACTION_BINDING = null;
    private static Type SETPOINT_BINDING = null;
    private static Type SPECTRUM_BINDING = null;
    private final BPxEditor editor;
    private final List<WidgetFactory> factories = new ArrayList<WidgetFactory>();

    public PxEditorController(BPxEditor editor) {
        this.editor = editor;
        this.factories.addAll(new ArrayList<WidgetFactory>(Arrays.asList(this.getDefaultWidgetFactories())));
    }

    public BWbCellEditor getCellEditor(BComponent component, Property property) {
        if (component instanceof BBinding) {
            BWbCellEditor ce = PxEditorController.makeBindingCE(this.editor, (BBinding)component, property);
            ce.loadValue((BObject)component.get(property), (Context)component.getSlotFacets((Slot)property));
            return ce;
        }
        if (component instanceof BPxInclude && property.getName().equals("variables")) {
            return PxEditorController.makePxIncludeVariablesCE((BPxInclude)component);
        }
        BWbCellEditor ce = BWbCellEditor.makeFor((BObject)component.get(property), (Context)component.getSlotFacets((Slot)property));
        ce.loadValue((BObject)component.get(property), (Context)component.getSlotFacets((Slot)property));
        return ce;
    }

    public BMenu getPopupMenu(BIPxTransferWidget transferWidget, BMouseEvent event) {
        return transferWidget.getDefaultPopupMenu(event);
    }

    public boolean allowDrop(BIPxTransferWidget transferWidget, TransferContext cx) {
        return true;
    }

    public Command getDoubleClickCommand(BIPxTransferWidget transferWidget, BMouseEvent event) {
        return new EditPropertiesContext(this.editor);
    }

    public final WidgetFactory[] getDefaultWidgetFactories() {
        return new WidgetFactory[]{new LabelFactory(this.editor), new PictureFactory(this.editor), new WidgetCloningFactory(this.editor), new PxFileFactory(this.editor), new ImageFileFactory(this.editor), new JsFileFactory(this.editor), new AliasNavNodeFactory(this.editor), new NavNodeFactory(this.editor)};
    }

    public WidgetFactory[] getWidgetFactories() {
        return this.factories.toArray(new WidgetFactory[0]);
    }

    public void addWidgetFactory(WidgetFactory factory) {
        if (!this.factories.contains(factory)) {
            this.factories.add(factory);
        }
    }

    public void removeWidgetFactory(WidgetFactory factory) {
        this.factories.remove(factory);
    }

    public WidgetInserter getWidgetInserter(BIPxTransferWidget transferWidget, BObject[] objects) {
        for (int i = 0; i < this.factories.size(); ++i) {
            WidgetFactory f = this.factories.get(i);
            if (!f.canConvert(objects)) continue;
            return f.make(objects);
        }
        throw new BajaRuntimeException("Cannot create widgets for " + new Array((Object[])objects));
    }

    private static BWbCellEditor makeBindingCE(BPxEditor editor, BBinding binding, Property property) {
        if (property.getName().equals("widgetEvent")) {
            if (PxEditorController.isType(binding.getType(), ACTION_BINDING)) {
                return new BWidgetEventCE(binding.getWidget(), "started");
            }
            if (PxEditorController.isType(binding.getType(), SETPOINT_BINDING)) {
                return new BWidgetEventCE(binding.getWidget(), new String[0]);
            }
        } else {
            if (property.getName().equals("widgetProperty")) {
                return new BWidgetPropertyCE(binding.getWidget(), PxEditorController.isType(binding.getType(), SPECTRUM_BINDING) ? BBrush.TYPE : BObject.TYPE);
            }
            if (property.getName().equals("actionArg") && PxEditorController.isType(binding.getType(), ACTION_BINDING)) {
                return new BActionArgCE(PxEditorController.getActionForOrd(editor, binding.getOrd()));
            }
        }
        return BWbCellEditor.makeFor((BObject)binding.get(property));
    }

    private static Action getActionForOrd(BPxEditor editor, BOrd ord) {
        if (ord == null || ord.isNull()) {
            return null;
        }
        try {
            BObject base = editor.getWbShell().getActiveOrdTarget().get();
            return (Action)ord.resolve(base).getSlotInComponent();
        }
        catch (Exception e) {
            Logger.getLogger("pxEditor").warning("BPxProfile.getActionForOrd: " + e.getMessage());
            return null;
        }
    }

    private static BWbCellEditor makePxIncludeVariablesCE(BPxInclude inc) {
        if (inc.getRootWidget() == null) {
            BVariablesCE ce = new BVariablesCE();
            ce.loadValue((BObject)BFacets.NULL, null);
            ce.setReadonly(true);
            return ce;
        }
        Object[] obj = (Object[])inc.fw(304, null, null, null, null);
        BOrd[] origOrds = (BOrd[])obj[0];
        BVariablesCE ce = new BVariablesCE(origOrds);
        ce.loadValue((BObject)BVariablesCE.makeFacets(inc), (Context)inc.getSlotFacets((Slot)BPxInclude.variables));
        return ce;
    }

    private static boolean isType(Type type, Type is) {
        return is == null ? false : type.is(is);
    }

    public BPxEditor getPxEditor() {
        return this.editor;
    }

    static {
        try {
            ACTION_BINDING = BTypeSpec.make((String)"kitPx:ActionBinding").getResolvedType();
            SETPOINT_BINDING = BTypeSpec.make((String)"kitPx:SetPointBinding").getResolvedType();
            SPECTRUM_BINDING = BTypeSpec.make((String)"kitPx:SpectrumBinding").getResolvedType();
        }
        catch (Exception e) {
            Logger.getLogger("pxEditor").warning("BPxProfile<clinit>: " + e.getMessage());
        }
    }
}

