/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.sidebars.cellsheet;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.px.editor.sidebars.cellsheet.BPxCellSheet;
import com.tridium.px.editor.sidebars.cellsheet.CellTableContext;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.celltable.CellController;
import com.tridium.workbench.celltable.CellEditorContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.celleditor.BWbCellEditor;

@NiagaraType
@NiagaraAction(name="handleSelectionModified")
public class BPxCellTable
extends BTable
implements CellEditorContainer {
    @Generated
    public static final Action handleSelectionModified = BPxCellTable.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BPxCellTable.class);
    protected BPxEditorPane editorPane;
    protected final BPxCellSheet sheet;
    private Model model = new Model();
    private boolean dragging = false;
    private boolean ignoreModified = false;
    private CellController cellController;

    @Generated
    public void handleSelectionModified() {
        this.invoke(handleSelectionModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BPxCellTable(BPxEditorPane editorPane, BPxCellSheet sheet) {
        this.editorPane = editorPane;
        this.sheet = sheet;
        this.setMultipleSelection(false);
        this.setHeaderVisible(false);
        this.setExtendedResize(true);
        this.setHscrollBarVisible(false);
        this.setVscrollBarVisible(false);
        this.setGridBrush(Theme.widget().getControlShadow());
        this.setCellRenderer(new CellRenderer());
        this.setModel(this.model);
        this.setController(new Controller());
        this.setCellController(new PxCellController());
        this.linkTo("lnkHandleMod", (BComponent)this, (Slot)BTable.selectionModified, (Slot)handleSelectionModified);
    }

    public void doHandleSelectionModified() {
        if (this.ignoreModified) {
            return;
        }
        BPxCellTable[] tables = this.sheet.getCellTables();
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] == this) continue;
            tables[i].ignoreModified = true;
            tables[i].getSelection().deselectAll();
            tables[i].ignoreModified = false;
        }
    }

    public void doLayout(BWidget[] children) {
        super.doLayout(children);
        for (int i = 0; i < this.model.cellEditors.size(); ++i) {
            BWbCellEditor ce = (BWbCellEditor)this.model.cellEditors.get(i);
            ce.setBounds(this.getCellWidth(0), this.getCellRenderer().getCellHeight() * (double)ce.getRowIndex(), this.getCellWidth(1), this.getCellRenderer().getCellHeight());
        }
    }

    public BWidget childAt(Point pt) {
        if (this.dragging) {
            return null;
        }
        return super.childAt(pt);
    }

    void addCellEditor(BWbCellEditor ce) {
        this.model.cellEditors.add(ce);
        this.add(null, (BValue)ce);
    }

    public CellController getCellController() {
        return this.cellController;
    }

    public void setCellController(CellController c) {
        this.installSupport((BTable.TableSupport)this.cellController, (BTable.TableSupport)c);
        this.cellController = c;
    }

    private void installSupport(BTable.TableSupport old, BTable.TableSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.getTable() != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (old != null) {
            old.setTable(null);
        }
        support.setTable((BTable)this);
    }

    protected CellTableContext makeContext(final BWbCellEditor ce) {
        return new CellTableContext(){

            @Override
            public boolean allowAnimate() {
                return true;
            }

            @Override
            public BComponent[] getGroupableComponents() {
                ArrayList<BWidget> arr = new ArrayList<BWidget>();
                arr.addAll(new ArrayList<BWidget>(Arrays.asList(BPxCellTable.this.sheet.getAllWidgets())));
                return arr.toArray(new BComponent[0]);
            }

            @Override
            public void doPaste() {
                BPxCellTable.this.sheet.getCellContext().cellModified(ce);
            }
        };
    }

    private class Model
    extends TableModel {
        private List<BWbCellEditor> cellEditors = new ArrayList<BWbCellEditor>();

        private Model() {
        }

        public int getRowCount() {
            return this.cellEditors.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int col) {
            return "";
        }

        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.cellEditors.get(row).getPropertyName();
                }
                case 1: {
                    return this.cellEditors.get(row);
                }
            }
            throw new IllegalStateException();
        }
    }

    private class CellRenderer
    extends TableCellRenderer {
        private CellRenderer() {
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            return BPxCellTable.this.sheet.getColumnWidth();
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            if (cell.column == 0) {
                super.paintCell(g, cell);
            }
        }
    }

    private class Controller
    extends TableController {
        private Controller() {
        }

        protected void resizeHotspotPressed(BMouseEvent event, int column) {
            BPxCellTable.this.dragging = true;
        }

        protected void resizeHotspotDragged(BMouseEvent event, int column) {
            BPxCellTable[] tables = BPxCellTable.this.sheet.getCellTables();
            for (int i = 0; i < tables.length; ++i) {
                tables[i].setColumnPosition(column, event.getX());
                tables[i].relayoutSync();
            }
        }

        protected void resizeHotspotReleased(BMouseEvent event, int column) {
            BPxCellTable.this.dragging = false;
            BPxCellTable.this.sheet.setColumnWidth(BPxCellTable.this.getCellWidth(0));
            BPxCellTable.this.relayoutSync();
        }

        protected void cellPopup(BMouseEvent event, int row, int column) {
            BWbCellEditor ce = (BWbCellEditor)BPxCellTable.this.model.cellEditors.get(row);
            BMenu menu = BPxCellTable.this.sheet.makePopup(ce, BPxCellTable.this.makeContext(ce));
            Point pnt = BPxCellTable.this.translateToAncestor((BWidget)BPxCellTable.this.sheet, new Point(event.getX(), event.getY()));
            menu.open((BWidget)BPxCellTable.this.sheet, pnt.x, pnt.y);
        }
    }

    private class PxCellController
    extends CellController {
        private PxCellController() {
        }

        public void showCellPopup(BWbCellEditor ce, BMouseEvent event) {
            BMenu menu = BPxCellTable.this.sheet.makePopup(ce, BPxCellTable.this.makeContext(ce));
            Point pnt = ce.translateToAncestor((BWidget)BPxCellTable.this.sheet, new Point(event.getX(), event.getY()));
            menu.open((BWidget)BPxCellTable.this.sheet, pnt.x, pnt.y);
        }
    }
}

