/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.px.editor.fieldeditors;

import com.tridium.px.editor.BPxEditorPane;
import com.tridium.workbench.celleditors.BDoubleCE;
import com.tridium.workbench.celltable.BCellTable;
import javax.baja.converters.BINumericToSimple;
import javax.baja.converters.BNumericToSimpleMap;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BConstrainedPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.celleditor.BWbCellEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"converters:INumericToSimple"})})
@NiagaraActions(value={@NiagaraAction(name="tableSelectionModified"), @NiagaraAction(name="cellTableModified")})
public class BINumericToSimpleFE
extends BWbFieldEditor {
    @Generated
    public static final Action tableSelectionModified = BINumericToSimpleFE.newAction((int)0, null);
    @Generated
    public static final Action cellTableModified = BINumericToSimpleFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BINumericToSimpleFE.class);
    BCellTable table;
    TableSelection tableSel;
    BCellTable defTable;
    BWbCellEditor defaultCE;
    Type prototype;
    BEdgePane buttonPane = new BEdgePane();
    SyncRanges syncRanges = new SyncRanges((BWidget)this, BPxEditorPane.lexicon());
    BButton btnAdd;
    BButton btnRemove;
    BButton btnUp;
    BButton btnDown;

    @Generated
    public void tableSelectionModified() {
        this.invoke(tableSelectionModified, null, null);
    }

    @Generated
    public void cellTableModified() {
        this.invoke(cellTableModified, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BINumericToSimpleFE() {
        this.table = new BCellTable(new String[]{BINumericToSimpleFE.text("min"), BINumericToSimpleFE.text("max"), BINumericToSimpleFE.text("value")}, new double[]{75.0, 75.0, 75.0});
        this.tableSel = this.table.getSelection();
        this.defTable = new BCellTable(new String[]{BINumericToSimpleFE.text("default")}, new double[]{75.0});
        this.defTable.setOptionsButtonVisible(false);
        this.buttonPane.setLeft((BWidget)new BCheckBox((ToggleCommand)this.syncRanges));
        BConstrainedPane tablePane = new BConstrainedPane((BWidget)this.table);
        tablePane.setMinHeight(150.0);
        tablePane.setMinWidth(300.0);
        BGridPane buttons = new BGridPane(4);
        buttons.setHalign(BHalign.right);
        this.btnAdd = BINumericToSimpleFE.newButton(new Add((BWidget)this));
        this.btnRemove = BINumericToSimpleFE.newButton(new Remove((BWidget)this));
        this.btnUp = BINumericToSimpleFE.newButton(new Up((BWidget)this));
        this.btnDown = BINumericToSimpleFE.newButton(new Down((BWidget)this));
        buttons.add("add", (BValue)this.btnAdd);
        buttons.add("remove", (BValue)this.btnRemove);
        buttons.add("up", (BValue)this.btnUp);
        buttons.add("down", (BValue)this.btnDown);
        this.buttonPane.setCenter((BWidget)buttons);
        BEdgePane e2 = new BEdgePane();
        e2.setCenter((BWidget)tablePane);
        e2.setBottom((BWidget)new BBorderPane((BWidget)this.buttonPane, 3.0, 0.0, 6.0, 0.0));
        BEdgePane edge = new BEdgePane();
        edge.setCenter((BWidget)e2);
        edge.setBottom((BWidget)new BBorderPane((BWidget)this.defTable, 3.0, 0.0, 0.0, 0.0));
        this.setContent((BWidget)edge);
        this.linkTo(null, (BComponent)this.table, (Slot)BCellTable.selectionModified, (Slot)tableSelectionModified);
        this.linkTo(null, (BComponent)this.table, (Slot)BCellTable.modified, (Slot)cellTableModified);
        this.linkTo(null, (BComponent)this.defTable, (Slot)BCellTable.modified, (Slot)cellTableModified);
    }

    public void doTableSelectionModified() {
        int n = this.tableSel.getRow();
        this.btnRemove.setEnabled(n != -1);
        this.btnUp.setEnabled(n != -1 && n != 0);
        this.btnDown.setEnabled(n != -1 && n != this.table.getRowCount() - 1);
    }

    public void doCellTableModified() {
        this.checkSync();
        this.setModified();
    }

    protected void doLoadValue(BObject value, Context cx) {
        BINumericToSimple conv = (BINumericToSimple)value;
        BNumericToSimpleMap map = conv.getMap();
        BSimple def = map.getDefault();
        double[] mins = map.getMinimums();
        double[] maxs = map.getMaximums();
        BSimple[] values = map.getValues();
        if (def == null) {
            if (values.length == 0) {
                throw new IllegalStateException();
            }
            this.prototype = values[0].getType();
            def = (BSimple)this.prototype.getInstance();
        } else {
            this.prototype = def.getType();
        }
        this.table.clearRows();
        for (int i = 0; i < mins.length; ++i) {
            BDoubleCE minCe = new BDoubleCE();
            BDoubleCE maxCe = new BDoubleCE();
            BWbCellEditor valCe = BWbCellEditor.makeFor((BObject)values[i]);
            minCe.loadValue((BObject)BDouble.make((double)mins[i]));
            maxCe.loadValue((BObject)BDouble.make((double)maxs[i]));
            valCe.loadValue((BObject)values[i]);
            this.table.addRow(new BWbCellEditor[]{minCe, maxCe, valCe});
        }
        boolean flag = true;
        for (int i = 0; i < maxs.length - 1; ++i) {
            if (mins[i + 1] == maxs[i]) continue;
            flag = false;
            break;
        }
        this.syncRanges.setSelected(flag);
        this.defaultCE = BWbCellEditor.makeFor((BObject)def);
        this.defaultCE.loadValue((BObject)def);
        this.defTable.clearRows();
        this.defTable.addRow(new BWbCellEditor[]{this.defaultCE});
        this.relayout();
    }

    protected BObject doSaveValue(BObject value, Context cx) {
        try {
            BINumericToSimple conv = (BINumericToSimple)value;
            BSimple def = (BSimple)this.defaultCE.saveValue();
            int len = this.table.getRowCount();
            double[] mins = new double[len];
            double[] maxs = new double[len];
            BSimple[] vals = new BSimple[len];
            for (int i = 0; i < len; ++i) {
                BWbCellEditor[] row = this.table.getRowCells(i);
                mins[i] = ((BDouble)row[0].saveValue()).getDouble();
                maxs[i] = ((BDouble)row[1].saveValue()).getDouble();
                vals[i] = (BSimple)row[2].saveValue();
            }
            conv.setMap(BNumericToSimpleMap.make((double[])mins, (double[])maxs, (BSimple[])vals, (BSimple)def));
            return value;
        }
        catch (Exception e) {
            throw new BajaRuntimeException((Throwable)e);
        }
    }

    private BWbCellEditor[] makeRow() {
        BSimple val = (BSimple)this.prototype.getInstance();
        BDoubleCE minCe = new BDoubleCE();
        BDoubleCE maxCe = new BDoubleCE();
        BWbCellEditor valCe = BWbCellEditor.makeFor((BObject)val);
        minCe.loadValue((BObject)BDouble.make((double)0.0));
        maxCe.loadValue((BObject)BDouble.make((double)0.0));
        valCe.loadValue((BObject)val);
        return new BWbCellEditor[]{minCe, maxCe, valCe};
    }

    private void checkSync() {
        int len = this.table.getRowCount();
        for (int r = 0; r < len - 1; ++r) {
            BDoubleCE max = (BDoubleCE)this.table.getRowCells(r)[1];
            if (this.syncRanges.isSelected()) {
                max.setReadonly(true);
                BDoubleCE min = (BDoubleCE)this.table.getRowCells(r + 1)[0];
                try {
                    max.loadValue(min.saveValue());
                    continue;
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            max.setReadonly(false);
        }
        if (len > 0) {
            BDoubleCE max = (BDoubleCE)this.table.getRowCells(len - 1)[1];
            max.setReadonly(false);
        }
        this.repaint();
    }

    private static BButton newButton(Command cmd) {
        BButton b = new BButton(cmd, true, true);
        b.setHalign(BHalign.left);
        return b;
    }

    static String text(String s) {
        return BPxEditorPane.text("fieldeditors." + s);
    }

    class SyncRanges
    extends ToggleCommand {
        SyncRanges(BWidget owner, Lexicon lexicon) {
            super(owner, lexicon, "commands.syncRanges");
        }

        public CommandArtifact doInvoke() {
            BINumericToSimpleFE.this.setModified();
            BINumericToSimpleFE.this.checkSync();
            return null;
        }
    }

    class Down
    extends Command {
        Down(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "commands.down");
        }

        public CommandArtifact doInvoke() {
            int n = BINumericToSimpleFE.this.tableSel.getRow();
            if (n == -1 || n == BINumericToSimpleFE.this.table.getRowCount() - 1) {
                throw new IllegalStateException();
            }
            BWbCellEditor[] row = BINumericToSimpleFE.this.table.getRowCells(n);
            BINumericToSimpleFE.this.table.removeRow(n);
            BINumericToSimpleFE.this.table.insertRow(n + 1, row);
            BINumericToSimpleFE.this.tableSel.deselectAll();
            BINumericToSimpleFE.this.tableSel.select(n + 1);
            BINumericToSimpleFE.this.table.relayout();
            BINumericToSimpleFE.this.checkSync();
            BINumericToSimpleFE.this.setModified();
            return null;
        }
    }

    class Up
    extends Command {
        Up(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "commands.up");
        }

        public CommandArtifact doInvoke() {
            int n = BINumericToSimpleFE.this.tableSel.getRow();
            if (n == -1 || n == 0) {
                throw new IllegalStateException();
            }
            BWbCellEditor[] row = BINumericToSimpleFE.this.table.getRowCells(n);
            BINumericToSimpleFE.this.table.removeRow(n);
            BINumericToSimpleFE.this.table.insertRow(n - 1, row);
            BINumericToSimpleFE.this.tableSel.deselectAll();
            BINumericToSimpleFE.this.tableSel.select(n - 1);
            BINumericToSimpleFE.this.table.relayout();
            BINumericToSimpleFE.this.checkSync();
            BINumericToSimpleFE.this.setModified();
            return null;
        }
    }

    class Remove
    extends Command {
        Remove(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "commands.remove");
        }

        public CommandArtifact doInvoke() {
            int n = BINumericToSimpleFE.this.tableSel.getRow();
            if (n == -1) {
                throw new IllegalStateException();
            }
            BINumericToSimpleFE.this.table.removeRow(n);
            BINumericToSimpleFE.this.tableSel.deselectAll();
            int len = BINumericToSimpleFE.this.table.getRowCount();
            if (len > 0) {
                BINumericToSimpleFE.this.tableSel.select(n == len ? n - 1 : n);
            }
            BINumericToSimpleFE.this.table.relayout();
            BINumericToSimpleFE.this.checkSync();
            BINumericToSimpleFE.this.setModified();
            return null;
        }
    }

    class Add
    extends Command {
        Add(BWidget owner) {
            super(owner, BPxEditorPane.lexicon(), "commands.add");
        }

        public CommandArtifact doInvoke() {
            BINumericToSimpleFE.this.table.addRow(BINumericToSimpleFE.this.makeRow());
            BINumericToSimpleFE.this.tableSel.deselectAll();
            BINumericToSimpleFE.this.tableSel.select(BINumericToSimpleFE.this.table.getRowCount() - 1);
            BINumericToSimpleFE.this.table.relayout();
            int len = BINumericToSimpleFE.this.table.getRowCount();
            if (BINumericToSimpleFE.this.syncRanges.isSelected() && len > 1) {
                BDoubleCE max = (BDoubleCE)BINumericToSimpleFE.this.table.getRowCells(len - 2)[1];
                BDoubleCE min = (BDoubleCE)BINumericToSimpleFE.this.table.getRowCells(len - 1)[0];
                try {
                    min.loadValue(max.saveValue());
                }
                catch (Exception e) {
                    throw new BajaRuntimeException((Throwable)e);
                }
            }
            BINumericToSimpleFE.this.checkSync();
            BINumericToSimpleFE.this.setModified();
            BINumericToSimpleFE.this.btnAdd.requestFocus();
            return null;
        }
    }
}

