/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.util;

import com.tridium.rdb.jdbc.trans.BSqlType;
import com.tridium.rdb.util.BRdbmsUpdateJob;
import com.tridium.rdb.util.BRdbmsUpdater;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public abstract class BUnicodeUpdateJob
extends BRdbmsUpdateJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BUnicodeUpdateJob.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BUnicodeUpdateJob() {
    }

    public BUnicodeUpdateJob(BRdbmsUpdater updater) {
        super(updater);
    }

    @Override
    protected void updateTable(String tableName) throws SQLException {
        String columnName2;
        String sql;
        this.log().message("Updating table " + tableName);
        HashMap<String, String> indexToColumnMap = new HashMap<String, String>();
        this.log().message("Dropping indexes on columns");
        try (ResultSet rs = this.metadata.getIndexInfo(null, null, tableName, false, false);){
            while (rs.next()) {
                String indexName = rs.getString("INDEX_NAME");
                if (indexName == null || !indexName.startsWith("IDX_")) continue;
                indexToColumnMap.put(indexName, rs.getString("COLUMN_NAME"));
                sql = this.dialect.makeDropIndexSql(indexName, tableName);
                this.statement.execute(sql);
                this.log().message("Dropped index " + indexName + "on table " + tableName);
            }
        }
        this.log().message("Indexes on table " + tableName + " dropped");
        this.log().message("Updating VARCHAR columns to Unicode");
        rs = this.metadata.getColumns(null, null, tableName, null);
        var4_4 = null;
        try {
            while (rs.next()) {
                columnName2 = rs.getString("COLUMN_NAME");
                String columnType = rs.getString("TYPE_NAME").toUpperCase();
                int columnWidth = rs.getInt("COLUMN_SIZE");
                if (!columnType.startsWith("VARCHAR")) continue;
                String sql2 = this.dialect.makeAlterColumnTypeSql(tableName, columnName2, BSqlType.sqlNVarchar, columnWidth);
                this.statement.execute(sql2);
            }
        }
        catch (Throwable columnName2) {
            var4_4 = columnName2;
            throw columnName2;
        }
        finally {
            if (rs != null) {
                if (var4_4 != null) {
                    try {
                        rs.close();
                    }
                    catch (Throwable columnName2) {
                        var4_4.addSuppressed(columnName2);
                    }
                } else {
                    rs.close();
                }
            }
        }
        this.log().message("Columns updated");
        this.log().message("Reconstructing indexes on " + tableName);
        Iterator it = indexToColumnMap.keySet().iterator();
        while (it.hasNext()) {
            String indexName = ((String)it.next()).toString();
            columnName2 = ((String)indexToColumnMap.get(indexName)).toString();
            sql = "CREATE INDEX " + indexName + " ON " + tableName + "(" + columnName2 + ")";
            this.statement.execute(sql);
            this.log().message("Index " + indexName + " created on " + tableName + "." + columnName2);
        }
        this.log().message("Indexes reconstructed");
        this.log().success("Updates to table " + tableName + " complete");
    }
}

