/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.history;

import com.tridium.nre.util.tuple.Pair;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.history.RdbmsHistoryUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.sys.BComponent;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BRdbmsMigrateIndexesJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsMigrateIndexesJob.class);
    private static final Logger LOG = Logger.getLogger("rdb");
    private BRdbmsHistoryDeviceExt deviceExt;
    private BRdbms rdbms;
    private Connection connection;
    private BRdbmsDeprecatedDialect dialect;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BRdbmsMigrateIndexesJob() {
    }

    public BRdbmsMigrateIndexesJob(BRdbmsHistoryDeviceExt deviceExt) {
        this.deviceExt = deviceExt;
        this.rdbms = (BRdbms)deviceExt.getDevice();
        this.dialect = BRdbmsDeprecatedDialect.make(this.rdbms);
    }

    public BOrd submit(Context cx) {
        BComponent jobService = (BComponent)BJobService.getService();
        BJob[] jobs = (BJob[])jobService.getChildren(BRdbmsMigrateIndexesJob.class);
        if (jobs != null) {
            for (int i = jobs.length - 1; i >= 0; --i) {
                BRdbmsMigrateIndexesJob indexJob = (BRdbmsMigrateIndexesJob)jobs[i];
                if (!indexJob.isAlive() || !indexJob.deviceExt.equals((Object)this.deviceExt)) continue;
                throw new LocalizableRuntimeException("rdb", "rdbmsMigrateIndexesJob.jobAlreadyRunning");
            }
        }
        return super.submit(cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Context cx) throws Exception {
        if (this.rdbms == null) {
            throw new IllegalStateException("Must submit through the RdbmsHistoryDeviceExt migrate action");
        }
        try {
            this.connection = this.rdbms.getConnection();
            this.log().start("rdb", "rdbmsMigrateIndexesJob.jobStart", new String[]{this.deviceExt.toDisplayPathString(cx)});
            String metaTableName = RdbmsHistoryUtil.getMetaTableName(this.rdbms);
            List<RdbmsHistoryUtil.TableNameIdHistory> tableNameAndIds = RdbmsHistoryUtil.getTableNamesFromMetaRecord(this.connection, metaTableName, this.rdbms.getExportMode());
            String size = String.valueOf(tableNameAndIds.size());
            this.log().message("rdb", "rdbmsMigrateIndexesJob.totalTablesForMigration", size);
            int count = 0;
            int failCount = 0;
            for (RdbmsHistoryUtil.TableNameIdHistory tableNameAndId : tableNameAndIds) {
                block14: {
                    if (this.getJobState() == BJobState.canceling) {
                        throw new JobCancelException();
                    }
                    ++count;
                    try {
                        if (this.deleteOldIndex(tableNameAndId.tableName) || !this.deviceExt.getUseLastTimestamp() || this.deviceExt.getAlwaysCreateIndexForNewTables()) {
                            Pair<String, String> indexNameAndColumns = this.dialect.getNewIndexNameAndColumns(tableNameAndId.tableId);
                            if (RdbmsHistoryUtil.indexAlreadyExists(this.connection, tableNameAndId.tableName, (String)indexNameAndColumns.getFirst())) {
                                this.log().message("rdb", "rdbmsMigrateIndexesJob.tableIndexAlreadyMigrated", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                            } else {
                                RdbmsHistoryUtil.createIndex(this.connection, this.dialect, tableNameAndId.tableName, indexNameAndColumns);
                                this.log().message("rdb", "rdbmsMigrateIndexesJob.tableIndexMigrated", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                            }
                        } else {
                            this.log().message("rdb", "rdbmsMigrateIndexesJob.tableNotEligible", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                        }
                    }
                    catch (Exception e) {
                        ++failCount;
                        this.log().failed("rdb", "rdbmsMigrateIndexesJob.failedTableMigration", new String[]{String.valueOf(count), size, tableNameAndId.historyIdOrRecType});
                        if (!LOG.isLoggable(Level.WARNING)) break block14;
                        LOG.log(Level.WARNING, "Exception while migrating the index for " + tableNameAndId.historyIdOrRecType, e);
                    }
                }
                this.progress((int)((double)count / (double)tableNameAndIds.size() * 100.0));
            }
            if (failCount > 0) {
                this.log().failed("rdb", "rdbmsMigrateIndexesJob.jobFailed", new String[]{String.valueOf(failCount), size});
                throw new LocalizableRuntimeException("rdb", "rdbmsMigrateIndexesJob.jobFailed", new Object[]{String.valueOf(failCount), size});
            }
        }
        finally {
            if (this.connection != null) {
                this.connection.close();
            }
        }
    }

    private boolean deleteOldIndex(String tableName) throws SQLException {
        if (this.rdbms.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId)) {
            return false;
        }
        Set<String> oldIndexes = RdbmsHistoryUtil.getOldIndexName(this.connection, tableName);
        boolean droppedIndexes = false;
        for (String oldIndex : oldIndexes) {
            droppedIndexes = true;
            RdbmsHistoryUtil.dropIndex(this.connection, this.dialect, tableName, oldIndex);
        }
        return droppedIndexes;
    }
}

