/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.history;

import com.tridium.nre.diagnostics.DiagnosticUtil;
import com.tridium.rdb.BRdbmsDeprecatedDialect;
import com.tridium.rdb.history.RdbmsHistoryUtil;
import com.tridium.sys.station.BStationScheme;
import java.io.IOException;
import java.security.AccessController;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.history.BArchiveDescriptor;
import javax.baja.driver.history.BArchiveFolder;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.util.BDescriptor;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.HistoryCursor;
import javax.baja.history.db.BArchiveHistoryProvider;
import javax.baja.license.Feature;
import javax.baja.license.FeatureNotLicensedException;
import javax.baja.naming.BOrd;
import javax.baja.naming.BSlotScheme;
import javax.baja.naming.OrdQuery;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryExport;
import javax.baja.rdb.history.BRdbmsHistoryExportMode;
import javax.baja.security.BPassword;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BHandleScheme;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BComponentEventMask;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BStation;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.sys.TypeSubscriber;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.ICoalesceable;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;
import javax.baja.util.QueueFullException;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ordToRdbms", type="BOrd", defaultValue="BOrd.DEFAULT", flags=64, facets={@Facet(name="BFacets.TARGET_TYPE", value="BString.make(\"rdb:Rdbms\")")}), @NiagaraProperty(name="useDefaultFetchSize", type="boolean", defaultValue="true", facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(rdb:useDefaultFetchSize.true)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(rdb:useDefaultFetchSize.false)%\")")}), @NiagaraProperty(name="customFetchSize", type="int", defaultValue="0", facets={@Facet(name="BFacets.MIN", value="0")}), @NiagaraProperty(name="fetchSizeInUse", type="int", defaultValue="0", flags=67)})
@NiagaraAction(name="closeExpiredCursors", flags=20)
public final class BRdbArchiveHistoryProvider
extends BArchiveHistoryProvider {
    @Generated
    public static final Property ordToRdbms = BRdbArchiveHistoryProvider.newProperty((int)64, (BValue)BOrd.DEFAULT, (BFacets)BFacets.make((String)"targetType", (BIDataValue)BString.make((String)"rdb:Rdbms")));
    @Generated
    public static final Property useDefaultFetchSize = BRdbArchiveHistoryProvider.newProperty((int)0, (boolean)true, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(rdb:useDefaultFetchSize.true)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(rdb:useDefaultFetchSize.false)%"))));
    @Generated
    public static final Property customFetchSize = BRdbArchiveHistoryProvider.newProperty((int)0, (int)0, (BFacets)BFacets.make((String)"min", (int)0));
    @Generated
    public static final Property fetchSizeInUse = BRdbArchiveHistoryProvider.newProperty((int)67, (int)0, null);
    @Generated
    public static final Action closeExpiredCursors = BRdbArchiveHistoryProvider.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbArchiveHistoryProvider.class);
    private static final long INACTIVE_CURSOR_TIMEOUT;
    private static final long NANOSECS_TO_MILLISECS = 1000000L;
    private static final Set<String> VALID_RDBMS_ORD_SCHEMES;
    private static final Lexicon LEXICON;
    private static final String UNLICENSED;
    private static final String RDBMS_NOT_CONFIGURED;
    private static final String RDBMS_MISCONFIGURED;
    private static final String[] EXTRA_FIELDS_BY_HISTORY_ID;
    private static final String[] EXTRA_FIELDS_BY_HISTORY_TYPE;
    private static final Pattern QUESTION_MARK_REGEX;
    private static final Logger LOG;
    private static final Logger DIAGNOSTIC_LOG_QUERY;
    private static final Logger DIAGNOSTIC_LOG_CURSOR;
    private static final Logger DIAGNOSTIC_LOG_CONTEXT;
    private static final Map<BRdbms, Map<BHistoryId, List<BRdbmsHistoryExport>>> RDBMS_EXPORT_MAP;
    private static RdbmsTypeSubscriber rdbmsTypeSubscriber;
    private final Map<RdbArchiveRecordCursor, Integer> openCursors = new ConcurrentHashMap<RdbArchiveRecordCursor, Integer>();
    private volatile Clock.Ticket inactiveCursorTicket;
    private BOrd lastOrdToRdbms;
    private volatile Set<String> invalidRdbmsOrdSchemes;

    @Generated
    public BOrd getOrdToRdbms() {
        return (BOrd)this.get(ordToRdbms);
    }

    @Generated
    public void setOrdToRdbms(BOrd v) {
        this.set(ordToRdbms, (BValue)v, null);
    }

    @Generated
    public boolean getUseDefaultFetchSize() {
        return this.getBoolean(useDefaultFetchSize);
    }

    @Generated
    public void setUseDefaultFetchSize(boolean v) {
        this.setBoolean(useDefaultFetchSize, v, null);
    }

    @Generated
    public int getCustomFetchSize() {
        return this.getInt(customFetchSize);
    }

    @Generated
    public void setCustomFetchSize(int v) {
        this.setInt(customFetchSize, v, null);
    }

    @Generated
    public int getFetchSizeInUse() {
        return this.getInt(fetchSizeInUse);
    }

    @Generated
    public void setFetchSizeInUse(int v) {
        this.setInt(fetchSizeInUse, v, null);
    }

    @Generated
    public void closeExpiredCursors() {
        this.invoke(closeExpiredCursors, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public boolean isLikelyToContainArchivedHistory(BHistoryConfig historyConfig, Context context) {
        Optional<BRdbms> rdbmsOptional = this.getRdbms();
        if (rdbmsOptional.isPresent()) {
            BRdbms rdbms = rdbmsOptional.get();
            return BRdbArchiveHistoryProvider.findExportForHistory(rdbms, historyConfig) != null;
        }
        return false;
    }

    protected Optional<Cursor<BHistoryRecord>> doTimeQuery(BHistoryConfig historyConfig, BAbsTime startTime, BAbsTime endTime, boolean descending, int limit, Context context) {
        Optional<BRdbms> rdbmsOptional;
        long start = DIAGNOSTIC_LOG_QUERY.isLoggable(Level.FINE) ? Clock.nanoTicks() : -1L;
        String debugSummary = null;
        if (start >= 0L || LOG.isLoggable(Level.FINE)) {
            String ascOrDesc = descending ? "DESC" : "ASC";
            debugSummary = historyConfig.getId() + " from " + startTime + " to " + endTime + ", " + ascOrDesc + ", limit=" + limit + ", cx=" + context;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.toPathString() + " processing RDB archive time query: " + debugSummary);
                if (start < 0L) {
                    start = Clock.nanoTicks();
                }
            }
        }
        if (!(rdbmsOptional = this.getRdbms()).isPresent()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.toPathString() + " failed to process RDB archive time query because the RDBMS is not available.");
            }
            return Optional.empty();
        }
        BRdbms rdbms = rdbmsOptional.get();
        Connection conn = null;
        Statement preparedStmt = null;
        ResultSet rs = null;
        try {
            String[] extraFields;
            BRdbmsDeprecatedDialect dialect;
            String rdbHistoryName;
            conn = BRdbArchiveHistoryProvider.getConnection(rdbms, historyConfig);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Rdb connection established for archive time query...");
            }
            if ((rdbHistoryName = BRdbArchiveHistoryProvider.getArchiveHistoryTableName(rdbms, dialect = BRdbmsDeprecatedDialect.make(rdbms), conn, historyConfig)) == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Archived data for history " + historyConfig.getId() + " not found in " + this.toPathString());
                }
                conn.close();
                Optional<Cursor<BHistoryRecord>> optional = Optional.empty();
                return optional;
            }
            BHistoryRecord templateRecord = historyConfig.makeRecord();
            Property[] recordProperties = templateRecord.getPropertiesArray();
            boolean exportingByType = false;
            switch (rdbms.getExportMode().getOrdinal()) {
                case 0: {
                    extraFields = EXTRA_FIELDS_BY_HISTORY_ID;
                    break;
                }
                case 1: {
                    exportingByType = true;
                    extraFields = EXTRA_FIELDS_BY_HISTORY_TYPE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported RDB export mode");
                }
            }
            String[] propertiesToColumnNames = dialect.getTemplateColumnNames(recordProperties, extraFields);
            StringJoiner joinedColumnsToSelect = new StringJoiner(", ");
            for (String propColumnName : propertiesToColumnNames) {
                joinedColumnsToSelect.add(dialect.makeColumnName(propColumnName));
            }
            String selectColumns = joinedColumnsToSelect.toString();
            int limitIncludingBoundaryRec = limit == Integer.MAX_VALUE ? limit : limit + 1;
            String sqlQuery = dialect.makeTimeQuerySql(selectColumns, rdbHistoryName, descending, limitIncludingBoundaryRec);
            preparedStmt = conn.prepareStatement(sqlQuery, 1003, 1007);
            int parameterIndex = 1;
            if (exportingByType) {
                preparedStmt.setString(parameterIndex++, historyConfig.getId().toString());
            }
            long startMillis = startTime.getMillis();
            long endMillis = endTime.isNull() ? BAbsTime.END_OF_TIME.getMillis() : endTime.getMillis();
            Timestamp startTimestamp = null;
            Timestamp endTimestamp = null;
            if (dialect.supportsTimestamp()) {
                startTimestamp = new Timestamp(startMillis);
                endTimestamp = new Timestamp(endMillis);
                Calendar tsCalender = dialect.getCalendarForTimestamps();
                preparedStmt.setTimestamp(parameterIndex++, startTimestamp, tsCalender);
                preparedStmt.setTimestamp(parameterIndex, endTimestamp, tsCalender);
            } else {
                preparedStmt.setLong(parameterIndex++, startMillis);
                preparedStmt.setLong(parameterIndex, endMillis);
            }
            if (LOG.isLoggable(Level.FINE)) {
                String debugSql = exportingByType ? QUESTION_MARK_REGEX.matcher(sqlQuery).replaceFirst(historyConfig.getId().toString()) : sqlQuery;
                debugSql = QUESTION_MARK_REGEX.matcher(debugSql).replaceFirst(startTimestamp != null ? startTimestamp.toString() : Long.toString(startMillis));
                debugSql = QUESTION_MARK_REGEX.matcher(debugSql).replaceFirst(endTimestamp != null ? endTimestamp.toString() : Long.toString(endMillis));
                LOG.fine("Rdb SQL query to execute: " + debugSql);
            }
            rs = preparedStmt.executeQuery();
            rs.setFetchSize(this.computeFetchSize(rdbms));
            preparedStmt.closeOnCompletion();
            RdbArchiveRecordCursor archiveCursor = new RdbArchiveRecordCursor(conn, rs, historyConfig, templateRecord, recordProperties, rdbms, dialect, selectColumns, rdbHistoryName, startTime, endTime, descending, limit, debugSummary, this.openCursors);
            this.openCursors.put(archiveCursor, 0);
            Optional<Cursor<BHistoryRecord>> optional = Optional.of(archiveCursor);
            return optional;
        }
        catch (Throwable t) {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (preparedStmt != null) {
                try {
                    preparedStmt.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "RDB archive time query failed for " + this.toPathString(), t);
            }
            throw new BajaRuntimeException("RDB archive time query failed for " + this.toPathString(), t);
        }
        finally {
            if (start > -1L) {
                long duration = Clock.nanoTicks() - start;
                if (DIAGNOSTIC_LOG_QUERY.isLoggable(Level.FINE)) {
                    DiagnosticUtil.completeDuration((long)duration, (String)"RdbArchiveHistoryProvider.doTimeQuery", (Object)debugSummary);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Took " + (duration /= 1000000L) + " ms to execute RDB archive time query: " + debugSummary);
                }
            }
        }
    }

    public void doCloseExpiredCursors() {
        if (!this.isRunning()) {
            return;
        }
        try {
            this.openCursors.entrySet().removeIf(entry -> {
                RdbArchiveRecordCursor cursor = (RdbArchiveRecordCursor)entry.getKey();
                int lastCount = (Integer)entry.getValue();
                if (lastCount != cursor.counter) {
                    entry.setValue(cursor.counter);
                    cursor.lastActiveTicks = Clock.ticks();
                } else if (Clock.ticks() - cursor.lastActiveTicks >= INACTIVE_CURSOR_TIMEOUT) {
                    cursor.close();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.warning("An inactive Rdb Archive Record Cursor was found for " + this.toPathString() + ". The cursor was closed (via timeout) in order to free the underlying RDBMS Connection back to the pool.");
                    }
                    return true;
                }
                return false;
            });
        }
        catch (Throwable t) {
            LOG.log(Level.WARNING, "Unexpected exception while checking for expired RdbArchiveRecordCursors in " + this.toPathString(), t);
        }
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        if (closeExpiredCursors.equals(action)) {
            if (this.isRunning() && rdbmsTypeSubscriber != null && !this.openCursors.isEmpty()) {
                rdbmsTypeSubscriber.runAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
            }
            return null;
        }
        return super.post(action, argument, cx);
    }

    public void started() {
        this.lastOrdToRdbms = this.getOrdToRdbms();
        this.invalidRdbmsOrdSchemes = null;
        this.getInvalidRdbmsOrdSchemes();
        if (Sys.isStationStarted()) {
            this.stationStarted();
        }
        this.computeFetchSize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stationStarted() {
        this.inactiveCursorTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.make((long)INACTIVE_CURSOR_TIMEOUT), (Action)closeExpiredCursors, null);
        String[] stringArray = EXTRA_FIELDS_BY_HISTORY_ID;
        synchronized (EXTRA_FIELDS_BY_HISTORY_ID) {
            if (rdbmsTypeSubscriber == null) {
                rdbmsTypeSubscriber = new RdbmsTypeSubscriber(this.getComponentSpace());
                rdbmsTypeSubscriber.setMask(BComponentEventMask.make((int[])new int[]{19, 20, 2, 0}));
                rdbmsTypeSubscriber.subscribe(new Type[]{BRdbms.TYPE, BRdbmsHistoryExport.TYPE, BRdbmsHistoryDeviceExt.TYPE, BArchiveFolder.TYPE}, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            rdbmsTypeSubscriber.scheduleMapUpdate();
            this.getRdbms();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopped() {
        this.lastOrdToRdbms = null;
        this.invalidRdbmsOrdSchemes = null;
        if (this.inactiveCursorTicket != null) {
            this.inactiveCursorTicket.cancel();
        }
        this.openCursors.keySet().removeIf(cursor -> {
            cursor.close();
            return true;
        });
        this.openCursors.clear();
        Optional<BRdbms> rdbmsOptional = this.resolveRdbms(false);
        if (rdbmsOptional.isPresent()) {
            BRdbms rdbms = rdbmsOptional.get();
            RDBMS_EXPORT_MAP.remove((Object)rdbms);
        }
        boolean hasRunningRdbArchiveHistoryProvider = false;
        BComponent parentComponent = (BComponent)this.getParent();
        if (parentComponent == null) {
            return;
        }
        try (SlotCursor cursor2 = parentComponent.getProperties();){
            while (cursor2.next(BRdbArchiveHistoryProvider.class)) {
                BComponent provider = cursor2.get().asComponent();
                if (provider == this || !provider.isRunning()) continue;
                hasRunningRdbArchiveHistoryProvider = true;
                break;
            }
        }
        if (hasRunningRdbArchiveHistoryProvider) return;
        String[] stringArray = EXTRA_FIELDS_BY_HISTORY_ID;
        synchronized (EXTRA_FIELDS_BY_HISTORY_ID) {
            if (rdbmsTypeSubscriber != null) {
                rdbmsTypeSubscriber.unsubscribeAll();
                rdbmsTypeSubscriber.stopWorker();
                rdbmsTypeSubscriber = null;
            }
            // ** MonitorExit[var4_5] (shouldn't be in output)
            RDBMS_EXPORT_MAP.clear();
            return;
        }
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (ordToRdbms.equals(prop)) {
            block12: {
                Set<String> invalidOrdSchemes = this.invalidRdbmsOrdSchemes;
                if (this.lastOrdToRdbms != null && !this.lastOrdToRdbms.isNull() && (invalidOrdSchemes == null || invalidOrdSchemes.isEmpty())) {
                    try {
                        BRdbms rdbms = (BRdbms)this.lastOrdToRdbms.get();
                        RDBMS_EXPORT_MAP.remove((Object)rdbms);
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINE)) break block12;
                        LOG.log(Level.FINE, "Could not resolve old OrdToRdbms in cache update check: " + this.lastOrdToRdbms, e);
                    }
                }
            }
            this.lastOrdToRdbms = this.getOrdToRdbms();
            this.invalidRdbmsOrdSchemes = null;
            if (rdbmsTypeSubscriber != null) {
                rdbmsTypeSubscriber.scheduleMapUpdate();
            }
            this.computeFetchSize(this.resolveRdbms(false).orElse(null));
        } else if (status.equals(prop)) {
            Optional<BRdbms> rdbmsOptional = this.resolveRdbms(false);
            if (!this.isOperational() && rdbmsOptional.isPresent()) {
                BRdbms rdbms = rdbmsOptional.get();
                RDBMS_EXPORT_MAP.remove((Object)rdbms);
            }
            if (rdbmsTypeSubscriber != null) {
                rdbmsTypeSubscriber.scheduleMapUpdate();
            }
        } else if (useDefaultFetchSize.equals(prop) || customFetchSize.equals(prop)) {
            this.computeFetchSize(null);
        }
    }

    protected final void checkProviderLicense() throws FeatureNotLicensedException {
        try {
            Feature rdbHistoryArchiveFeature = Sys.getLicenseManager().getFeature("tridium", "rdbHistoryArchive");
            if (rdbHistoryArchiveFeature == null) {
                throw new FeatureNotLicensedException(UNLICENSED);
            }
            rdbHistoryArchiveFeature.check();
        }
        catch (Exception e) {
            throw new FeatureNotLicensedException(UNLICENSED);
        }
    }

    public void spy(SpyWriter out) throws Exception {
        if (this.isRunning()) {
            out.startProps();
            out.prop((Object)"Open Rdb Archive Record Cursors", this.openCursors.size());
            out.trTitle((Object)"History ID to RdbmsHistoryExport Cache", 2);
            out.prop((Object)"Size (Rdbms instances cached)", RDBMS_EXPORT_MAP.size());
            for (Map.Entry<BRdbms, Map<BHistoryId, List<BRdbmsHistoryExport>>> entry : RDBMS_EXPORT_MAP.entrySet()) {
                out.prop((Object)("ID to Export Count for " + entry.getKey().toPathString()), entry.getValue().size());
            }
            out.endProps();
        }
        super.spy(out);
    }

    private Optional<BRdbms> getRdbms() {
        if (!this.isRunning() || !this.getEnabled()) {
            return Optional.empty();
        }
        return this.resolveRdbms(true);
    }

    private Optional<BRdbms> resolveRdbms(boolean skipWhenRdbmsNonoperational) {
        BOrd rdbmsOrd = this.getOrdToRdbms();
        if (rdbmsOrd.isNull()) {
            this.configFail(RDBMS_NOT_CONFIGURED);
            return Optional.empty();
        }
        Set<String> invalidOrdSchemes = this.getInvalidRdbmsOrdSchemes();
        if (!invalidOrdSchemes.isEmpty()) {
            String invalidOrdSchemesStr = String.join((CharSequence)", \n", invalidOrdSchemes);
            this.configFail(LEXICON.getText("rdb.archiveHistoryProvider.invalidOrd", new Object[]{invalidOrdSchemesStr}));
            return Optional.empty();
        }
        BRdbms rdbms = null;
        try {
            rdbms = (BRdbms)rdbmsOrd.get((BObject)this);
            if (!rdbms.isRunning() || rdbms.isDisabled() || rdbms.isDown() || rdbms.isFault()) {
                String rdbmsFaultCause = rdbms.getFaultCause();
                String msg = rdbmsFaultCause.isEmpty() ? rdbms.getStatus().toString() : rdbmsFaultCause;
                this.configFail(LEXICON.getText("rdb.archiveHistoryProvider.rdbmsUnoperational", new Object[]{msg}));
                if (skipWhenRdbmsNonoperational) {
                    rdbms = null;
                }
            } else {
                this.configOk();
            }
        }
        catch (Exception e) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Cannot resolve Rdbms", e);
            }
            this.configFail(RDBMS_MISCONFIGURED);
        }
        return Optional.ofNullable(rdbms);
    }

    private Set<String> getInvalidRdbmsOrdSchemes() {
        Set<String> invalidOrdSchemes = this.invalidRdbmsOrdSchemes;
        if (invalidOrdSchemes != null) {
            return invalidOrdSchemes;
        }
        invalidOrdSchemes = Collections.emptySet();
        BOrd rdbmsOrd = this.getOrdToRdbms();
        if (!rdbmsOrd.isNull()) {
            OrdQuery[] ordQueries;
            for (OrdQuery ordQuery : ordQueries = rdbmsOrd.parse()) {
                String ordScheme = ordQuery.getScheme();
                if (VALID_RDBMS_ORD_SCHEMES.contains(ordScheme)) continue;
                if (invalidOrdSchemes.isEmpty()) {
                    invalidOrdSchemes = new LinkedHashSet();
                }
                invalidOrdSchemes.add(ordScheme);
            }
        }
        this.invalidRdbmsOrdSchemes = invalidOrdSchemes;
        return invalidOrdSchemes;
    }

    private int computeFetchSize(BRdbms rdbms) {
        int fetchSize = 0;
        if (this.getUseDefaultFetchSize()) {
            if (rdbms == null) {
                Optional<BRdbms> rdbmsOptional = this.resolveRdbms(false);
                if (rdbmsOptional.isPresent()) {
                    fetchSize = rdbmsOptional.get().getResultSetFetchSize();
                }
            } else {
                fetchSize = rdbms.getResultSetFetchSize();
            }
        } else {
            fetchSize = this.getCustomFetchSize();
        }
        if (fetchSize < 0) {
            fetchSize = 0;
        }
        this.setFetchSizeInUse(fetchSize);
        return fetchSize;
    }

    private static Connection getConnection(BRdbms rdbms, BHistoryConfig config) throws SQLException {
        BRdbmsHistoryExport matchingExport = BRdbArchiveHistoryProvider.findExportForHistory(rdbms, config);
        if (matchingExport != null) {
            BRdbmsHistoryDeviceExt deviceExt = (BRdbmsHistoryDeviceExt)matchingExport.getDeviceExt();
            String userName = deviceExt.getUserName(rdbms, matchingExport);
            BPassword password = deviceExt.getPassword(rdbms, matchingExport);
            return rdbms.getConnection(userName, password);
        }
        return rdbms.getConnection();
    }

    private static BRdbmsHistoryExport findExportForHistory(BRdbms rdbms, BHistoryConfig config) {
        List<BRdbmsHistoryExport> exports = BRdbArchiveHistoryProvider.getIdToExportMap(rdbms).get(config.getId());
        if (exports == null) {
            return null;
        }
        BRdbmsHistoryExport firstMatchingDisabledExport = null;
        for (BRdbmsHistoryExport export : exports) {
            if (export.getEnabled()) {
                return export;
            }
            if (firstMatchingDisabledExport != null) continue;
            firstMatchingDisabledExport = export;
        }
        return firstMatchingDisabledExport;
    }

    private static Map<BHistoryId, List<BRdbmsHistoryExport>> getIdToExportMap(BRdbms rdbms) {
        return RDBMS_EXPORT_MAP.computeIfAbsent(rdbms, k -> {
            ConcurrentHashMap<BHistoryId, List> idToExportMap = new ConcurrentHashMap<BHistoryId, List>();
            String localStationName = Sys.getStation() != null ? Sys.getStation().getStationName() : null;
            try (SlotCursor cursor = rdbms.getProperties();){
                while (cursor.next(BRdbmsHistoryDeviceExt.class)) {
                    BRdbmsHistoryDeviceExt historyDeviceExt = (BRdbmsHistoryDeviceExt)cursor.get();
                    for (BDescriptor descriptor : historyDeviceExt.getDescriptors()) {
                        if (!(descriptor instanceof BRdbmsHistoryExport)) continue;
                        BRdbmsHistoryExport export = (BRdbmsHistoryExport)descriptor;
                        BHistoryId id = export.getHistoryId();
                        if (localStationName != null) {
                            id = id.fromShorthand(localStationName);
                        }
                        if (id.isNull()) continue;
                        idToExportMap.compute(id, (i, v) -> {
                            if (v == null) {
                                ArrayList<BRdbmsHistoryExport> newList = new ArrayList<BRdbmsHistoryExport>();
                                newList.add(export);
                                return newList;
                            }
                            v.add(export);
                            return v;
                        });
                    }
                }
            }
            return idToExportMap;
        });
    }

    public static String getArchiveHistoryTableName(BRdbms rdbms, BHistoryConfig config) throws SQLException {
        try (Connection conn = BRdbArchiveHistoryProvider.getConnection(rdbms, config);){
            String string = BRdbArchiveHistoryProvider.getArchiveHistoryTableName(rdbms, BRdbmsDeprecatedDialect.make(rdbms), conn, config);
            return string;
        }
    }

    private static String getArchiveHistoryTableName(BRdbms rdbms, BRdbmsDeprecatedDialect dialect, Connection conn, BHistoryConfig config) throws SQLException {
        String metaTableName = RdbmsHistoryUtil.getMetaTableName(rdbms);
        if (!dialect.tableExists(rdbms, conn, metaTableName)) {
            return null;
        }
        boolean exportingById = rdbms.getExportMode().equals((Object)BRdbmsHistoryExportMode.byHistoryId);
        String sql = exportingById || RdbmsHistoryUtil.isNewSchema(conn, metaTableName) ? "SELECT TABLE_NAME FROM " + metaTableName + " WHERE ID_ = '" + RdbmsHistoryUtil.fixQuotes(config.getId().toString()) + '\'' : "SELECT TABLE_NAME FROM " + metaTableName + " WHERE RECORDTYPE = '" + RdbmsHistoryUtil.fixQuotes(config.getRecordType().toString()) + '\'';
        try (Statement stmt = conn.createStatement();
             ResultSet meta = stmt.executeQuery(sql);){
            if (meta.next()) {
                String string = meta.getString(1);
                return string;
            }
        }
        return null;
    }

    static {
        long inactivityTimeout = AccessController.doPrivileged(() -> Long.getLong("niagara.rdbArchiveHistoryCursor.inactivityTimeout", 120000L));
        if (inactivityTimeout <= 0L) {
            inactivityTimeout = 120000L;
        }
        INACTIVE_CURSOR_TIMEOUT = inactivityTimeout;
        VALID_RDBMS_ORD_SCHEMES = Collections.unmodifiableSet(Stream.of(BStationScheme.INSTANCE.getId(), BSlotScheme.INSTANCE.getId(), BHandleScheme.INSTANCE.getId()).collect(Collectors.toSet()));
        LEXICON = Lexicon.make((String)"rdb");
        UNLICENSED = LEXICON.getText("rdb.archiveHistoryProvider.unlicensed");
        RDBMS_NOT_CONFIGURED = LEXICON.getText("rdb.archiveHistoryProvider.notConfigured");
        RDBMS_MISCONFIGURED = LEXICON.getText("rdb.archiveHistoryProvider.misconfigured");
        EXTRA_FIELDS_BY_HISTORY_ID = new String[]{"TRENDFLAGS_TAG", "STATUS_TAG"};
        EXTRA_FIELDS_BY_HISTORY_TYPE = new String[]{"HISTORY_ID", "TRENDFLAGS_TAG", "STATUS_TAG"};
        QUESTION_MARK_REGEX = Pattern.compile("\\?");
        LOG = Logger.getLogger("rdb.archiveHistoryProvider");
        DIAGNOSTIC_LOG_QUERY = Logger.getLogger("diagnostics.RdbArchiveHistoryProvider.query");
        DIAGNOSTIC_LOG_CURSOR = Logger.getLogger("diagnostics.RdbArchiveHistoryProvider.cursor");
        DIAGNOSTIC_LOG_CONTEXT = Logger.getLogger("diagnostics.RdbArchiveHistoryProvider.context");
        RDBMS_EXPORT_MAP = Collections.synchronizedMap(new WeakHashMap());
    }

    private static class RdbmsTypeSubscriber
    extends TypeSubscriber
    implements Runnable,
    ICoalesceable {
        private Worker worker;
        private final CoalesceQueue workQueue = new CoalesceQueue(500);

        RdbmsTypeSubscriber(BComponentSpace space) {
            super(space);
        }

        public void event(BComponentEvent event) {
            block46: {
                int id = event.getId();
                Type type = event.getSourceComponent().getType();
                if (id == 20) {
                    if (type.is(BRdbms.TYPE)) {
                        RDBMS_EXPORT_MAP.remove(event.getSourceComponent());
                        BStation station = Sys.getStation();
                        if (station != null && station.isRunning()) {
                            this.scheduleMapUpdate();
                        }
                    }
                } else if (id == 19) {
                    if (type.is(BRdbmsHistoryExport.TYPE)) {
                        try {
                            BDevice device = ((BDescriptor)event.getSourceComponent()).getDevice();
                            if (device instanceof BRdbms) {
                                RDBMS_EXPORT_MAP.remove(device);
                                this.scheduleMapUpdate();
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.INFO, "Could not update cache for addition of " + event.getSourceComponent().toPathString(), e);
                            } else if (LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "Could not update cache for addition of " + event.getSourceComponent().toPathString());
                            }
                        }
                    }
                } else if (id == 2) {
                    BComponent sourceComponent;
                    BValue oldValue = event.getValue();
                    if (oldValue != null && (oldValue.getType().is(BRdbmsHistoryExport.TYPE) || oldValue.getType().is(BIArchiveFolder.TYPE)) && (sourceComponent = event.getSourceComponent()) instanceof BIArchiveFolder) {
                        try {
                            BDevice device = ((BIArchiveFolder)sourceComponent).getDevice();
                            if (device instanceof BRdbms) {
                                RDBMS_EXPORT_MAP.remove(device);
                                this.scheduleMapUpdate();
                            }
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.INFO, "Could not update cache for removal of " + sourceComponent.toPathString() + '/' + event.getSlotName(), e);
                            } else if (LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "Could not update cache for removal of " + sourceComponent.toPathString() + '/' + event.getSlotName());
                            }
                        }
                    }
                } else if (id == 0) {
                    if (type.is(BRdbmsHistoryExport.TYPE) && BArchiveDescriptor.historyId.equals(event.getSlot())) {
                        BRdbmsHistoryExport export = (BRdbmsHistoryExport)event.getSourceComponent();
                        try {
                            BDevice device = export.getDevice();
                            if (device instanceof BRdbms) {
                                RDBMS_EXPORT_MAP.remove(device);
                                this.scheduleMapUpdate();
                            }
                            break block46;
                        }
                        catch (Exception e) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.log(Level.INFO, "Could not update cache for historyId property change of " + export.toPathString(), e);
                            } else if (LOG.isLoggable(Level.INFO)) {
                                LOG.log(Level.INFO, "Could not update cache for historyId property change of " + export.toPathString());
                            }
                            break block46;
                        }
                    }
                    if (type.is(BRdbms.TYPE) && (BDevice.status.equals(event.getSlot()) || BDevice.faultCause.equals(event.getSlot()))) {
                        try {
                            BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                            try (SlotCursor cursor = historyService.getArchiveHistoryProviders().getProperties();){
                                while (cursor.next(BRdbArchiveHistoryProvider.class)) {
                                    ((BRdbArchiveHistoryProvider)cursor.get()).getRdbms();
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!LOG.isLoggable(Level.WARNING)) break block46;
                            LOG.log(Level.WARNING, "Failed RdbArchiveHistoryProvider status update for change to Rdbms", e);
                        }
                    }
                }
            }
        }

        @Override
        public void run() {
            block18: {
                try {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    BHistoryService historyService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                    try (SlotCursor cursor = historyService.getArchiveHistoryProviders().getProperties();){
                        while (cursor.next(BRdbArchiveHistoryProvider.class)) {
                            BRdbms rdbms;
                            Optional rdbmsOptional;
                            BRdbArchiveHistoryProvider provider = (BRdbArchiveHistoryProvider)cursor.get();
                            if (!provider.isOperational() || !(rdbmsOptional = provider.getRdbms()).isPresent() || !(rdbms = (BRdbms)((Object)rdbmsOptional.get())).isRunning()) continue;
                            BRdbArchiveHistoryProvider.getIdToExportMap(rdbms);
                        }
                    }
                }
                catch (Exception e) {
                    BStation station = Sys.getStation();
                    if (station == null || !station.isRunning()) break block18;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.INFO, "Could not update the cache", e);
                    }
                    LOG.log(Level.INFO, "Could not update the cache");
                }
            }
        }

        public Object getCoalesceKey() {
            return this;
        }

        public ICoalesceable coalesce(ICoalesceable c) {
            return c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopWorker() {
            CoalesceQueue coalesceQueue = this.workQueue;
            synchronized (coalesceQueue) {
                this.workQueue.clear();
                if (this.worker != null) {
                    this.worker.stop();
                    this.worker = null;
                }
            }
        }

        void scheduleMapUpdate() {
            this.runAsync(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void runAsync(Runnable work) {
            CoalesceQueue coalesceQueue = this.workQueue;
            synchronized (coalesceQueue) {
                block6: {
                    if (this.worker == null) {
                        this.worker = new Worker((Worker.ITodo)this.workQueue);
                        this.worker.start("RdbArchiveHistoryProvider_MapWorker");
                    }
                    try {
                        this.workQueue.enqueue((Object)work);
                    }
                    catch (QueueFullException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block6;
                        LOG.log(Level.WARNING, "Failed to post work to the RdbArchiveHistoryProvider_MapWorker thread: " + work, e);
                    }
                }
            }
        }
    }

    private static class RdbArchiveRecordCursor
    implements Cursor<BHistoryRecord> {
        private final Connection conn;
        private final ResultSet rs;
        private final BTimeZone tz;
        private final BRdbmsDeprecatedDialect dialect;
        private final BHistoryRecord templateRecord;
        private final Property[] recordProperties;
        private final int limit;
        private final Context cx;
        private final String debugSummary;
        private final Map<RdbArchiveRecordCursor, Integer> openCursors;
        long lastActiveTicks;
        int counter;
        private long debugStart;
        private boolean skipNext;
        private boolean isClosed;

        RdbArchiveRecordCursor(Connection conn, ResultSet rs, BHistoryConfig config, BHistoryRecord templateRecord, Property[] recordProperties, BRdbms rdbms, BRdbmsDeprecatedDialect dialect, String selectColumns, String rdbHistoryName, BAbsTime startTime, BAbsTime endTime, boolean descending, int limit, String debugSummary, Map<RdbArchiveRecordCursor, Integer> openCursors) throws SQLException, IOException {
            this.conn = conn;
            this.rs = rs;
            this.tz = config.getTimeZone();
            this.dialect = dialect;
            this.templateRecord = templateRecord;
            this.recordProperties = recordProperties;
            this.limit = limit;
            this.debugSummary = debugSummary;
            this.openCursors = openCursors;
            this.lastActiveTicks = Clock.ticks();
            this.cx = this.computeContext(startTime, endTime, descending, selectColumns, rdbHistoryName, rdbms, config);
            long l = this.debugStart = DIAGNOSTIC_LOG_CURSOR.isLoggable(Level.FINE) ? Clock.nanoTicks() : -1L;
            if (this.debugStart < 0L && LOG.isLoggable(Level.FINE)) {
                this.debugStart = Clock.nanoTicks();
            }
        }

        public Context getContext() {
            return this.cx;
        }

        public boolean next() {
            boolean hasNext;
            block11: {
                if (this.skipNext) {
                    this.skipNext = false;
                    return true;
                }
                if (this.isClosed) {
                    return false;
                }
                if (this.counter >= this.limit) {
                    if (this.cx != null) {
                        this.close();
                    }
                    return false;
                }
                try {
                    hasNext = this.rs.next();
                    ++this.counter;
                }
                catch (SQLException e) {
                    hasNext = false;
                    if (!LOG.isLoggable(Level.WARNING)) break block11;
                    LOG.log(Level.WARNING, "Unexpected failure advancing a ResultSet for a history archive query", e);
                }
            }
            if (!hasNext && this.counter > 0) {
                this.counter = -1;
                if (this.debugStart > -1L) {
                    long duration = Clock.nanoTicks() - this.debugStart;
                    if (DIAGNOSTIC_LOG_CURSOR.isLoggable(Level.FINE)) {
                        DiagnosticUtil.completeDuration((long)duration, (String)"RdbArchiveHistoryProvider.timeQueryCursor", (Object)this.debugSummary);
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Took " + (duration /= 1000000L) + " ms to cursor through all records for RDB archive time query: " + this.debugSummary);
                    }
                }
            }
            if (!hasNext && this.cx != null) {
                this.close();
            }
            return hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public BHistoryRecord get() {
            try {
                BHistoryRecord bHistoryRecord = this.decodeRecord(this.rs);
                return bHistoryRecord;
            }
            catch (SQLException e) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.log(Level.WARNING, "Unexpected failure decoding a history record from a ResultSet for a history archive query", e);
                }
                BHistoryRecord bHistoryRecord = null;
                return bHistoryRecord;
            }
            finally {
                if (this.debugStart > -1L && this.counter == this.limit) {
                    long duration = Clock.nanoTicks() - this.debugStart;
                    if (DIAGNOSTIC_LOG_CURSOR.isLoggable(Level.FINE)) {
                        DiagnosticUtil.completeDuration((long)duration, (String)"RdbArchiveHistoryProvider.timeQueryCursor", (Object)this.debugSummary);
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Took " + (duration /= 1000000L) + " ms to cursor through all records for RDB archive time query: " + this.debugSummary);
                    }
                }
            }
        }

        public void close() {
            block6: {
                block5: {
                    if (this.isClosed) {
                        return;
                    }
                    try {
                        this.rs.close();
                    }
                    catch (SQLException e) {
                        if (!LOG.isLoggable(Level.FINE)) break block5;
                        LOG.log(Level.FINE, "Failed to close ResultSet", e);
                    }
                }
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    if (!LOG.isLoggable(Level.FINE)) break block6;
                    LOG.log(Level.FINE, "Failed to close Connection", e);
                }
            }
            this.openCursors.remove(this);
            this.isClosed = true;
        }

        private BHistoryRecord decodeRecord(ResultSet resultSet) throws SQLException {
            for (int i = 0; i < this.recordProperties.length; ++i) {
                Property prop = this.recordProperties[i];
                Type propType = prop.getType();
                BValue propVal = this.dialect.readField(resultSet, propType, i + 1, this.tz);
                if (propVal != null) {
                    this.templateRecord.set(prop, propVal);
                    continue;
                }
                this.templateRecord.set(prop, prop.getDefaultValue());
            }
            return this.templateRecord;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Context computeContext(BAbsTime startTime, BAbsTime endTime, boolean descending, String selectColumns, String rdbHistoryName, BRdbms rdbms, BHistoryConfig historyConfig) throws SQLException, IOException {
            long start;
            long l = start = DIAGNOSTIC_LOG_CONTEXT.isLoggable(Level.FINE) ? Clock.nanoTicks() : -1L;
            if (start < 0L && LOG.isLoggable(Level.FINE)) {
                start = Clock.nanoTicks();
            }
            BHistoryRecord preRec = null;
            BHistoryRecord postRec = null;
            boolean limitExceeded = false;
            try {
                BAbsTime firstRecTime;
                BAbsTime lastRecTime;
                block41: {
                    if (this.next()) {
                        int limitIncludingExtraRec;
                        this.skipNext = true;
                        int totalRecs = this.rs.getInt("RST_SZ_R0B");
                        int n = limitIncludingExtraRec = this.limit == Integer.MAX_VALUE ? this.limit : this.limit + 1;
                        if (totalRecs >= limitIncludingExtraRec) {
                            limitExceeded = true;
                            if (descending) {
                                int lastRecId = this.rs.getInt("LST_ID_R0B");
                                String individualRecQuery = this.dialect.makeIndividualRecordQuerySql(selectColumns, rdbHistoryName);
                                try (PreparedStatement stmt = this.conn.prepareStatement(individualRecQuery);){
                                    stmt.setInt(1, lastRecId);
                                    if (LOG.isLoggable(Level.FINE)) {
                                        String debugSql = QUESTION_MARK_REGEX.matcher(individualRecQuery).replaceFirst(Integer.toString(lastRecId));
                                        LOG.fine("Rdb SQL query to execute to find post record just after the reached limit: " + debugSql);
                                    }
                                    try (ResultSet resultSet = stmt.executeQuery();){
                                        if (resultSet.next()) {
                                            postRec = (BHistoryRecord)this.decodeRecord(resultSet).newCopy(true);
                                        }
                                        break block41;
                                    }
                                }
                            }
                            preRec = (BHistoryRecord)this.decodeRecord(this.rs).newCopy(true);
                            if (!this.rs.next()) {
                                this.skipNext = false;
                            }
                        }
                    }
                }
                BAbsTime bAbsTime = lastRecTime = descending ? startTime : endTime;
                if (postRec == null && lastRecTime != null && !lastRecTime.isNull()) {
                    postRec = this.retrieveBoundaryRecord(lastRecTime, false, !descending, selectColumns, rdbHistoryName, rdbms, historyConfig);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Computed post record: " + postRec);
                }
                BAbsTime bAbsTime2 = firstRecTime = descending ? endTime : startTime;
                if (preRec == null && firstRecTime != null && !firstRecTime.isNull()) {
                    preRec = this.retrieveBoundaryRecord(firstRecTime, true, descending, selectColumns, rdbHistoryName, rdbms, historyConfig);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Computed pre record: " + preRec);
                }
                BFacets cursorContext = HistoryCursor.makeBoundaryRecordFacets(preRec, (BHistoryRecord)postRec);
                if (!limitExceeded) return cursorContext;
                cursorContext = HistoryCursor.makeArchiveLimitExceededContext((Context)cursorContext);
                if (!LOG.isLoggable(Level.FINE)) return cursorContext;
                LOG.fine("Computed query record limit exceeded.");
                return cursorContext;
            }
            finally {
                if (start > -1L) {
                    long duration = Clock.nanoTicks() - start;
                    if (DIAGNOSTIC_LOG_CONTEXT.isLoggable(Level.FINE)) {
                        DiagnosticUtil.completeDuration((long)duration, (String)"RdbArchiveHistoryProvider.computeResultContext", (Object)this.debugSummary);
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Took " + (duration /= 1000000L) + " ms to compute result Context for RDB archive time query: " + this.debugSummary);
                    }
                }
            }
        }

        private BHistoryRecord retrieveBoundaryRecord(BAbsTime referenceRecTime, boolean preOrPost, boolean descending, String selectColumns, String rdbHistoryName, BRdbms rdbms, BHistoryConfig historyConfig) throws SQLException {
            Timestamp ts = null;
            String boundaryRecQuery = this.dialect.makeBoundaryRecordQuerySql(selectColumns, rdbHistoryName, descending);
            try (PreparedStatement stmt = this.conn.prepareStatement(boundaryRecQuery);){
                int parameterIndex = 1;
                if (rdbms.getExportMode().getOrdinal() == 1) {
                    stmt.setString(parameterIndex++, historyConfig.getId().toString());
                }
                long millis = referenceRecTime.getMillis();
                if (this.dialect.supportsTimestamp()) {
                    ts = new Timestamp(millis);
                    Calendar tsCalender = this.dialect.getCalendarForTimestamps();
                    stmt.setTimestamp(parameterIndex, ts, tsCalender);
                } else {
                    stmt.setLong(parameterIndex, millis);
                }
                if (LOG.isLoggable(Level.FINE)) {
                    String debugSql = rdbms.getExportMode().getOrdinal() == 1 ? QUESTION_MARK_REGEX.matcher(boundaryRecQuery).replaceFirst(historyConfig.getId().toString()) : boundaryRecQuery;
                    String preOrPostStr = preOrPost ? "pre" : "post";
                    LOG.fine("Rdb SQL query to execute to find " + preOrPostStr + " record: " + QUESTION_MARK_REGEX.matcher(debugSql).replaceFirst(ts != null ? ts.toString() : Long.toString(millis)));
                }
                try (ResultSet resultSet = stmt.executeQuery();){
                    if (resultSet.next()) {
                        BHistoryRecord bHistoryRecord = (BHistoryRecord)this.decodeRecord(resultSet).newCopy(true);
                        return bHistoryRecord;
                    }
                }
            }
            return null;
        }
    }
}

