/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.aes;

import com.tridium.rdb.aes.AesSysKeyEncoder;
import com.tridium.rdb.aes.BPassKey;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.sys.Action;
import javax.baja.sys.ActionInvokeException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.user.BPasswordStrength;
import javax.baja.user.BUser;
import javax.baja.util.BNotification;
import javax.baja.util.Lexicon;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="passkey", type="BPassword", defaultValue="BPassword.make(\"\")", flags=1), @NiagaraProperty(name="saltString", type="BString", defaultValue="BString.DEFAULT", flags=5)})
@NiagaraAction(name="enterPassKey", parameterType="BPassKey", defaultValue="new BPassKey()")
@NiagaraTopic(name="changeOfPassKey", eventType="BPassword")
public class BRdbSecuritySettings
extends BComponent {
    @Generated
    public static final Property passkey = BRdbSecuritySettings.newProperty((int)1, (BValue)BPassword.make((String)""), null);
    @Generated
    public static final Property saltString = BRdbSecuritySettings.newProperty((int)5, (BValue)BString.DEFAULT, null);
    @Generated
    public static final Action enterPassKey = BRdbSecuritySettings.newAction((int)0, (BValue)new BPassKey(), null);
    @Generated
    public static final Topic changeOfPassKey = BRdbSecuritySettings.newTopic((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbSecuritySettings.class);
    public static final BIcon ICON = BIcon.std((String)"keys.png");
    public static final Logger LOG = Logger.getLogger("rdb");
    public static final Lexicon lex = Lexicon.make((String)"rdb");
    public static final BPasswordStrength RDB_PASSWORD_STRENGTH = BPasswordStrength.DEFAULT;
    private AesSysKeyEncoder encoder;
    private AesSysKeyEncoder sha1Encoder;
    private SecretKey secretKey;
    private SecretKey sha1SecretKey;
    private int symmetricKeyIterationCount = 65536;
    private int keySize = 256;
    private static final String UTF_8 = "UTF-8";
    private static final String SECRET_KEY_FACTORY_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String SECRET_KEY_FACTORY_ALGORITHM_HMACSHA_1 = "PBKDF2WithHmacSHA1";

    @Generated
    public BPassword getPasskey() {
        return (BPassword)this.get(passkey);
    }

    @Generated
    public void setPasskey(BPassword v) {
        this.set(passkey, (BValue)v, null);
    }

    @Generated
    public String getSaltString() {
        return this.getString(saltString);
    }

    @Generated
    public void setSaltString(String v) {
        this.setString(saltString, v, null);
    }

    @Generated
    public void enterPassKey(BPassKey parameter) {
        this.invoke(enterPassKey, (BValue)parameter, null);
    }

    @Generated
    public void fireChangeOfPassKey(BPassword event) {
        this.fire(changeOfPassKey, (BValue)event, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIcon getIcon() {
        return ICON;
    }

    public void changeSecretKey(BPassword userKey1) throws Exception {
        String userKey = AccessController.doPrivileged(() -> ((BPassword)userKey1).getValue());
        this.secretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM).generateSecret(new PBEKeySpec(userKey.toCharArray(), this.getSaltString().getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
        this.encoder.setSecretKey(this.secretKey);
    }

    public AesSysKeyEncoder getEncoder() {
        try {
            block8: {
                block10: {
                    block9: {
                        if (BString.DEFAULT.getString().equals(this.getSaltString())) {
                            this.setSaltString(this.generateSalt());
                        }
                        if (this.secretKey != null) break block8;
                        if (this.getPasskey().isDefault()) break block9;
                        if (AccessController.doPrivileged(() -> ((BPassword)this.getPasskey()).getValue()).length() != 0) break block10;
                    }
                    this.setPasskey(BPassword.make((String)new BigInteger(60, new SecureRandom()).toString(32)));
                }
                this.secretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM).generateSecret(new PBEKeySpec(AccessController.doPrivileged(() -> ((BPassword)this.getPasskey()).getValue()).toCharArray(), this.getSaltString().getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
            }
            if (this.encoder == null) {
                this.encoder = new AesSysKeyEncoder(this.secretKey);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, lex.getText("rdb.rdbSecuritySettings.encoderException.message"), e);
        }
        return this.encoder;
    }

    private String generateSalt() throws Exception {
        SecureRandom random = new SecureRandom();
        byte[] bytes = new byte[20];
        random.nextBytes(bytes);
        return new String(bytes);
    }

    public void stationStarted() throws Exception {
        block3: {
            block2: {
                if (this.getPasskey().isDefault()) break block2;
                if (AccessController.doPrivileged(() -> ((BPassword)this.getPasskey()).getValue()).length() != 0) break block3;
            }
            this.setPasskey(BPassword.make((String)new BigInteger(60, new SecureRandom()).toString(32)));
        }
    }

    public void doEnterPassKey(BPassKey changePassKey, Context cx) throws Exception {
        String message = null;
        String passKey = AccessController.doPrivileged(() -> ((BPassword)this.getPasskey()).getValue());
        String userPassword = AccessController.doPrivileged(() -> ((BPassword)changePassKey.getUserPassword()).getValue());
        String newPassKey = AccessController.doPrivileged(() -> ((BPassword)changePassKey.getNewPassKey()).getValue());
        String confirmPassKey = AccessController.doPrivileged(() -> ((BPassword)changePassKey.getConfirmPassKey()).getValue());
        BUser user = cx.getUser();
        BPasswordAuthenticator auth = (BPasswordAuthenticator)user.getAuthenticator();
        BPassword password = auth.getPassword();
        if (!password.validate(userPassword)) {
            message = lex.getText("rdb.rdbSecuritySettings.incorrectPassword.message");
        } else if (newPassKey.equals(passKey)) {
            message = lex.getText("rdb.rdbSecuritySettings.samePassKey.message");
        } else if (newPassKey.equals("")) {
            message = lex.getText("rdb.rdbSecuritySettings.blankPassKey.message");
        } else if (!newPassKey.equals(confirmPassKey)) {
            message = lex.getText("rdb.rdbSecuritySettings.noMatchPassKey.message");
        } else {
            try {
                RDB_PASSWORD_STRENGTH.isPasswordValid(newPassKey);
            }
            catch (Exception e) {
                message = e.getMessage();
            }
        }
        if (message != null) {
            throw new ActionInvokeException(message, (Throwable)new IllegalArgumentException());
        }
        this.fireChangeOfPassKey(BPassword.make((String)newPassKey));
        BNotification notify = new BNotification();
        notify.add("title", (BValue)BString.make((String)lex.getText("rdb.rdbSecuritySettings.restartStation.title")));
        notify.add("message", (BValue)BString.make((String)lex.getText("rdb.rdbSecuritySettings.restartStation.message")));
        notify.raise(true);
    }

    public AesSysKeyEncoder getHmacSha1Encoder() {
        try {
            if (this.sha1Encoder == null) {
                if (BString.DEFAULT.getString().equals(this.getSaltString())) {
                    this.setSaltString(this.generateSalt());
                }
                this.sha1SecretKey = SecretKeyFactory.getInstance(SECRET_KEY_FACTORY_ALGORITHM_HMACSHA_1).generateSecret(new PBEKeySpec(AccessController.doPrivileged(() -> ((BPassword)this.getPasskey()).getValue()).toCharArray(), this.getSaltString().getBytes(UTF_8), this.symmetricKeyIterationCount, this.keySize));
                this.sha1Encoder = new AesSysKeyEncoder(this.sha1SecretKey);
            }
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, lex.getText("rdb.rdbSecuritySettings.encoderException.message"), e);
        }
        return this.sha1Encoder;
    }
}

