/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxActive", type="int", defaultValue="30"), @NiagaraProperty(name="maxIdle", type="int", defaultValue="10"), @NiagaraProperty(name="maxWait", type="int", defaultValue="5000"), @NiagaraProperty(name="loginTimeout", type="int", defaultValue="0"), @NiagaraProperty(name="updatePeriod", type="BRelTime", defaultValue="BRelTime.make(1000)"), @NiagaraProperty(name="numActive", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="peakNumActive", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="numIdle", type="int", defaultValue="0", flags=3)})
@NiagaraAction(name="updateConnectionStats")
public abstract class BAbstractConnectionPool
extends BComponent {
    @Generated
    public static final Property maxActive = BAbstractConnectionPool.newProperty((int)0, (int)30, null);
    @Generated
    public static final Property maxIdle = BAbstractConnectionPool.newProperty((int)0, (int)10, null);
    @Generated
    public static final Property maxWait = BAbstractConnectionPool.newProperty((int)0, (int)5000, null);
    @Generated
    public static final Property loginTimeout = BAbstractConnectionPool.newProperty((int)0, (int)0, null);
    @Generated
    public static final Property updatePeriod = BAbstractConnectionPool.newProperty((int)0, (BValue)BRelTime.make((long)1000L), null);
    @Generated
    public static final Property numActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property peakNumActive = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property numIdle = BAbstractConnectionPool.newProperty((int)3, (int)0, null);
    @Generated
    public static final Action updateConnectionStats = BAbstractConnectionPool.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAbstractConnectionPool.class);
    private static final Logger LOG = Logger.getLogger("rdb");
    private Clock.Ticket updateTicket;
    private Object lock = new Object();

    @Generated
    public int getMaxActive() {
        return this.getInt(maxActive);
    }

    @Generated
    public void setMaxActive(int v) {
        this.setInt(maxActive, v, null);
    }

    @Generated
    public int getMaxIdle() {
        return this.getInt(maxIdle);
    }

    @Generated
    public void setMaxIdle(int v) {
        this.setInt(maxIdle, v, null);
    }

    @Generated
    public int getMaxWait() {
        return this.getInt(maxWait);
    }

    @Generated
    public void setMaxWait(int v) {
        this.setInt(maxWait, v, null);
    }

    @Generated
    public int getLoginTimeout() {
        return this.getInt(loginTimeout);
    }

    @Generated
    public void setLoginTimeout(int v) {
        this.setInt(loginTimeout, v, null);
    }

    @Generated
    public BRelTime getUpdatePeriod() {
        return (BRelTime)this.get(updatePeriod);
    }

    @Generated
    public void setUpdatePeriod(BRelTime v) {
        this.set(updatePeriod, (BValue)v, null);
    }

    @Generated
    public int getNumActive() {
        return this.getInt(numActive);
    }

    @Generated
    public void setNumActive(int v) {
        this.setInt(numActive, v, null);
    }

    @Generated
    public int getPeakNumActive() {
        return this.getInt(peakNumActive);
    }

    @Generated
    public void setPeakNumActive(int v) {
        this.setInt(peakNumActive, v, null);
    }

    @Generated
    public int getNumIdle() {
        return this.getInt(numIdle);
    }

    @Generated
    public void setNumIdle(int v) {
        this.setInt(numIdle, v, null);
    }

    @Generated
    public void updateConnectionStats() {
        this.invoke(updateConnectionStats, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == updatePeriod) {
            if (this.updateTicket != null) {
                this.updateTicket.cancel();
            }
            this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
        }
    }

    public void subscribed() {
        this.updateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)this.getUpdatePeriod(), (Action)updateConnectionStats, null);
    }

    public void unsubscribed() {
        if (this.updateTicket != null) {
            this.updateTicket.cancel();
        }
    }

    public abstract void doUpdateConnectionStats();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Connection getConnection(String userName, String password) throws SQLException {
        int timeout = this.getLoginTimeout();
        LOG.fine("pool.getConnection, timeout: " + timeout);
        if (timeout < 0) {
            throw new BajaRuntimeException("loginTimeout cannot be less than zero.");
        }
        if (timeout == 0) {
            Object object = this.lock;
            synchronized (object) {
                return this.obtainConnection(userName, password);
            }
        }
        Producer producer = new Producer(this, userName, password);
        new Thread(producer).start();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!producer.isFinished()) {
            LOG.fine("pool.getConnection, timed out, timeout: " + timeout);
            throw new BajaRuntimeException("pool.getConnection, timed out, timeout: " + timeout);
        }
        if (producer.getException() == null) {
            return producer.getConnection();
        }
        throw producer.getException();
    }

    protected abstract Connection obtainConnection(String var1, String var2) throws SQLException;

    private static class Producer
    extends Thread {
        private final BAbstractConnectionPool pool;
        private final String userName;
        private final String password;
        private boolean finished;
        private Connection connection;
        private SQLException exception;

        private Producer(BAbstractConnectionPool pool, String userName, String password) {
            this.pool = pool;
            this.userName = userName;
            this.password = password;
            this.finished = false;
            this.connection = null;
            this.exception = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = this.pool.lock;
                synchronized (object) {
                    this.connection = this.pool.obtainConnection(this.userName, this.password);
                    this.finished = true;
                    this.pool.lock.notifyAll();
                }
            }
            catch (SQLException e) {
                Producer producer = this;
                synchronized (producer) {
                    this.exception = e;
                }
            }
        }

        private synchronized boolean isFinished() {
            return this.finished;
        }

        private synchronized SQLException getException() {
            return this.exception;
        }

        private synchronized Connection getConnection() {
            return this.connection;
        }
    }
}

