/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.EvalOnIterator;
import com.tridium.neql.NeqlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.baja.data.BIDataValue;
import javax.baja.neql.BinaryExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public abstract class ComparisonExpression
extends BinaryExpression {
    protected ComparisonExpression(Expression left, Expression right) {
        super(left, right);
    }

    public Collection<BBoolean> evaluate(Entity entity, Context context) {
        Collection<?> rightSide = this.getRight().evaluate(entity, context);
        int rightSideCount = rightSide.size();
        if (rightSide.isEmpty()) {
            return SINGLE_FALSE;
        }
        Collection<?> leftSide = this.getLeft().evaluate(entity, context);
        int leftSideCount = leftSide.size();
        if (leftSide.isEmpty()) {
            return SINGLE_FALSE;
        }
        if (rightSideCount > 1 && leftSideCount > 1) {
            return SINGLE_TRUE;
        }
        if (rightSideCount == 1) {
            BIDataValue rightValue = (BIDataValue)rightSide.iterator().next();
            LinkedList<BBoolean> evaluations = new LinkedList<BBoolean>();
            for (BIDataValue leftValue : leftSide) {
                BBoolean result = this.compareValues(leftValue, rightValue);
                if (result == null) continue;
                evaluations.add(result);
            }
            return evaluations;
        }
        BIDataValue leftValue = (BIDataValue)leftSide.iterator().next();
        LinkedList<BBoolean> evaluations = new LinkedList<BBoolean>();
        for (BIDataValue rightValue : rightSide) {
            BBoolean result = this.compareValues(leftValue, rightValue);
            if (result == null) continue;
            evaluations.add(result);
        }
        return evaluations;
    }

    protected BBoolean compareValues(BIDataValue left, BIDataValue right) {
        Integer result = NeqlUtil.compareValues(left, right);
        if (result != null) {
            return this.getComparisonResult(result);
        }
        return null;
    }

    protected abstract BBoolean getComparisonResult(Integer var1);

    @Override
    protected final boolean evalBoolean(Entity entity, Context context) {
        boolean isRightEvalOn;
        Expression left = this.getLeft();
        Expression right = this.getRight();
        boolean isLeftEvalOn = left.getNodeType() == 19;
        boolean bl = isRightEvalOn = right.getNodeType() == 19;
        if (isLeftEvalOn && isRightEvalOn) {
            return this.areAnyComparisonsValid((EvalOnExpression)left, (EvalOnExpression)right, entity, context);
        }
        if (isLeftEvalOn) {
            BIDataValue rightValue = ComparisonExpression.getSingleValue(right, entity, context);
            return rightValue != null && this.areAnyLeftValuesValid((EvalOnExpression)left, rightValue, entity, context);
        }
        if (isRightEvalOn) {
            BIDataValue leftValue = ComparisonExpression.getSingleValue(left, entity, context);
            return leftValue != null && this.areAnyRightValuesValid(leftValue, (EvalOnExpression)right, entity, context);
        }
        BIDataValue leftValue = ComparisonExpression.getSingleValue(left, entity, context);
        if (leftValue == null) {
            return false;
        }
        BIDataValue rightValue = ComparisonExpression.getSingleValue(right, entity, context);
        if (rightValue == null) {
            return false;
        }
        return this.isComparisonValid(leftValue, rightValue);
    }

    private boolean areAnyComparisonsValid(EvalOnExpression left, EvalOnExpression right, Entity entity, Context context) {
        ArrayList<BIDataValue> rightValues = null;
        EvalOnIterator leftIterator = EvalOnIterator.make(left, entity, context);
        while (leftIterator.hasNext()) {
            BIDataValue leftValue = BinaryExpression.getSingleValue(left.getExpression(), leftIterator.next(), context);
            if (leftValue == null) continue;
            if (rightValues == null) {
                rightValues = new ArrayList<BIDataValue>();
                EvalOnIterator rightIterator = EvalOnIterator.make(right, entity, context);
                while (rightIterator.hasNext()) {
                    BIDataValue rightValue = BinaryExpression.getSingleValue(right.getExpression(), rightIterator.next(), context);
                    if (rightValue == null) continue;
                    if (this.isComparisonValid(leftValue, rightValue)) {
                        return true;
                    }
                    rightValues.add(rightValue);
                }
                continue;
            }
            for (BIDataValue rightValue : rightValues) {
                if (!this.isComparisonValid(leftValue, rightValue)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areAnyLeftValuesValid(EvalOnExpression left, BIDataValue rightValue, Entity entity, Context context) {
        EvalOnIterator iterator = EvalOnIterator.make(left, entity, context);
        while (iterator.hasNext()) {
            BIDataValue leftValue = BinaryExpression.getSingleValue(left.getExpression(), iterator.next(), context);
            if (leftValue == null || !this.isComparisonValid(leftValue, rightValue)) continue;
            return true;
        }
        return false;
    }

    private boolean areAnyRightValuesValid(BIDataValue leftValue, EvalOnExpression right, Entity entity, Context context) {
        EvalOnIterator iterator = EvalOnIterator.make(right, entity, context);
        while (iterator.hasNext()) {
            BIDataValue rightValue = BinaryExpression.getSingleValue(right.getExpression(), iterator.next(), context);
            if (rightValue == null || !this.isComparisonValid(leftValue, rightValue)) continue;
            return true;
        }
        return false;
    }

    protected abstract boolean isComparisonValid(BIDataValue var1, BIDataValue var2);
}

