/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.vykon.vykonPro.hvac.BZoneInfo;
import com.vykon.vykonPro.hvac.BZoneListExt;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BFrame;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.view.BWbComponentView;

public class BZoneListView
extends BWbComponentView {
    public static final Property showTitle = BZoneListView.newProperty((int)0, (boolean)true, null);
    public static final Property hyperlink = BZoneListView.newProperty((int)0, (BValue)BOrd.make((String)"slot:"), (BFacets)BFacets.make((String)"chooseView", (BIDataValue)BBoolean.FALSE));
    public static final Property sortAscending = BZoneListView.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BZoneListView.class);
    public static final BFont appFont = BFont.make((String)"11pt Tahoma");
    public static final BFont appBoldFont = BFont.make((String)"bold 11pt Tahoma");
    public static final UiLexicon lexicon = UiLexicon.makeUiLexicon(BZoneListView.class);
    static final BBrush appRGB = BColor.make((int)200, (int)200, (int)200).toBrush();
    BComponentTable zoneTable = null;
    BZoneListExt base = null;
    BLabel titleLabel = new BLabel("", appBoldFont);
    BZoneInfo[] zones;

    public boolean getShowTitle() {
        return this.getBoolean(showTitle);
    }

    public void setShowTitle(boolean v) {
        this.setBoolean(showTitle, v, null);
    }

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd v) {
        this.set(hyperlink, (BValue)v, null);
    }

    public boolean getSortAscending() {
        return this.getBoolean(sortAscending);
    }

    public void setSortAscending(boolean v) {
        this.setBoolean(sortAscending, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BZoneListView() {
        BFrame mainFrame = new BFrame();
        BBorderPane mainBorderPane = new BBorderPane();
        mainFrame.setContent((BWidget)mainBorderPane);
        mainBorderPane.setContent(this.buildZoneTable());
        this.setContent((BWidget)mainFrame);
        this.zoneTable.repaint();
    }

    private BWidget buildZoneTable() {
        BEdgePane edgePane = new BEdgePane();
        ComponentTableModel.Column[] columns = new ComponentTableModel.Column[]{new ComponentTableModel.PropertyColumn(BZoneInfo.zoneId), new ComponentTableModel.PropertyColumn(BZoneInfo.out)};
        this.zoneTable = new BComponentTable();
        this.zoneTable.setModel((TableModel)new ZoneTableModel());
        this.zoneTable.setMultipleSelection(false);
        this.zoneTable.setController((TableController)new ZoneTableController());
        this.zoneTable.sortByColumn(1, this.getSortAscending());
        ComponentTableModel ctm = (ComponentTableModel)this.zoneTable.getModel();
        ctm.setColumns(columns);
        edgePane.setTop((BWidget)this.titleLabel);
        BBorderPane bpane = new BBorderPane((BWidget)this.zoneTable);
        edgePane.setCenter((BWidget)bpane);
        return edgePane;
    }

    public void doLoadValue(BObject value, Context cx) {
        this.base = (BZoneListExt)value;
        this.zones = (BZoneInfo[])this.base.getChildren(BZoneInfo.class);
        BComponent.lease((BComponent[])this.zones, (int)1);
        ComponentTableModel m = (ComponentTableModel)this.zoneTable.getModel();
        m.addRows((BComponent[])this.zones);
        if (this.getShowTitle()) {
            this.titleLabel.setText(String.valueOf(this.base.getParent().getDisplayName(cx)) + " - Out Of Range Zones");
            this.titleLabel.setVisible(true);
        } else {
            this.titleLabel.setVisible(false);
        }
        this.registerForComponentEvents((BComponent)this.base, 1);
        m.sortByColumn(1, this.getSortAscending());
    }

    public void handleComponentEvent(BComponentEvent event) {
        int id = event.getId();
        String name = event.getSlotName();
        ComponentTableModel m = (ComponentTableModel)this.zoneTable.getModel();
        switch (id) {
            case 1: {
                BZoneInfo zi = (BZoneInfo)this.base.get(name);
                m.addRow((BComponent)zi);
                break;
            }
            case 2: {
                m.removeRow(name);
            }
        }
        m.sortByColumn(1, this.getSortAscending());
        m.updateTable();
        this.zoneTable.repaint();
    }

    static class Row {
        String name;
        BImage icon;
        BComponent component;

        Row(BComponent component) {
            this.component = component;
            this.name = component.getName();
            this.icon = BImage.make((BIcon)component.getIcon());
        }

        BImage getIcon() {
            if (this.component.isPendingMove()) {
                return this.icon.getDisabledImage();
            }
            return this.icon;
        }
    }

    class ZoneTableModel
    extends ComponentTableModel {
        ZoneTableModel() {
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Zone ID";
                }
                case 1: {
                    return "Value";
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            BComponent[] zonelist = this.getRows();
            if (col == 0) {
                return BString.make((String)zonelist[row].get("zoneId").toString());
            }
            if (col == 1) {
                BFacets f = (BFacets)zonelist[row].get("facets");
                BStatusNumeric num = (BStatusNumeric)zonelist[row].get("out");
                return BString.make((String)BDouble.toString((double)num.getValue(), (Context)f));
            }
            return BString.make((String)"-");
        }

        public boolean isColumnSortable(int col) {
            return true;
        }
    }

    class ZoneTableController
    extends ComponentTableController {
        ZoneTableController() {
        }

        protected void cellDoubleClicked(BMouseEvent event, int row, int column) {
            BComponent comp = ((BComponentTable)this.getTable()).getComponentAt(row);
            BWbShell shell = BZoneListView.this.getWbShell();
            if (comp != null && shell != null) {
                BOrd baseOrd = BOrd.make((BOrd)shell.getActiveOrd(), (BOrd)((BOrd)comp.get("ord")));
                shell.hyperlink(new HyperlinkInfo(BOrd.make((BOrd)baseOrd, (BOrd)BZoneListView.this.getHyperlink()).normalize(), (BInputEvent)event));
                return;
            }
            super.cellDoubleClicked(event, row, column);
        }
    }
}

