/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.ui;

import com.tridium.nv.NiagaraVirtualUtil;
import com.tridium.ui.theme.LabelTheme;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.shell.BNiagaraWbApplet;
import com.vykon.vykonPro.ui.BIAppletLinks;
import java.net.URL;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BIcon;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.virtual.BVirtualComponent;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.BWbShell;

public class BHyperlinkListSelector
extends BFlowPane {
    public static final Property ord = BHyperlinkListSelector.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property font = BHyperlinkListSelector.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property linkList = BHyperlinkListSelector.newProperty((int)0, (BValue)new BListDropDown(), null);
    public static final Property linkButton = BHyperlinkListSelector.newProperty((int)0, (BValue)BHyperlinkListSelector.makeLinkButton(), null);
    public static final Property wbTarget = BHyperlinkListSelector.newProperty((int)0, (BValue)BDynamicEnum.make((int)0, (BEnumRange)BEnumRange.make((Type)BHyperlinkMode.TYPE)), null);
    public static final Property browserTarget = BHyperlinkListSelector.newProperty((int)0, (String)"_self", null);
    public static final Action actionPerf = BHyperlinkListSelector.newAction((int)0, null);
    public static final Action buttonMouseEvent = BHyperlinkListSelector.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType(BHyperlinkListSelector.class);
    private static final BIcon icon = BIcon.std((String)"hyperlink.png");
    public static final UiLexicon lexicon = new UiLexicon(BHyperlinkListSelector.class);
    private static BModule module = Sys.getModuleForClass(BHyperlinkListSelector.class);
    private BComponent hll = null;
    private BVirtualGateway gw = null;
    private BObject base = null;
    private BString[] linkNames = null;
    private BOrd[] linkOrds = null;
    private BBoolean[] linkExt = null;
    private BFont widgetFont = this.getFont();

    public BOrd getOrd() {
        return (BOrd)this.get(ord);
    }

    public void setOrd(BOrd v) {
        this.set(ord, (BValue)v, null);
    }

    public BFont getFont() {
        return (BFont)this.get(font);
    }

    public void setFont(BFont v) {
        this.set(font, (BValue)v, null);
    }

    public BListDropDown getLinkList() {
        return (BListDropDown)this.get(linkList);
    }

    public void setLinkList(BListDropDown v) {
        this.set(linkList, (BValue)v, null);
    }

    public BButton getLinkButton() {
        return (BButton)this.get(linkButton);
    }

    public void setLinkButton(BButton v) {
        this.set(linkButton, (BValue)v, null);
    }

    public BEnum getWbTarget() {
        return (BEnum)this.get(wbTarget);
    }

    public void setWbTarget(BEnum v) {
        this.set(wbTarget, (BValue)v, null);
    }

    public String getBrowserTarget() {
        return this.getString(browserTarget);
    }

    public void setBrowserTarget(String v) {
        this.setString(browserTarget, v, null);
    }

    public void actionPerf() {
        this.invoke(actionPerf, null, null);
    }

    public void buttonMouseEvent(BMouseEvent event) {
        this.invoke(buttonMouseEvent, (BValue)event, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        BButton b = this.getLinkButton();
        b.setCommand((Command)new Hyperlink(), false, false);
        this.initializeList();
        this.getLinkList().setEnabled(true);
        this.linkTo("link0", (BComponent)this.getLinkList().getList(), (Slot)BList.actionPerformed, (Slot)actionPerf);
        this.linkTo("link1", (BComponent)this.getLinkButton(), (Slot)BButton.mouseEvent, (Slot)buttonMouseEvent);
    }

    public BHyperlinkListSelector() {
        if (this.widgetFont.isNull()) {
            this.widgetFont = this.theme().getTextFont((IStylable)this);
        }
    }

    private static BButton makeLinkButton() {
        BButton b = new BButton();
        b.setButtonStyle(BButtonStyle.normal);
        b.setText("Hyperlink");
        b.setImage(BImage.make((BOrd)BOrd.make((String)"module://icons/x16/hyperlink.png")));
        return b;
    }

    public void changed(Property prop, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(ord)) {
            this.initializeList();
        }
    }

    public void initializeList() {
        int i;
        BWidgetShell shell = this.getShell();
        if (shell != null && this.getOrd() != BOrd.NULL && shell instanceof BWbShell) {
            this.base = ((BWbShell)this.getShell()).getActiveOrdTarget().get();
            this.hll = (BComponent)this.getOrd().resolve(this.base).get();
            this.hll.lease(1);
            this.linkNames = (BString[])this.hll.getChildren(BString.class);
            this.linkOrds = (BOrd[])this.hll.getChildren(BOrd.class);
            this.linkExt = new BBoolean[this.linkOrds.length];
            for (i = 0; i < this.linkOrds.length; ++i) {
                this.linkExt[i] = this.hll.get("external" + (i + 1)) != null ? (BBoolean)this.hll.get("external" + (i + 1)) : BBoolean.make((boolean)false);
            }
            if (this.hll instanceof BVirtualComponent) {
                BVirtualComponent vcomp = (BVirtualComponent)this.hll;
                this.gw = vcomp.getVirtualGateway();
            }
        }
        if (this.linkNames != null && this.linkOrds != null && this.linkNames.length > 0 && this.linkOrds.length > 0) {
            for (i = 0; i < this.linkNames.length; ++i) {
                this.getLinkList().getList().addItem((Object)this.linkNames[i].getString());
            }
            this.getLinkList().setSelectedIndex(0);
        }
    }

    public void doActionPerf() {
        int item = this.getLinkList().getList().getSelection().getItem();
        this.getLinkList().closeDropDown();
        this.getLinkList().setSelectedIndex(item);
    }

    public void doButtonMouseEvent(BMouseEvent event) {
        BWidgetShell shell;
        if (event.getId() == 504) {
            BWidgetShell shell2 = this.getShell();
            if (shell2 != null) {
                shell2.showStatus(this.toShowStatus());
                this.getLinkButton().setMouseCursor(MouseCursor.hand);
            }
        } else if (event.getId() == 505 && (shell = this.getShell()) != null) {
            shell.showStatus("");
            this.getLinkButton().setMouseCursor(MouseCursor.normal);
        }
    }

    String toShowStatus() {
        BWidgetShell shell;
        if (this.linkOrds == null) {
            return "";
        }
        BOrd hyperlink = this.linkOrds[this.getLinkList().getSelectedIndex()];
        boolean external = this.linkExt[this.getLinkList().getSelectedIndex()].getBoolean();
        if (hyperlink.isNull()) {
            return "";
        }
        if (!external && this.gw != null) {
            hyperlink = BOrd.make((BOrd)this.gw.getNavOrd().relativizeToSession(), (OrdQuery)NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)BOrd.make((String)"slot:/"), (BOrd)hyperlink));
        }
        if ((shell = this.getShell()) instanceof BNiagaraWbApplet) {
            return "Link to " + hyperlink + " | target " + this.getBrowserTarget();
        }
        if (shell instanceof BIHyperlinkShell) {
            return "Link to " + hyperlink + " | target " + this.getWbTarget();
        }
        return "Link to ";
    }

    public BIcon getIcon() {
        return icon;
    }

    LabelTheme theme() {
        return Theme.label();
    }

    class Hyperlink
    extends Command {
        public Hyperlink() {
            super((BWidget)BHyperlinkListSelector.this, module, "hyperlinkListSelector.hyperlink");
        }

        public CommandArtifact doInvoke(CommandEvent cmdEvent) {
            try {
                BWidgetShell shell;
                BOrd ord = BHyperlinkListSelector.this.linkOrds[BHyperlinkListSelector.this.getLinkList().getSelectedIndex()];
                boolean external = BHyperlinkListSelector.this.linkExt[BHyperlinkListSelector.this.getLinkList().getSelectedIndex()].getBoolean();
                if (BHyperlinkListSelector.this.gw != null && !external) {
                    ord = BOrd.make((BOrd)BHyperlinkListSelector.this.gw.getNavOrd().relativizeToSession(), (OrdQuery)NiagaraVirtualUtil.fromServerOrdToClientVirtual((BOrd)BOrd.make((String)"slot:/"), (BOrd)ord));
                }
                BInputEvent inputEvent = null;
                if (cmdEvent != null) {
                    inputEvent = cmdEvent.getInputEvent();
                }
                if ((shell = this.getShell()) instanceof BNiagaraWbApplet) {
                    try {
                        BNiagaraWbApplet wbapp = (BNiagaraWbApplet)shell;
                        URL url = wbapp.ordToUrl(ord);
                        BIAppletLinks.hyperlink(wbapp, url, BHyperlinkListSelector.this.getBrowserTarget());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (shell instanceof BIHyperlinkShell) {
                    if (!external) {
                        ord = BOrd.make((BOrd)((BWbShell)shell).getActiveOrd(), (BOrd)ord).normalize();
                    }
                    switch (BHyperlinkListSelector.this.getWbTarget().getOrdinal()) {
                        case 0: {
                            ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, inputEvent));
                            break;
                        }
                        case 2: {
                            BHyperlinkMode hyperlinkmode = BHyperlinkMode.make((String)"newShell");
                            ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, hyperlinkmode));
                            break;
                        }
                        case 1: {
                            BHyperlinkMode hyperlinkmode = BHyperlinkMode.make((String)"newTab");
                            ((BIHyperlinkShell)shell).hyperlink(new HyperlinkInfo(ord, hyperlinkmode));
                        }
                    }
                }
            }
            catch (Exception e) {
                BDialog.error((BWidget)this.getOwner(), (String)"Error", (Object)"Hyperlink Failed.", (Throwable)e);
            }
            return null;
        }

        public String getLabel() {
            return null;
        }
    }
}

