/*
 * Decompiled with CFR 0.152.
 */
package com.vykon.vykonPro.exporters;

import com.tridium.pdf.BPdfFlowPane;
import com.tridium.pdf.BWidgetToPdf;
import com.tridium.pdf.gx.PdfDocument;
import com.vykon.vykonPro.history.BPeakTracker;
import javax.baja.gx.BFont;
import javax.baja.pdf.BPdfExporter;
import javax.baja.pdf.PdfOp;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class BPeakTrackerViewPdf
extends BPdfExporter {
    public static final Type TYPE = Sys.loadType(BPeakTrackerViewPdf.class);
    BPeakTracker base = null;
    BTable peakTable = new BTable();
    BFacets f = null;
    BStatusNumeric num = null;
    public static final UiLexicon monthLex = UiLexicon.makeUiLexicon(BMonth.class);

    public Type getType() {
        return TYPE;
    }

    public void export(PdfOp op) throws Exception {
        int width = op.getWidth();
        int height = op.getHeight();
        if (height > width) {
            width = op.getHeight();
            height = op.getWidth();
        }
        this.base = (BPeakTracker)op.get();
        PdfDocument doc = new PdfDocument(op.getOutputStream(), width, height);
        BWidgetToPdf exporter = new BWidgetToPdf();
        exporter.renderDocument(this.getMainFrame(), doc, op);
    }

    public BWidget getMainFrame() {
        BPdfFlowPane flow = new BPdfFlowPane();
        BLabel titleLabel = new BLabel(this.base.getDisplayName(null) + " - Monthly Peak Values");
        titleLabel.setFont(BFont.make((String)"24pt Tahoma"));
        titleLabel.setHalign(BHalign.make((String)"center"));
        flow.add(null, (BValue)titleLabel);
        flow.add(null, (BValue)this.buildPane());
        flow.setupPane();
        return flow;
    }

    private BWidget buildPane() {
        BBorderPane bpane = new BBorderPane((BWidget)this.buildPeakTable());
        return bpane;
    }

    private BTable buildPeakTable() {
        this.peakTable.setModel((TableModel)new PeakTrackerTableModel());
        this.peakTable.setMultipleSelection(false);
        return this.peakTable;
    }

    class PeakTrackerTableModel
    extends TableModel {
        PeakTrackerTableModel() {
        }

        public int getRowCount() {
            return 12;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return "Month";
                }
                case 1: {
                    return "Timestamp";
                }
                case 2: {
                    return "Value";
                }
            }
            throw new IllegalStateException();
        }

        public Object getValueAt(int row, int col) {
            int i;
            if (col == 0) {
                for (int i2 = 0; i2 < 12; ++i2) {
                    if (row != i2) continue;
                    return monthLex.getText(BMonth.make((int)i2).getTag());
                }
            }
            if (col == 1) {
                Object[] tstamps = BPeakTrackerViewPdf.this.base.getChildren(BAbsTime.class);
                for (i = 0; i < 12; ++i) {
                    if (row != i) continue;
                    return tstamps[i + 1];
                }
            }
            if (col == 2) {
                Object[] peaks = BPeakTrackerViewPdf.this.base.getChildren(BStatusNumeric.class);
                BPeakTrackerViewPdf.this.f = BPeakTrackerViewPdf.this.base.getFacets();
                for (i = 0; i < 12; ++i) {
                    if (row != i) continue;
                    BPeakTrackerViewPdf.this.num = (BStatusNumeric)peaks[i + 1];
                    return BString.make((String)BDouble.toString((double)BPeakTrackerViewPdf.this.num.getValue(), (Context)BPeakTrackerViewPdf.this.f));
                }
            }
            return "";
        }

        public boolean isColumnSortable(int col) {
            return false;
        }

        public void sortByColumn(int col, boolean ascending) {
            if (col == 0) {
                System.out.println("sort by column for col 1 ");
            }
        }
    }
}

